/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_imgproc;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point3f;
import org.bytedeco.opencv.presets.opencv_imgproc;

@Name(value={"std::vector<cv::Vec3f>"})
@Properties(inherit={opencv_imgproc.class})
public class Vec3fVector
extends Pointer {
    public Vec3fVector(Pointer p) {
        super(p);
    }

    public Vec3fVector(Point3f value) {
        this(1L);
        this.put(0L, value);
    }

    public Vec3fVector(Point3f ... array) {
        this(array.length);
        this.put(array);
    }

    public Vec3fVector() {
        this.allocate();
    }

    public Vec3fVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native Vec3fVector put(@ByRef Vec3fVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @Cast(value={"cv::Vec3f*"})
    @ByRef
    public native Point3f get(@Cast(value={"size_t"}) long var1);

    public native Vec3fVector put(@Cast(value={"size_t"}) long var1, Point3f var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @Cast(value={"cv::Vec3f*"}) @ByRef Point3f var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point3f[] get() {
        Point3f[] array = new Point3f[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point3f pop_back() {
        long size = this.size();
        Point3f value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public Vec3fVector push_back(Point3f value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public Vec3fVector put(Point3f value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Vec3fVector put(Point3f ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @Cast(value={"cv::Vec3f*"})
        @ByRef
        @Const
        public native Point3f get();
    }
}

