/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import org.jasig.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class QueryDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    @NotNull
    private String sql;

    protected final Principal authenticateUsernamePasswordInternal(String username, String password) throws GeneralSecurityException, PreventedException {
        String encryptedPassword = this.getPasswordEncoder().encode(password);
        try {
            String dbPassword = (String)this.getJdbcTemplate().queryForObject(this.sql, String.class, new Object[]{username});
            if (!dbPassword.equals(encryptedPassword)) {
                throw new FailedLoginException("Password does not match value on record.");
            }
        }
        catch (IncorrectResultSizeDataAccessException e) {
            if (e.getActualSize() == 0) {
                throw new AccountNotFoundException(username + " not found with SQL query");
            }
            throw new FailedLoginException("Multiple records found for " + username);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
        return new SimplePrincipal(username);
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

