/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.net.SocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDPEndPoint;
import udt.UDTPacket;
import udt.UDTSession;
import udt.UDTSocket;
import udt.packets.ConnectionHandshake;
import udt.packets.Destination;
import udt.packets.Shutdown;

public class ClientSession
extends UDTSession {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UDPEndPoint endPoint;

    public ClientSession(UDPEndPoint endPoint, Destination dest) throws SocketException {
        super("ClientSession localPort=" + endPoint.getLocalPort(), dest);
        this.endPoint = endPoint;
        this.logger.info("Created " + this.toString());
    }

    public void connect() throws InterruptedException, IOException {
        int n = 0;
        this.sendHandShake();
        while (this.getState() != 2) {
            if (this.getState() == 99) {
                throw new IOException("Can't connect!");
            }
            ++n;
            if (this.getState() == 2) continue;
            this.logger.info("Sleeping");
            Thread.sleep(500L);
        }
        this.logger.info("Initing...");
        this.cc.init();
        this.logger.info("Connected, " + n + " handshake packets sent");
    }

    @Override
    public void received(UDTPacket packet, Destination peer) {
        this.lastPacket = packet;
        if (this.getState() != 2 && packet instanceof ConnectionHandshake) {
            try {
                this.logger.info("Received connection handshake from " + peer);
                this.setState(2);
                long peerSocketID = ((ConnectionHandshake)packet).getSocketID();
                this.destination.setSocketID(peerSocketID);
                this.socket = new UDTSocket(this.endPoint, this);
            }
            catch (Exception ex) {
                this.logger.warn("Error creating socket", (Throwable)ex);
                this.setState(99);
            }
            return;
        }
        if (this.getState() == 2) {
            if (packet instanceof Shutdown) {
                this.setState(4);
                this.active = false;
                this.logger.info("Connection shutdown initiated by the other side.");
                return;
            }
            this.active = true;
            try {
                if (packet.forSender()) {
                    this.socket.getSender().receive(this.lastPacket);
                } else {
                    this.socket.getReceiver().receive(this.lastPacket);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error receiving", (Throwable)ex);
                this.setState(99);
            }
            return;
        }
    }

    protected void sendHandShake() throws IOException {
        ConnectionHandshake handshake = new ConnectionHandshake();
        handshake.setConnectionType(1L);
        handshake.setSocketType(1L);
        handshake.setInitialSeqNo(1L);
        handshake.setPacketSize(this.getDatagramSize());
        handshake.setSocketID(this.mySocketID);
        handshake.setSession(this);
        this.logger.info("Handshake to " + this.getDestination());
        this.endPoint.doSend(handshake);
        this.logger.info("Sent handshake");
    }

    public UDTPacket getLastPkt() {
        return this.lastPacket;
    }
}

