/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDPEndPoint;
import udt.UDTPacket;
import udt.UDTSession;
import udt.UDTSocket;
import udt.packets.ConnectionHandshake;
import udt.packets.Destination;
import udt.packets.KeepAlive;
import udt.packets.Shutdown;

public class ServerSession
extends UDTSession {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UDPEndPoint endPoint;
    private UDTPacket lastPacket;
    int n_handshake = 0;

    public ServerSession(DatagramPacket dp, UDPEndPoint endPoint) throws SocketException, UnknownHostException {
        super("ServerSession localPort=" + endPoint.getLocalPort() + " peer=" + dp.getAddress() + ":" + dp.getPort(), new Destination(dp.getAddress(), dp.getPort()));
        this.endPoint = endPoint;
        this.logger.info("Created " + this.toString() + " talking to " + this.getDestination());
    }

    @Override
    public void received(UDTPacket packet, Destination peer) {
        this.lastPacket = packet;
        if (this.getState() <= 2 && packet instanceof ConnectionHandshake) {
            this.logger.info("Received ConnectionHandshake from " + peer);
            ConnectionHandshake connectionHandshake = (ConnectionHandshake)packet;
            this.destination.setSocketID(connectionHandshake.getSocketID());
            if (this.getState() <= 1) {
                this.setState(1);
            }
            try {
                this.sendResponseHandShake(connectionHandshake, peer);
                ++this.n_handshake;
                try {
                    this.setState(2);
                    this.socket = new UDTSocket(this.endPoint, this);
                    this.cc.init();
                }
                catch (Exception uhe) {
                    this.logger.error("Error receiving", (Throwable)uhe);
                    this.setState(99);
                }
            }
            catch (IOException ex) {
                this.logger.warn("Error processing ConnectionHandshake", (Throwable)ex);
                this.setState(99);
            }
            return;
        }
        if (packet instanceof KeepAlive) {
            this.socket.getReceiver().resetEXPTimer();
            this.active = true;
            return;
        }
        if (this.getState() == 2) {
            this.active = true;
            if (packet instanceof KeepAlive) {
                return;
            }
            if (packet instanceof Shutdown) {
                this.setState(4);
                this.active = false;
                this.logger.info("Connection shutdown initiated by the other side.");
                return;
            }
            try {
                if (packet.forSender()) {
                    this.socket.getSender().receive(packet);
                } else {
                    this.socket.getReceiver().receive(packet);
                }
            }
            catch (Exception ex) {
                this.logger.error("Error forwarding packet", (Throwable)ex);
                this.setState(99);
            }
            return;
        }
    }

    UDTPacket getLastPacket() {
        return this.lastPacket;
    }

    protected void sendResponseHandShake(ConnectionHandshake handshake, Destination peer) throws IOException {
        ConnectionHandshake responseHandshake = new ConnectionHandshake();
        long clientBufferSize = handshake.getPacketSize();
        long myBufferSize = this.getDatagramSize();
        long bufferSize = Math.min(clientBufferSize, myBufferSize);
        this.setDatagramSize((int)bufferSize);
        responseHandshake.setPacketSize(bufferSize);
        responseHandshake.setUdtVersion(4L);
        responseHandshake.setInitialSeqNo(this.getInitialSequenceNumber());
        responseHandshake.setConnectionType(-1L);
        responseHandshake.setSocketID(this.mySocketID);
        responseHandshake.setDestinationID(this.getDestination().getSocketID());
        responseHandshake.setSession(this);
        this.endPoint.doSend(responseHandshake);
        this.logger.info("Sent handshake");
    }
}

