/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.ServerSession;
import udt.UDTPacket;
import udt.UDTSession;
import udt.packets.ConnectionHandshake;
import udt.packets.Destination;
import udt.packets.PacketFactory;
import udt.util.UDTThreadFactory;

public class UDPEndPoint {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int port;
    private final DatagramSocket dgSocket;
    private final Map<Long, UDTSession> sessions = new ConcurrentHashMap<Long, UDTSession>();
    private final Map<Destination, UDTSession> clientSessions = new ConcurrentHashMap<Destination, UDTSession>();
    private UDTPacket lastPacket;
    private final SynchronousQueue<UDTSession> sessionHandoff = new SynchronousQueue();
    private boolean serverSocketMode = false;
    private volatile boolean stopped = false;
    public static final int DATAGRAM_SIZE = 1500;
    final DatagramPacket dp = new DatagramPacket(new byte[1500], 1500);
    private long lastDestID = -1L;
    private UDTSession lastSession;

    public UDPEndPoint(DatagramSocket socket) {
        this.dgSocket = socket;
        this.port = this.dgSocket.getLocalPort();
    }

    public UDPEndPoint(InetAddress localAddress) throws SocketException, UnknownHostException {
        this(localAddress, 0);
    }

    public UDPEndPoint(InetAddress localAddress, int localPort) throws SocketException, UnknownHostException {
        this.dgSocket = new DatagramSocket(null);
        this.dgSocket.setReuseAddress(true);
        this.dgSocket.bind(new InetSocketAddress(localAddress, localPort));
        this.port = localPort > 0 ? localPort : this.dgSocket.getLocalPort();
        this.dgSocket.setSoTimeout(30000);
        this.dgSocket.setReceiveBufferSize(131072);
    }

    public UDPEndPoint(int localPort) throws SocketException, UnknownHostException {
        this(null, localPort);
    }

    public UDPEndPoint() throws SocketException, UnknownHostException {
        this(null, 0);
    }

    public void start(boolean serverSocketModeEnabled) {
        this.serverSocketMode = serverSocketModeEnabled;
        Runnable receive = new Runnable(){

            @Override
            public void run() {
                try {
                    UDPEndPoint.this.doReceive();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Thread t = UDTThreadFactory.get().newThread(receive);
        t.setDaemon(true);
        t.start();
        this.logger.info("UDTEndpoint started.");
    }

    public void start() {
        this.start(false);
    }

    public void stop() {
        this.stopped = true;
        this.dgSocket.close();
    }

    public int getLocalPort() {
        return this.dgSocket.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.dgSocket.getLocalAddress();
    }

    DatagramSocket getSocket() {
        return this.dgSocket;
    }

    UDTPacket getLastPacket() {
        return this.lastPacket;
    }

    public void addSession(Long destinationID, UDTSession session) {
        this.sessions.put(destinationID, session);
    }

    public void addClientSession(Destination peer, UDTSession session) {
        this.clientSessions.put(peer, session);
    }

    public void removeClientSession(Destination peer) {
        this.clientSessions.remove(peer);
    }

    public UDTSession getSession(Long destinationID) {
        return this.sessions.get(destinationID);
    }

    public Collection<UDTSession> getSessions() {
        return this.sessions.values();
    }

    protected UDTSession accept(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sessionHandoff.poll(timeout, unit);
    }

    protected void doReceive() throws IOException {
        while (!this.stopped) {
            try {
                UDTSession session;
                UDTPacket packet;
                this.dgSocket.receive(this.dp);
                Destination peer = new Destination(this.dp.getAddress(), this.dp.getPort());
                int l = this.dp.getLength();
                this.lastPacket = packet = PacketFactory.createPacket(this.dp.getData(), l);
                if (packet.isConnectionHandshake()) {
                    UDTSession session2 = this.clientSessions.get(peer);
                    if (session2 == null) {
                        session2 = new ServerSession(this.dp, this);
                        this.addSession(session2.getSocketID(), session2);
                        if (this.serverSocketMode) {
                            this.logger.debug("Pooling new request.");
                            this.sessionHandoff.put(session2);
                            this.logger.debug("Request taken for processing.");
                        }
                    }
                    peer.setSocketID(((ConnectionHandshake)packet).getSocketID());
                    session2.received(packet, peer);
                    continue;
                }
                long dest = packet.getDestinationID();
                if (dest == this.lastDestID) {
                    session = this.lastSession;
                } else {
                    this.lastSession = session = this.sessions.get(dest);
                    this.lastDestID = dest;
                }
                if (session == null) {
                    this.logger.warn("Unknown session <" + packet.getDestinationID() + "> requested from <" + peer + "> packet type " + packet.getClass().getName());
                    continue;
                }
                session.received(packet, peer);
            }
            catch (SocketException e) {
                if (e.getMessage().contains("Socket closed")) {
                    this.logger.info("Receive timeout?", (Throwable)e);
                    break;
                }
                this.logger.warn("Socket error", (Throwable)e);
                break;
            }
            catch (SocketTimeoutException e) {
                this.logger.warn("Socket timeout", (Throwable)e);
                break;
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted?", (Throwable)e);
                break;
            }
        }
    }

    protected void doSend(UDTPacket packet) throws IOException {
        byte[] data = packet.getEncoded();
        DatagramPacket dgp = packet.getSession().getDatagram();
        dgp.setData(data);
        this.dgSocket.send(dgp);
        this.logger.debug("Finished send");
    }

    public String toString() {
        return "UDPEndpoint port=" + this.port;
    }

    public void sendRaw(DatagramPacket p) throws IOException {
        this.dgSocket.send(p);
    }
}

