/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.ClientSession;
import udt.UDPEndPoint;
import udt.packets.Destination;
import udt.packets.Shutdown;
import udt.util.UDTStatistics;

public class UDTClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UDPEndPoint clientEndpoint;
    private ClientSession clientSession;

    public UDTClient(InetAddress address, int localport) throws SocketException, UnknownHostException {
        this.clientEndpoint = new UDPEndPoint(address, localport);
        this.logger.info("Created client endpoint on port " + localport);
    }

    public UDTClient(InetAddress address) throws SocketException, UnknownHostException {
        this.clientEndpoint = new UDPEndPoint(address);
        this.logger.info("Created client endpoint on port " + this.clientEndpoint.getLocalPort());
    }

    public UDTClient(UDPEndPoint endpoint) throws SocketException, UnknownHostException {
        this.clientEndpoint = endpoint;
    }

    public void connect(String host, int port) throws InterruptedException, UnknownHostException, IOException {
        this.connect(InetAddress.getByName(host), port);
    }

    public void connect(InetAddress address, int port) throws InterruptedException, UnknownHostException, IOException {
        Destination destination = new Destination(address, port);
        this.clientSession = new ClientSession(this.clientEndpoint, destination);
        this.clientEndpoint.addClientSession(destination, this.clientSession);
        this.clientEndpoint.addSession(this.clientSession.getSocketID(), this.clientSession);
        this.logger.info("Starting");
        this.clientEndpoint.start();
        this.logger.info("Connecting");
        this.clientSession.connect();
        this.logger.info("Finished connect...");
        while (!this.clientSession.isReady()) {
            Thread.sleep(500L);
        }
        this.logger.info("The UDTClient is connected");
        Thread.sleep(500L);
    }

    public void send(byte[] data) throws IOException, InterruptedException {
        this.clientSession.getSocket().doWrite(data);
    }

    public void sendBlocking(byte[] data) throws IOException, InterruptedException {
        this.clientSession.getSocket().doWriteBlocking(data);
    }

    public int read(byte[] data) throws IOException, InterruptedException {
        return this.clientSession.getSocket().getInputStream().read(data);
    }

    public void flush() throws IOException, InterruptedException {
        this.clientSession.getSocket().flush();
    }

    public void shutdown() throws IOException {
        if (this.clientSession.isReady() && this.clientSession.active) {
            Shutdown shutdown = new Shutdown();
            shutdown.setDestinationID(this.clientSession.getDestination().getSocketID());
            shutdown.setSession(this.clientSession);
            try {
                this.clientEndpoint.doSend(shutdown);
            }
            catch (IOException e) {
                this.logger.error("Exception shutting down", (Throwable)e);
            }
            this.clientSession.getSocket().getReceiver().stop();
            this.clientEndpoint.stop();
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.clientSession.getSocket().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.clientSession.getSocket().getOutputStream();
    }

    public UDPEndPoint getEndpoint() throws IOException {
        return this.clientEndpoint;
    }

    public UDTStatistics getStatistics() {
        return this.clientSession.getStatistics();
    }

    public Socket getSocket() {
        return this.clientSession.getSocket();
    }
}

