/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import udt.UDPEndPoint;
import udt.UDTClient;
import udt.UDTSession;
import udt.UDTSocket;

public class UDTServerSocket2 {
    private static final Logger logger = Logger.getLogger(UDTClient.class.getName());
    private final UDPEndPoint endpoint;
    private boolean started = false;
    private volatile boolean shutdown = false;

    public UDTServerSocket2(InetAddress localAddress, int port) throws SocketException, UnknownHostException {
        this.endpoint = new UDPEndPoint(localAddress, port);
        logger.info("Created server endpoint on port " + this.endpoint.getLocalPort());
    }

    public UDTServerSocket2(int port) throws SocketException, UnknownHostException {
        this(InetAddress.getLocalHost(), port);
    }

    public synchronized UDTSocket accept() throws InterruptedException {
        if (!this.started) {
            this.endpoint.start(true);
            this.started = true;
        }
        while (!this.shutdown) {
            UDTSession session = this.endpoint.accept(10000L, TimeUnit.MILLISECONDS);
            if (session == null) continue;
            while (!session.isReady() || session.getSocket() == null) {
                Thread.sleep(100L);
            }
            return session.getSocket();
        }
        throw new InterruptedException();
    }

    public void shutDown() {
        this.shutdown = true;
        this.endpoint.stop();
    }

    public UDPEndPoint getEndpoint() {
        return this.endpoint;
    }
}

