/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.net.DatagramPacket;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import udt.CongestionControl;
import udt.UDTCongestionControl;
import udt.UDTPacket;
import udt.UDTSocket;
import udt.packets.Destination;
import udt.util.UDTStatistics;

public abstract class UDTSession {
    private static final Logger logger = Logger.getLogger(UDTSession.class.getName());
    protected int mode;
    protected volatile boolean active;
    private volatile int state = 0;
    protected volatile UDTPacket lastPacket;
    public static final int start = 0;
    public static final int handshaking = 1;
    public static final int ready = 2;
    public static final int keepalive = 3;
    public static final int shutdown = 4;
    public static final int invalid = 99;
    protected volatile UDTSocket socket;
    protected final UDTStatistics statistics;
    protected int receiveBufferSize = 0x200000;
    protected final CongestionControl cc;
    private DatagramPacket dgPacket;
    protected int flowWindowSize = 512;
    protected final Destination destination;
    protected int localPort;
    public static final int DEFAULT_DATAGRAM_SIZE = 1500;
    public static final String CC_CLASS = "udt.congestioncontrol.class";
    protected int datagramSize = 1500;
    protected Long initialSequenceNumber = null;
    protected final long mySocketID;
    private static final AtomicLong nextSocketID = new AtomicLong(0L);

    public UDTSession(String description, Destination destination) {
        this.statistics = new UDTStatistics(description);
        this.mySocketID = nextSocketID.incrementAndGet();
        this.destination = destination;
        this.dgPacket = new DatagramPacket(new byte[0], 0, destination.getAddress(), destination.getPort());
        String clazzP = System.getProperty(CC_CLASS, UDTCongestionControl.class.getName());
        UDTCongestionControl ccObject = null;
        try {
            Class<?> clazz = Class.forName(clazzP);
            ccObject = (UDTCongestionControl)clazz.getDeclaredConstructor(UDTSession.class).newInstance(this);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Can't setup congestion control class <" + clazzP + ">, using default.", e);
            ccObject = new UDTCongestionControl(this);
        }
        this.cc = ccObject;
        logger.info("Using " + this.cc.getClass().getName());
    }

    public abstract void received(UDTPacket var1, Destination var2);

    public UDTSocket getSocket() {
        return this.socket;
    }

    public CongestionControl getCongestionControl() {
        return this.cc;
    }

    public int getState() {
        return this.state;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setSocket(UDTSocket socket) {
        this.socket = socket;
    }

    public void setState(int state) {
        logger.info("Connection state CHANGED to <" + state + ">");
        this.state = state;
    }

    public boolean isReady() {
        return this.state == 2;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isShutdown() {
        return this.state == 4 || this.state == 99;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public int getDatagramSize() {
        return this.datagramSize;
    }

    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int bufferSize) {
        this.receiveBufferSize = bufferSize;
    }

    public int getFlowWindowSize() {
        return this.flowWindowSize;
    }

    public void setFlowWindowSize(int flowWindowSize) {
        this.flowWindowSize = flowWindowSize;
    }

    public UDTStatistics getStatistics() {
        return this.statistics;
    }

    public long getSocketID() {
        return this.mySocketID;
    }

    public synchronized long getInitialSequenceNumber() {
        if (this.initialSequenceNumber == null) {
            this.initialSequenceNumber = 1L;
        }
        return this.initialSequenceNumber;
    }

    public synchronized void setInitialSequenceNumber(long initialSequenceNumber) {
        this.initialSequenceNumber = initialSequenceNumber;
    }

    public DatagramPacket getDatagram() {
        return this.dgPacket;
    }
}

