/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import udt.packets.ControlPacket;
import udt.packets.PacketUtil;

public class ConnectionHandshake
extends ControlPacket {
    private long udtVersion = 4L;
    public static final long SOCKET_TYPE_STREAM = 0L;
    public static final long SOCKET_TYPE_DGRAM = 1L;
    private long socketType = 0L;
    private long initialSeqNo = 0L;
    private long packetSize;
    private long maxFlowWndSize;
    public static final long CONNECTION_TYPE_REGULAR = 0L;
    public static final long CONNECTION_TYPE_RENDEZVOUS = 1L;
    private long connectionType = 0L;
    private long socketID;

    public ConnectionHandshake() {
        this.controlPacketType = ControlPacket.ControlPacketType.CONNECTION_HANDSHAKE.ordinal();
    }

    public ConnectionHandshake(byte[] controlInformation) {
        this();
        this.decode(controlInformation);
    }

    @Override
    public boolean isConnectionHandshake() {
        return true;
    }

    void decode(byte[] data) {
        this.udtVersion = PacketUtil.decode(data, 0);
        this.socketType = PacketUtil.decode(data, 4);
        this.initialSeqNo = PacketUtil.decode(data, 8);
        this.packetSize = PacketUtil.decode(data, 12);
        this.maxFlowWndSize = PacketUtil.decode(data, 16);
        this.connectionType = PacketUtil.decode(data, 20);
        this.socketID = PacketUtil.decode(data, 24);
    }

    public long getUdtVersion() {
        return this.udtVersion;
    }

    public void setUdtVersion(long udtVersion) {
        this.udtVersion = udtVersion;
    }

    public long getSocketType() {
        return this.socketType;
    }

    public void setSocketType(long socketType) {
        this.socketType = socketType;
    }

    public long getInitialSeqNo() {
        return this.initialSeqNo;
    }

    public void setInitialSeqNo(long initialSeqNo) {
        this.initialSeqNo = initialSeqNo;
    }

    public long getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(long packetSize) {
        this.packetSize = packetSize;
    }

    public long getMaxFlowWndSize() {
        return this.maxFlowWndSize;
    }

    public void setMaxFlowWndSize(long maxFlowWndSize) {
        this.maxFlowWndSize = maxFlowWndSize;
    }

    public long getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(long connectionType) {
        this.connectionType = connectionType;
    }

    public long getSocketID() {
        return this.socketID;
    }

    public void setSocketID(long socketID) {
        this.socketID = socketID;
    }

    @Override
    public byte[] encodeControlInformation() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(24);
            bos.write(PacketUtil.encode(this.udtVersion));
            bos.write(PacketUtil.encode(this.socketType));
            bos.write(PacketUtil.encode(this.initialSeqNo));
            bos.write(PacketUtil.encode(this.packetSize));
            bos.write(PacketUtil.encode(this.maxFlowWndSize));
            bos.write(PacketUtil.encode(this.connectionType));
            bos.write(PacketUtil.encode(this.socketID));
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionHandshake other = (ConnectionHandshake)obj;
        if (this.connectionType != other.connectionType) {
            return false;
        }
        if (this.initialSeqNo != other.initialSeqNo) {
            return false;
        }
        if (this.maxFlowWndSize != other.maxFlowWndSize) {
            return false;
        }
        if (this.packetSize != other.packetSize) {
            return false;
        }
        if (this.socketID != other.socketID) {
            return false;
        }
        if (this.socketType != other.socketType) {
            return false;
        }
        return this.udtVersion == other.udtVersion;
    }
}

