/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import udt.packets.ControlPacket;
import udt.packets.PacketUtil;

public class NegativeAcknowledgement
extends ControlPacket {
    List<Integer> lostSequenceNumbers;
    ByteArrayOutputStream lossInfo = new ByteArrayOutputStream();

    public NegativeAcknowledgement() {
        this.controlPacketType = ControlPacket.ControlPacketType.NAK.ordinal();
    }

    public NegativeAcknowledgement(byte[] controlInformation) {
        this();
        this.lostSequenceNumbers = this.decode(controlInformation);
    }

    private List<Integer> decode(byte[] lossInfo) {
        ArrayList<Integer> lostSequenceNumbers = new ArrayList<Integer>();
        ByteBuffer bb = ByteBuffer.wrap(lossInfo);
        byte[] buffer = new byte[4];
        while (bb.remaining() > 0) {
            buffer[0] = bb.get();
            buffer[1] = bb.get();
            buffer[2] = bb.get();
            buffer[3] = bb.get();
            boolean isNotSingle = (buffer[0] & 0x80) != 0;
            buffer[0] = (byte)(buffer[0] & 0x7F);
            int lost = ByteBuffer.wrap(buffer).getInt();
            if (isNotSingle) {
                int end = bb.getInt();
                for (int i = lost; i <= end; ++i) {
                    lostSequenceNumbers.add(i);
                }
                continue;
            }
            lostSequenceNumbers.add(lost);
        }
        return lostSequenceNumbers;
    }

    public void addLossInfo(long singleSequenceNumber) {
        byte[] enc = PacketUtil.encodeSetHighest(false, singleSequenceNumber);
        try {
            this.lossInfo.write(enc);
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public void addLossInfo(long firstSequenceNumber, long lastSequenceNumber) {
        if (lastSequenceNumber - firstSequenceNumber == 0L) {
            this.addLossInfo(firstSequenceNumber);
            return;
        }
        byte[] enc1 = PacketUtil.encodeSetHighest(true, firstSequenceNumber);
        byte[] enc2 = PacketUtil.encodeSetHighest(false, lastSequenceNumber);
        try {
            this.lossInfo.write(enc1);
            this.lossInfo.write(enc2);
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    public void addLossInfo(List<Long> sequenceNumbers) {
        long start = 0L;
        int index = 0;
        do {
            start = sequenceNumbers.get(index);
            long end = 0L;
            int c = 0;
            do {
                ++c;
                if (++index >= sequenceNumbers.size()) continue;
                end = sequenceNumbers.get(index);
            } while (end - start == (long)c);
            if (end == 0L) {
                this.addLossInfo(start);
                continue;
            }
            end = sequenceNumbers.get(index - 1);
            this.addLossInfo(start, end);
        } while (index < sequenceNumbers.size());
    }

    public List<Integer> getDecodedLossInfo() {
        return this.lostSequenceNumbers;
    }

    @Override
    public byte[] encodeControlInformation() {
        try {
            return this.lossInfo.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NegativeAcknowledgement other = (NegativeAcknowledgement)obj;
        List<Integer> thisLost = null;
        List<Integer> otherLost = null;
        thisLost = this.lostSequenceNumbers != null ? this.lostSequenceNumbers : this.decode(this.lossInfo.toByteArray());
        return ((Object)thisLost).equals(otherLost = other.lostSequenceNumbers != null ? other.lostSequenceNumbers : other.decode(other.lossInfo.toByteArray()));
    }
}

