/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import udt.UDTPacket;
import udt.packets.Acknowledgement;
import udt.packets.Acknowledgment2;
import udt.packets.ConnectionHandshake;
import udt.packets.ControlPacket;
import udt.packets.DataPacket;
import udt.packets.KeepAlive;
import udt.packets.MessageDropRequest;
import udt.packets.NegativeAcknowledgement;
import udt.packets.PacketUtil;
import udt.packets.Shutdown;
import udt.packets.UserDefined;

public class PacketFactory {
    public static UDTPacket createPacket(byte[] encodedData) {
        boolean isControl;
        boolean bl = isControl = (encodedData[0] & 0x80) != 0;
        if (isControl) {
            return PacketFactory.createControlPacket(encodedData, encodedData.length);
        }
        return new DataPacket(encodedData);
    }

    public static UDTPacket createPacket(byte[] encodedData, int length) {
        boolean isControl;
        boolean bl = isControl = (encodedData[0] & 0x80) != 0;
        if (isControl) {
            return PacketFactory.createControlPacket(encodedData, length);
        }
        return new DataPacket(encodedData, length);
    }

    public static ControlPacket createControlPacket(byte[] encodedData, int length) {
        ControlPacket packet = null;
        int pktType = PacketUtil.decodeType(encodedData, 0);
        long ackSeqNo = PacketUtil.decodeAckSeqNr(encodedData, 0);
        long msgNr = PacketUtil.decode(encodedData, 4);
        long timeStamp = PacketUtil.decode(encodedData, 8);
        long destID = PacketUtil.decode(encodedData, 12);
        byte[] controlInformation = new byte[length - 16];
        System.arraycopy(encodedData, 16, controlInformation, 0, controlInformation.length);
        if (ControlPacket.ControlPacketType.CONNECTION_HANDSHAKE.ordinal() == pktType) {
            packet = new ConnectionHandshake(controlInformation);
        } else if (ControlPacket.ControlPacketType.KEEP_ALIVE.ordinal() == pktType) {
            packet = new KeepAlive();
        } else if (ControlPacket.ControlPacketType.ACK.ordinal() == pktType) {
            packet = new Acknowledgement(controlInformation);
        } else if (ControlPacket.ControlPacketType.NAK.ordinal() == pktType) {
            packet = new NegativeAcknowledgement(controlInformation);
        } else if (ControlPacket.ControlPacketType.SHUTDOWN.ordinal() == pktType) {
            packet = new Shutdown();
        } else if (ControlPacket.ControlPacketType.ACK2.ordinal() == pktType) {
            packet = new Acknowledgment2(controlInformation);
        } else if (ControlPacket.ControlPacketType.MESSAGE_DROP_REQUEST.ordinal() == pktType) {
            packet = new MessageDropRequest(controlInformation);
        } else if (ControlPacket.ControlPacketType.USER_DEFINED.ordinal() == pktType) {
            packet = new UserDefined(controlInformation);
        }
        if (packet != null) {
            packet.setAckSequenceNumber(ackSeqNo);
            packet.setMessageNumber(msgNr);
            packet.setTimeStamp(timeStamp);
            packet.setDestinationID(destID);
        }
        return packet;
    }
}

