/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

public class PacketUtil {
    public static byte[] encode(long value) {
        byte m4 = (byte)(value >> 24);
        byte m3 = (byte)(value >> 16);
        byte m2 = (byte)(value >> 8);
        byte m1 = (byte)value;
        return new byte[]{m4, m3, m2, m1};
    }

    public static byte[] encodeSetHighest(boolean highest, long value) {
        byte m4 = highest ? (byte)(0x80L | value >> 24) : (byte)(0x7FL & value >> 24);
        byte m3 = (byte)(value >> 16);
        byte m2 = (byte)(value >> 8);
        byte m1 = (byte)value;
        return new byte[]{m4, m3, m2, m1};
    }

    public static byte[] encodeSetHighestAndType(boolean highest, int type, long value) {
        byte m3;
        byte m4;
        if (highest) {
            m4 = (byte)(0x80 | type << 3);
            m3 = 0;
        } else {
            m4 = (byte)(0x7FL & value >> 24);
            m3 = (byte)(value >> 16);
        }
        byte m2 = (byte)(value >> 8);
        byte m1 = (byte)value;
        return new byte[]{m4, m3, m2, m1};
    }

    public static byte[] encodeHighesBitTypeAndSeqNumber(boolean highestBit, int type, long value) {
        byte m3;
        byte m4;
        if (highestBit) {
            m4 = (byte)(0x80 | type << 3);
            m3 = 0;
        } else {
            m4 = 0;
            m3 = 0;
        }
        byte m2 = (byte)(value >> 8);
        byte m1 = (byte)value;
        return new byte[]{m4, m3, m2, m1};
    }

    public static long decode(byte[] data, int start) {
        long result = (data[start] & 0xFF) << 24 | (data[start + 1] & 0xFF) << 16 | (data[start + 2] & 0xFF) << 8 | data[start + 3] & 0xFF;
        return result;
    }

    public static int decodeType(byte[] data, int start) {
        int result = (data[start] & 0x78) >> 3;
        return result;
    }

    public static long decodeAckSeqNr(byte[] data, int start) {
        long result = (data[start + 2] & 0xFF) << 8 | data[start + 3] & 0xFF;
        return result;
    }
}

