/*
 * Decompiled with CFR 0.152.
 */
package udt.unicore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import udt.UDTServerSocket;
import udt.UDTSocket;
import udt.packets.PacketUtil;
import udt.util.Util;

public class FufexSend {
    private final String clientIP;
    private final int clientPort;
    private final String localFilename;
    private final String commFilename;

    public FufexSend(String clientIP, int clientPort, String localFilename, String commFilename) {
        this.clientIP = clientIP;
        this.clientPort = clientPort;
        this.localFilename = localFilename;
        this.commFilename = commFilename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            UDTServerSocket server = new UDTServerSocket(0);
            InetAddress clientAddress = InetAddress.getByName(this.clientIP);
            Util.doHolePunch(server.getEndpoint(), clientAddress, this.clientPort);
            int localPort = server.getEndpoint().getLocalPort();
            this.writeToOut("OUT: " + localPort);
            UDTSocket socket = server.accept();
            OutputStream out = socket.getOutputStream();
            File file = new File(this.localFilename);
            FileInputStream fis = new FileInputStream(file);
            try {
                long size = file.length();
                PacketUtil.encode(size);
                out.write(PacketUtil.encode(size));
                long start = System.currentTimeMillis();
                Util.copy(fis, out, size, true);
                long end = System.currentTimeMillis();
                System.out.println(socket.getSession().getStatistics());
                float mbRate = 1000L * size / 1024L / 1024L / (end - start);
                float mbitRate = 8.0f * mbRate;
                System.out.println("Rate: " + (int)mbRate + " MBytes/sec. " + mbitRate + " mbit/sec.");
            }
            finally {
                fis.close();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void usage() {
        System.err.println("usage: send client_ip client_port local_filename [comm_file_name]");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            FufexSend.usage();
        }
        String commFileName = null;
        if (args.length > 3) {
            commFileName = args[3];
        }
        String clientIP = args[0];
        int clientPort = Integer.parseInt(args[1]);
        FufexSend fs = new FufexSend(clientIP, clientPort, args[2], commFileName);
        fs.run();
    }

    private void writeToOut(String line) throws IOException {
        if (this.commFilename != null) {
            this.appendToFile(this.commFilename, line);
        } else {
            System.out.println(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendToFile(String name, String line) throws IOException {
        File f = new File(name);
        FileOutputStream fos = new FileOutputStream(f, true);
        try {
            fos.write(line.getBytes());
            fos.write(10);
        }
        finally {
            fos.close();
        }
    }
}

