/*
 * Decompiled with CFR 0.152.
 */
package udt.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.littleshoot.util.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDTReceiver;
import udt.UDTServerSocket;
import udt.UDTSocket;
import udt.packets.PacketUtil;
import udt.util.Application;
import udt.util.Util;

public class TestServerSocket
extends Application {
    private static final Logger log = LoggerFactory.getLogger(TestServerSocket.class);
    private final int serverPort;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(3);

    public TestServerSocket(int serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public void configure() {
        super.configure();
    }

    @Override
    public void run() {
        this.configure();
        try {
            UDTReceiver.connectionExpiryDisabled = true;
            InetAddress myHost = localIP != null ? InetAddress.getByName(localIP) : InetAddress.getLocalHost();
            UDTServerSocket server = new UDTServerSocket(myHost, this.serverPort);
            while (true) {
                UDTSocket socket = server.accept();
                this.threadPool.execute(new RequestRunner(socket));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] fullArgs) throws Exception {
        String[] args = TestServerSocket.parseOptions(fullArgs);
        int serverPort = 65321;
        try {
            serverPort = Integer.parseInt(args[0]);
        }
        catch (Exception ex) {
            TestServerSocket.usage();
            System.exit(1);
        }
        TestServerSocket sf = new TestServerSocket(serverPort);
        sf.run();
    }

    public static void usage() {
        System.out.println("Usage: java -cp ... udt.util.SendFile <server_port> [--verbose] [--localPort=<port>] [--localIP=<ip>]");
    }

    public static class RequestRunner
    implements Runnable {
        private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(RequestRunner.class.getName());
        private final Socket socket;
        private final NumberFormat format = NumberFormat.getNumberInstance();

        public RequestRunner(Socket sock) {
            this.socket = sock;
            this.format.setMaximumFractionDigits(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                log.info("Handling request from " + this.socket.getRemoteSocketAddress());
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                byte[] readBuf = new byte[32768];
                ByteBuffer bb = ByteBuffer.wrap(readBuf);
                while (in.read(readBuf) == 0) {
                    Thread.sleep(100L);
                }
                int length = bb.getInt();
                byte[] fileName = new byte[length - 1];
                bb.get(fileName);
                File file = new File(new String(fileName));
                System.out.println("[SendFile] File requested: '" + file.getPath() + "'");
                FileInputStream fis = null;
                try {
                    long size = file.length();
                    System.out.println("[SendFile] File size: " + size);
                    out.write(PacketUtil.encode(size));
                    long start = System.currentTimeMillis();
                    fis = new FileInputStream(file);
                    IoUtils.copy((InputStream)fis, (OutputStream)out, (long)size);
                    long end = System.currentTimeMillis();
                    System.out.println(((UDTSocket)this.socket).getSession().getStatistics().toString());
                    double rate = 1000.0 * (double)size / 1024.0 / 1024.0 / (double)(end - start);
                    System.out.println("[SendFile] Rate: " + this.format.format(rate) + " MBytes/sec. " + this.format.format(8.0 * rate) + " MBit/sec.");
                    if (Boolean.getBoolean("udt.sender.storeStatistics")) {
                        ((UDTSocket)this.socket).getSession().getStatistics().writeParameterHistory(new File("udtstats-" + System.currentTimeMillis() + ".csv"));
                    }
                }
                finally {
                    this.socket.close();
                    if (fis != null) {
                        fis.close();
                    }
                }
                log.info("Finished request from " + ((UDTSocket)this.socket).getSession().getDestination());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestAndResponseOnSocket(Socket sock) throws IOException, InterruptedException {
            InputStream is = sock.getInputStream();
            OutputStream os = sock.getOutputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            String curLine = reader.readLine();
            while (StringUtils.isNotBlank((String)curLine)) {
                log.info("curLine: " + curLine);
                curLine = reader.readLine();
            }
            File file = new File("visualvm.zip");
            os.write("HTTP/1.1 200 OK\r\n".getBytes());
            os.write(("Content-Length: " + file.length() + "\r\n").getBytes());
            os.write("\r\n".getBytes());
            FileInputStream fis = new FileInputStream(file);
            try {
                IoUtils.copy((InputStream)fis, (OutputStream)os, (long)file.length());
            }
            finally {
                sock.close();
                fis.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run2() {
            try {
                log.info("Handling request from " + this.socket.getRemoteSocketAddress());
                InputStream in = this.socket.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                byte[] readBuf = new byte[32768];
                ByteBuffer bb = ByteBuffer.wrap(readBuf);
                while (in.read(readBuf) == 0) {
                    Thread.sleep(100L);
                }
                int length = bb.getInt();
                byte[] fileName = new byte[length - 1];
                bb.get(fileName);
                File file = new File(new String(fileName));
                System.out.println("[SendFile] File requested: '" + file.getPath() + "'");
                FileInputStream fis = null;
                try {
                    long size = file.length();
                    System.out.println("[SendFile] File size: " + size);
                    out.write(PacketUtil.encode(size));
                    long start = System.currentTimeMillis();
                    fis = new FileInputStream(file);
                    Util.copy(fis, out, size, false);
                    long end = System.currentTimeMillis();
                    System.out.println(((UDTSocket)this.socket).getSession().getStatistics().toString());
                    double rate = 1000.0 * (double)size / 1024.0 / 1024.0 / (double)(end - start);
                    System.out.println("[SendFile] Rate: " + this.format.format(rate) + " MBytes/sec. " + this.format.format(8.0 * rate) + " MBit/sec.");
                    if (Boolean.getBoolean("udt.sender.storeStatistics")) {
                        ((UDTSocket)this.socket).getSession().getStatistics().writeParameterHistory(new File("udtstats-" + System.currentTimeMillis() + ".csv"));
                    }
                }
                finally {
                    this.socket.close();
                    if (fis != null) {
                        fis.close();
                    }
                }
                log.info("Finished request from " + ((UDTSocket)this.socket).getSession().getDestination());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }
}

