/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.config;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.state.StateGenerator;
import org.pac4j.core.state.StaticOrRandomStateGenerator;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.InitializableObject;

public class OidcConfiguration
extends InitializableObject {
    public static final String SCOPE = "scope";
    public static final String RESPONSE_TYPE = "response_type";
    public static final String RESPONSE_MODE = "response_mode";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String CLIENT_ID = "client_id";
    public static final String STATE = "state";
    public static final String MAX_AGE = "max_age";
    public static final String NONCE = "nonce";
    public static final List<String> AUTHORIZATION_CODE_FLOWS = Collections.unmodifiableList(Arrays.asList("code"));
    public static final List<String> IMPLICIT_FLOWS = Collections.unmodifiableList(Arrays.asList("id_token", "id_token token"));
    public static final List<String> HYBRID_CODE_FLOWS = Collections.unmodifiableList(Arrays.asList("code id_token", "code token", "code id_token token"));
    public static final String STATE_SESSION_ATTRIBUTE = "oidcStateAttribute";
    public static final String NONCE_SESSION_ATTRIBUTE = "oidcNonceAttribute";
    public static final int DEFAULT_MAX_CLOCK_SKEW = 30;
    public static final int DEFAULT_TOKEN_EXPIRATION_ADVANCE = 0;
    private String clientId;
    private String secret;
    private String discoveryURI;
    private String scope;
    private Map<String, String> customParams = new HashMap<String, String>();
    private ClientAuthenticationMethod clientAuthenticationMethod;
    private boolean useNonce;
    private JWSAlgorithm preferredJwsAlgorithm;
    private Integer maxAge;
    private int maxClockSkew = 30;
    private ResourceRetriever resourceRetriever;
    private OIDCProviderMetadata providerMetadata;
    private String responseType = AUTHORIZATION_CODE_FLOWS.get(0);
    private String responseMode;
    private String logoutUrl;
    private int connectTimeout = 500;
    private int readTimeout = 5000;
    private boolean withState;
    private StateGenerator stateGenerator = new StaticOrRandomStateGenerator();
    private boolean expireSessionWithToken = false;
    private int tokenExpirationAdvance = 0;

    protected void internalInit() {
        CommonHelper.assertNotBlank((String)"clientId", (String)this.getClientId());
        if (!(AUTHORIZATION_CODE_FLOWS.contains(this.responseType) || IMPLICIT_FLOWS.contains(this.responseType) || HYBRID_CODE_FLOWS.contains(this.responseType))) {
            throw new TechnicalException("Unsupported responseType: " + this.responseType);
        }
        if (!IMPLICIT_FLOWS.contains(this.responseType)) {
            CommonHelper.assertNotBlank((String)"secret", (String)this.getSecret());
        }
        if (this.getDiscoveryURI() == null && this.getProviderMetadata() == null) {
            throw new TechnicalException("You must define either the discovery URL or directly the provider metadata");
        }
        if (this.getResourceRetriever() == null) {
            this.setResourceRetriever((ResourceRetriever)new DefaultResourceRetriever(this.getConnectTimeout(), this.getReadTimeout()));
        }
        if (this.getProviderMetadata() == null) {
            CommonHelper.assertNotBlank((String)"discoveryURI", (String)this.getDiscoveryURI());
            try {
                this.setProviderMetadata(OIDCProviderMetadata.parse((String)this.getResourceRetriever().retrieveResource(new URL(this.getDiscoveryURI())).getContent()));
            }
            catch (ParseException | IOException e) {
                throw new TechnicalException(e);
            }
        }
    }

    public OIDCProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public OIDCProviderMetadata findProviderMetadata() {
        this.init();
        return this.providerMetadata;
    }

    public void setProviderMetadata(OIDCProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getDiscoveryURI() {
        return this.discoveryURI;
    }

    public void defaultDiscoveryURI(String discoveryURI) {
        if (this.discoveryURI == null) {
            this.discoveryURI = discoveryURI;
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Map<String, String> getCustomParams() {
        return this.customParams;
    }

    public String getCustomParam(String name) {
        return this.customParams.get(name);
    }

    public void setCustomParams(Map<String, String> customParams) {
        CommonHelper.assertNotNull((String)"customParams", customParams);
        this.customParams = customParams;
    }

    public void addCustomParam(String key, String value) {
        this.customParams.put(key, value);
    }

    public ClientAuthenticationMethod getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public void setClientAuthenticationMethodAsString(String auth) {
        this.clientAuthenticationMethod = ClientAuthenticationMethod.parse((String)auth);
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public JWSAlgorithm getPreferredJwsAlgorithm() {
        return this.preferredJwsAlgorithm;
    }

    public void setPreferredJwsAlgorithm(JWSAlgorithm preferredJwsAlgorithm) {
        this.preferredJwsAlgorithm = preferredJwsAlgorithm;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public ResourceRetriever findResourceRetriever() {
        this.init();
        return this.resourceRetriever;
    }

    public void setDiscoveryURI(String discoveryURI) {
        this.discoveryURI = discoveryURI;
    }

    public void setResourceRetriever(ResourceRetriever resourceRetriever) {
        this.resourceRetriever = resourceRetriever;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getLogoutUrl() {
        this.init();
        if (this.logoutUrl == null && this.getProviderMetadata().getEndSessionEndpointURI() != null) {
            return this.getProviderMetadata().getEndSessionEndpointURI().toString();
        }
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean isWithState() {
        return this.withState;
    }

    public void setWithState(boolean withState) {
        this.withState = withState;
    }

    @Deprecated
    public String getStateData() {
        return ((StaticOrRandomStateGenerator)this.stateGenerator).getStateData();
    }

    @Deprecated
    public void setStateData(String stateData) {
        ((StaticOrRandomStateGenerator)this.stateGenerator).setStateData(stateData);
    }

    public boolean isExpireSessionWithToken() {
        return this.expireSessionWithToken;
    }

    public void setExpireSessionWithToken(boolean expireSessionWithToken) {
        this.expireSessionWithToken = expireSessionWithToken;
    }

    public int getTokenExpirationAdvance() {
        return this.isExpireSessionWithToken() ? this.tokenExpirationAdvance : -1;
    }

    public void setTokenExpirationAdvance(int tokenExpirationAdvance) {
        this.tokenExpirationAdvance = tokenExpirationAdvance;
    }

    public StateGenerator getStateGenerator() {
        return this.stateGenerator;
    }

    public void setStateGenerator(StateGenerator stateGenerator) {
        CommonHelper.assertNotNull((String)"stateGenerator", (Object)stateGenerator);
        this.stateGenerator = stateGenerator;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"clientId", this.clientId, "secret", "[protected]", "discoveryURI", this.discoveryURI, SCOPE, this.scope, "customParams", this.customParams, "clientAuthenticationMethod", this.clientAuthenticationMethod, "useNonce", this.useNonce, "preferredJwsAlgorithm", this.preferredJwsAlgorithm, "maxAge", this.maxAge, "maxClockSkew", this.maxClockSkew, "connectTimeout", this.connectTimeout, "readTimeout", this.readTimeout, "resourceRetriever", this.resourceRetriever, "responseType", this.responseType, "responseMode", this.responseMode, "logoutUrl", this.logoutUrl, "withState", this.withState, "stateGenerator", this.stateGenerator});
    }
}

