/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.cache;

import java.util.Objects;
import org.tio.mg.service.cache.CacheType;
import org.tio.utils.time.Time;

public enum CacheConfig {
    CAPTCHA(CacheType.CAFFEINE_REDIS, null, Time.MINUTE_1 * 5L),
    MG_GROUPID_IMSERVER(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 1L),
    IMSERVER(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 2L, null),
    IP_IPINFO(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 6L),
    ID_IPINFO(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 6L),
    MG_CLIENTID_OAUTH2CLIENT(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 6L),
    IMEI_IMEISTAT(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 6L),
    MG_SESSION_5_MINUTES(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 5L, null),
    MG_TIO_ACCESS_TOKEN_TEMP(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 1L, null),
    MG_TIO_ACCESS_TOKEN(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 120L, null),
    MG_TIO_ACCESSTOKEN_USERAGENT(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 125L, null),
    GROUP_STAT(CacheType.CAFFEINE_REDIS, null, Time.HOUR_1 * 10L),
    OPENID_USERTHIRD(CacheType.CAFFEINE_REDIS, Time.HOUR_1 * 2L, null),
    UID_USERTHIRD(CacheType.CAFFEINE_REDIS, Time.HOUR_1 * 2L, null),
    MG_TIME_TO_LIVE_SECONDS_5(CacheType.CAFFEINE_REDIS, Time.SECOND_1 * 5L, null),
    MG_TIME_TO_LIVE_MINUTE_5(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 5L, null),
    MG_TIME_TO_IDLE_SECONDS_5(CacheType.CAFFEINE_REDIS, null, Time.SECOND_1 * 5L),
    CHAT_ON_FOCUS_1(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 3L, null),
    CHAT_ON_FOCUS_GROUP_1(CacheType.CAFFEINE_REDIS, Time.MINUTE_1 * 3L, null),
    CHAT_GROUP_INDEX_2(CacheType.CAFFEINE, Time.HOUR_1 * 12L, null),
    CHAT_GROUP_USER_LIST_2(CacheType.CAFFEINE_REDIS, Time.SECOND_1 * 30L, null),
    CHAT_USER_INDEX_1(CacheType.CAFFEINE, Time.HOUR_1 * 12L, null),
    CHAT_ITEMS_3(CacheType.CAFFEINE_REDIS, Time.SECOND_1 * 30L, null),
    WX_FRIEND_APPLY_INFO_1(CacheType.CAFFEINE_REDIS, Time.HOUR_1 * 12L, Time.DAY_1 * 1L),
    CHAT_USER_BLOCK_1(CacheType.CAFFEINE_REDIS, Time.HOUR_1 * 12L, Time.DAY_1 * 1L),
    EMAIL_AUTHCODE(CacheType.REDIS, Time.MINUTE_1 * 15L, null),
    EMAIL_SENT_COUNT_PERIP_PERDAY(CacheType.REDIS, Time.HOUR_1 * 24L, null),
    EMAIL_SENT_COUNT_PERDAY(CacheType.REDIS, Time.HOUR_1 * 24L, null),
    MG_ACCESS_TOKEN_RESP_1(CacheType.REDIS, Time.SECOND_1 * 5L, null),
    BLOG_ACCESSCOUNT(CacheType.REDIS, null, Time.MINUTE_1 * 60L),
    SMS_IP_COUNT(CacheType.REDIS, Time.HOUR_1 * 24L, null),
    SMS_MOBILE_COUNT(CacheType.REDIS, Time.HOUR_1 * 24L, null),
    SMS_DEVICE_COUNT(CacheType.REDIS, Time.HOUR_1 * 2L, null),
    SMS_MOBILE_CODE(CacheType.REDIS, Time.MINUTE_1 * 10L, null),
    CHECK_PHONE_USERID_TOKEN(CacheType.REDIS, Time.MINUTE_1 * 15L, null),
    CHECK_PHONE_TOKEN(CacheType.REDIS, Time.MINUTE_1 * 15L, null),
    WECHAT_LOGIN_TOKEN(CacheType.REDIS, Time.MINUTE_1 * 60L, null),
    RECHARGE_QR(CacheType.REDIS, Time.MINUTE_1 * 3L, null),
    MG_LATEST_VERSION(CacheType.REDIS, Time.SECOND_1 * 10L, null),
    WX_IS_CALLING(CacheType.REDIS, null, Time.MINUTE_1 * 60L * 12L),
    DEMO_CACHE(CacheType.CAFFEINE, null, Time.MINUTE_1 * 10L),
    SEARCH_USER(CacheType.CAFFEINE, Time.MINUTE_1 * 1L, null),
    USER_INFO(CacheType.CAFFEINE, null, Time.MINUTE_1 * 60L),
    USERID_USER_2(CacheType.CAFFEINE, null, Time.HOUR_1),
    AUTO_AVATAR(CacheType.CAFFEINE, Time.DAY_1 * 1L, Time.DAY_1 * 3L),
    USERID_BASE(CacheType.CAFFEINE, null, Time.HOUR_1 * 1L),
    LOGINNAME_USER(CacheType.CAFFEINE, null, Time.HOUR_1),
    MG_TIME_TO_LIVE_MINUTE_5_LOCAL(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    MG_TIME_TO_IDLE_MINUTE_5_LOCAL(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    USER_AGENT(CacheType.CAFFEINE, null, Time.HOUR_1 * 1L),
    BLOG_WITH_HTML(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    BLOG_WITH_MD(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    BLOG_MD(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    BLOG_HTML(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    BLOG(CacheType.CAFFEINE, null, Time.MINUTE_1 * 5L),
    MG_VIEW_HTML(CacheType.CAFFEINE, null, Time.HOUR_1 * 19L),
    GROUP_CHAT_LOG(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    P2P_CHAT_LOG(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    N2P_NOT_READ_COUNT(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_GROUP_MSG(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_GROUP_1(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_MAILLIST_1(CacheType.CAFFEINE, Time.MINUTE_1 * 30L, null),
    WX_RECENT_MSG(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_FRIEND_MSG(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_FRIEND_MSG_CHAT_2(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_GROUP_CHAT_3(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_RECENT_MSG_NOT_READ(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    WX_MY_FRIEND(CacheType.CAFFEINE, null, Time.MINUTE_1 * 60L),
    WX_IS_FRIEND(CacheType.CAFFEINE, null, Time.MINUTE_1 * 60L),
    N2P_LATELY_COUNT(CacheType.CAFFEINE, Time.MINUTE_1 * 5L, null),
    IosCheckConf(CacheType.CAFFEINE, Time.MINUTE_1 * 10L, null),
    MG_PAGE_ONLINE(CacheType.CAFFEINE, null, Time.MINUTE_1 * 10L),
    USER_COUNT(CacheType.CAFFEINE, null, Time.HOUR_1 * 1L),
    MY_FRIEND_GROUPS(CacheType.CAFFEINE, Time.HOUR_1 * 1L, null),
    MY_FRIEND_IDS(CacheType.CAFFEINE, Time.HOUR_1 * 1L, null),
    WxCallItem(CacheType.CAFFEINE, null, Time.MINUTE_1 * 30L),
    MG_USER_MENU_AUTH(CacheType.CAFFEINE, Time.HOUR_1 * 12L, Time.DAY_1 * 1L),
    XXXXXXXXXX(CacheType.CAFFEINE, Time.HOUR_1 * 1L, null);

    CacheType cacheType;
    String cacheName;
    Long timeToLiveSeconds;
    Long timeToIdleSeconds;

    private CacheConfig(CacheType cacheType, Long timeToLiveSeconds, Long timeToIdleSeconds) {
        this.cacheType = cacheType;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.cacheName = this.name();
    }

    public static CacheConfig from(String cacheName) {
        CacheConfig[] values;
        for (CacheConfig v : values = CacheConfig.values()) {
            if (!Objects.equals(v.cacheName, cacheName)) continue;
            return v;
        }
        return null;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public Long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public Long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }
}

