/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.stat.ImeiStat;
import org.tio.utils.cache.ICache;

public class ImeiStatService {
    private static Logger log = LoggerFactory.getLogger(ImeiStatService.class);
    public static final ImeiStatService me = new ImeiStatService();

    private ImeiStatService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ImeiStat imeiStat) {
        String imei = imeiStat.getImei();
        if (StrUtil.isBlank((CharSequence)imei)) {
            return;
        }
        Logger logger = log;
        synchronized (logger) {
            ImeiStat imeiStatInDb = this.getByImei(imei);
            if (imeiStatInDb != null) {
                return;
            }
            try {
                boolean saved = imeiStat.save();
                if (saved) {
                    ICache cache = Caches.getCache(CacheConfig.IMEI_IMEISTAT);
                    cache.put(imei, (Serializable)((Object)imeiStat));
                }
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public void update(ImeiStat imeiStat) {
        try {
            boolean updated = imeiStat.update();
            if (updated) {
                ICache cache = Caches.getCache(CacheConfig.IMEI_IMEISTAT);
                cache.put(imeiStat.getImei(), (Serializable)((Object)imeiStat));
            }
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImeiStat getByImei(String imei) {
        ICache cache = Caches.getCache(CacheConfig.IMEI_IMEISTAT);
        ImeiStat inCache = (ImeiStat)((Object)cache.get(imei, ImeiStat.class));
        if (inCache != null && inCache.getId() != null) {
            return inCache;
        }
        Logger logger = log;
        synchronized (logger) {
            inCache = (ImeiStat)((Object)cache.get(imei, ImeiStat.class));
            if (inCache != null && inCache.getId() != null) {
                return inCache;
            }
            ImeiStat indb = (ImeiStat)ImeiStat.dao.findFirst("select * from imei_stat where imei=?", new Object[]{imei});
            if (indb != null) {
                cache.put(imei, (Serializable)((Object)indb));
                return indb;
            }
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

