/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.Date;
import org.lionsoul.ip2region.DataBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.ip2region.Ip2Region;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.mg.MgIpInfo;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class IpInfoService {
    public static final IpInfoService ME = new IpInfoService();
    private static Logger log = LoggerFactory.getLogger(IpInfoService.class);

    public IpInfo getById(final Integer id) {
        if (id == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.ID_IPINFO);
        String key = id + "";
        IpInfo ipInfo1 = (IpInfo)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<IpInfo>(){

            public IpInfo create() {
                return (IpInfo)IpInfo.dao.findFirst("select * from ip_info where id=?", new Object[]{id});
            }
        }));
        return ipInfo1;
    }

    public IpInfo save(final IpInfo ipInfo) {
        String key;
        ICache cache = Caches.getCache(CacheConfig.IP_IPINFO);
        IpInfo ipInfo1 = (IpInfo)((Object)CacheUtils.get((ICache)cache, (String)(key = ipInfo.getIp()), (boolean)false, (FirsthandCreater)new FirsthandCreater<IpInfo>(){

            public IpInfo create() {
                return (IpInfo)IpInfo.dao.findFirst("select * from ip_info where ip=? and country=? and area=? and province=? and city=? and operator=?", new Object[]{key, ipInfo.getCountry(), ipInfo.getArea(), ipInfo.getProvince(), ipInfo.getCity(), ipInfo.getOperator()});
            }
        }));
        if (ipInfo1 == null || ipInfo1.getId() == null) {
            ipInfo.save();
            cache.put(key, (Serializable)((Object)ipInfo));
            return ipInfo;
        }
        return ipInfo1;
    }

    public MgIpInfo mgSave(MgIpInfo ipInfo) {
        String key = ipInfo.getIp();
        MgIpInfo old = (MgIpInfo)MgIpInfo.dao.findFirst("select * from mg_ip_info where ip=? and country=? and area=? and province=? and city=? and operator=?", new Object[]{key, ipInfo.getCountry(), ipInfo.getArea(), ipInfo.getProvince(), ipInfo.getCity(), ipInfo.getOperator()});
        if (old != null) {
            return old;
        }
        ipInfo.save();
        return ipInfo;
    }

    public IpInfo save(String ip) {
        IpInfo ipInfo = IpInfoService.from(ip);
        return this.save(ipInfo);
    }

    public MgIpInfo mgSave(String ip) {
        MgIpInfo ipInfo = IpInfoService.fromMg(ip);
        return this.mgSave(ipInfo);
    }

    private static IpInfo from(String ip) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            return null;
        }
        DataBlock dataBlock = Ip2Region.getDataBlock(ip);
        if (dataBlock == null) {
            log.warn("can not found DataBlock by ip {}", (Object)ip);
            return null;
        }
        String region = dataBlock.getRegion();
        String[] fs = StrUtil.split((CharSequence)region, (CharSequence)"|");
        if (fs.length != 5) {
            log.warn("ip[{}]'region[{}] is invalid", (Object)ip, (Object)region);
            return null;
        }
        int i = 0;
        IpInfo ipInfo = new IpInfo();
        ipInfo.setCountry("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setArea("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setProvince("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setCity("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setOperator("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setTime(new Date());
        ipInfo.setIp(ip);
        return ipInfo;
    }

    private static MgIpInfo fromMg(String ip) {
        if (StrUtil.isBlank((CharSequence)ip)) {
            return null;
        }
        DataBlock dataBlock = Ip2Region.getDataBlock(ip);
        if (dataBlock == null) {
            log.warn("can not found DataBlock by ip {}", (Object)ip);
            return null;
        }
        String region = dataBlock.getRegion();
        String[] fs = StrUtil.split((CharSequence)region, (CharSequence)"|");
        if (fs.length != 5) {
            log.warn("ip[{}]'region[{}] is invalid", (Object)ip, (Object)region);
            return null;
        }
        int i = 0;
        MgIpInfo ipInfo = new MgIpInfo();
        ipInfo.setCountry("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setArea("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setProvince("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setCity("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setOperator("0".equals(fs[i++]) ? "" : fs[i - 1]);
        ipInfo.setTime(new Date());
        ipInfo.setIp(ip);
        return ipInfo;
    }
}

