/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.base;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.api.sms.SmsBaseServiceIntf;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.SmsLog;
import org.tio.mg.service.service.base.AliyunSmsService;
import org.tio.sitexxx.service.vo.SentSmsResultVo;
import org.tio.utils.jfinal.P;

public class SmsBaseService
implements SmsBaseServiceIntf {
    private static Logger log = LoggerFactory.getLogger(SmsBaseService.class);
    public static SmsBaseService smsBaseService = new SmsBaseService();
    private static String paramname = P.get((String)"sms.aliyun.param.name");

    public static boolean isMobileNo(String mobile) {
        if (mobile == null || mobile.length() != 11 || !mobile.startsWith("1")) {
            return false;
        }
        return NumberUtils.isDigits((String)mobile);
    }

    public static void main(String[] args) throws Exception {
    }

    @Override
    public String send(String remoteip, String mobile, String smsCheckType, String sessionid, String referer, String cookieKey) throws Exception {
        return this.send(remoteip, mobile, smsCheckType, sessionid, referer, cookieKey, null);
    }

    @Override
    public String get(String mobile, String smsCheckType) throws Exception {
        if (StrUtil.isBlank((CharSequence)mobile)) {
            return null;
        }
        String code = (String)((Object)Caches.getCache(CacheConfig.SMS_MOBILE_CODE).get(mobile + "_" + smsCheckType));
        return code;
    }

    @Override
    public void del(String mobile, String smsCheckType) throws Exception {
        if (StrUtil.isBlank((CharSequence)mobile)) {
            return;
        }
        Caches.getCache(CacheConfig.SMS_MOBILE_CODE).remove(mobile + "_" + smsCheckType);
    }

    @Override
    public String send(String remoteip, String mobile, String smsCheckType, String sessionid, String referer, String cookieKey, Map<String, String> params) throws Exception {
        String cacheCode;
        Integer mobilecount;
        if (mobile.equals("19800000099")) {
            Caches.getCache(CacheConfig.SMS_MOBILE_CODE).put(mobile + "_" + smsCheckType, (Serializable)((Object)"111111"));
            return "111111";
        }
        String templateCode = P.get((String)("sms.aliyun.templateCode." + smsCheckType));
        if (!SmsBaseService.isMobileNo(mobile)) {
            log.error("mobile:{}, is invalid", (Object)mobile);
            this.saveSmsInfo(remoteip, mobile, "", templateCode, smsCheckType, "\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e", 0, 0, null, (byte)2, sessionid, referer, cookieKey);
            return "\u624b\u673a\u53f7\u683c\u5f0f\u6709\u8bef";
        }
        Integer ipcount = null;
        int maxcountperday4ip = P.getInt((String)"sms.maxcount.ip.perday", (Integer)50);
        ipcount = (Integer)Caches.getCache(CacheConfig.SMS_IP_COUNT).get(remoteip);
        if (ipcount != null && ipcount > maxcountperday4ip) {
            log.error("ip:{}, has sent {}", (Object)mobile, (Object)ipcount);
            this.saveSmsInfo(remoteip, mobile, "", templateCode, smsCheckType, "24\u5c0f\u65f6\u5185ip\u83b7\u53d6\u9a8c\u8bc1\u7801\u6b21\u6570\u8d85\u4e0a\u9650", 0, ipcount, null, (byte)2, sessionid, referer, cookieKey);
            return "24\u5c0f\u65f6\u5185\u83b7\u53d6\u9a8c\u8bc1\u7801\u6b21\u6570\u8d85\u4e0a\u9650\uff01";
        }
        if (ipcount == null) {
            ipcount = 0;
        }
        if ((mobilecount = (Integer)Caches.getCache(CacheConfig.SMS_MOBILE_COUNT).get(mobile)) == null) {
            mobilecount = 0;
        } else if (mobilecount >= P.getInt((String)"sms.maxcount.mobile.perday", (Integer)10)) {
            this.saveSmsInfo(remoteip, mobile, "", templateCode, smsCheckType, "24\u5c0f\u65f6\u5185\u624b\u673a\u83b7\u53d6\u9a8c\u8bc1\u7801\u6b21\u6570\u8d85\u4e0a\u9650", mobilecount, ipcount, null, (byte)2, sessionid, referer, cookieKey);
            log.error("mobile:{}, has sent {}", (Object)mobile, (Object)mobilecount);
            return "24\u5c0f\u65f6\u5185\u83b7\u53d6\u9a8c\u8bc1\u7801\u6b21\u6570\u8d85\u4e0a\u9650\uff01";
        }
        Integer deviceCount = null;
        if (StrUtil.isNotBlank((CharSequence)cookieKey)) {
            deviceCount = (Integer)Caches.getCache(CacheConfig.SMS_DEVICE_COUNT).get(cookieKey);
            if (deviceCount == null) {
                deviceCount = 0;
            }
            if (deviceCount >= P.getInt((String)"sms.maxcount.device.count", (Integer)5)) {
                this.saveSmsInfo(remoteip, mobile, "", templateCode, smsCheckType, "1\u4e2a\u8bbe\u59071\u4e2a\u5c0f\u65f6\u53ea\u80fd\u53d1\u90015\u6b21", mobilecount, ipcount, deviceCount, (byte)2, sessionid, referer, cookieKey);
                log.error("mobile:{}, has sent {}", (Object)mobile, (Object)mobilecount);
                return "\u8bbe\u5907\u53d1\u9001\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
            }
        }
        String code = cacheCode = this.get(mobile, smsCheckType);
        if (cacheCode == null) {
            code = RandomUtils.nextInt((int)100000, (int)999999) + "";
        }
        AliyunSmsService smsService = new AliyunSmsService();
        SentSmsResultVo sentResultVo = null;
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put(paramname, code);
        if (params != null) {
            param.putAll(params);
        }
        if ((sentResultVo = smsService.sendSms(mobile, P.get((String)"sms.aliyun.signName"), templateCode, param)).getThirdCode().equals("OK")) {
            Integer n = mobilecount;
            Integer n2 = mobilecount = Integer.valueOf(mobilecount + 1);
            Caches.getCache(CacheConfig.SMS_MOBILE_COUNT).put(mobile, (Serializable)mobilecount);
            if (ipcount != null) {
                n = ipcount;
                n2 = ipcount = Integer.valueOf(ipcount + 1);
                Caches.getCache(CacheConfig.SMS_IP_COUNT).put(remoteip, (Serializable)ipcount);
            }
            if (cacheCode == null) {
                Caches.getCache(CacheConfig.SMS_MOBILE_CODE).put(mobile + "_" + smsCheckType, (Serializable)((Object)code));
            }
            if (StrUtil.isNotBlank((CharSequence)cookieKey) && deviceCount != null) {
                n = deviceCount;
                n2 = deviceCount = Integer.valueOf(deviceCount + 1);
                Caches.getCache(CacheConfig.SMS_DEVICE_COUNT).put(cookieKey, (Serializable)deviceCount);
            }
            sentResultVo.setCode(Integer.valueOf(1));
            this.saveSmsInfo(remoteip, mobile, code, templateCode, smsCheckType, "", mobilecount, ipcount, deviceCount, (byte)1, sessionid, referer, cookieKey);
            return code;
        }
        log.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff0c\u77ed\u4fe1\u63a5\u53e3:{}, \u624b\u673a\u53f7\u7801:{}, remoteip:{},msg:{}", new Object[]{smsService.getClass().getName(), mobile, remoteip, sentResultVo.getThirdMsg()});
        this.saveSmsInfo(remoteip, mobile, code, templateCode, smsCheckType, sentResultVo.getThirdMsg(), mobilecount, ipcount, deviceCount, (byte)2, sessionid, referer, cookieKey);
        return sentResultVo.getThirdMsg();
    }

    private void saveSmsInfo(String remoteip, String mobile, String code, String templateCode, String smsCheckType, String errorMsg, Integer mobilecount, Integer ipcount, Integer devicecount, Byte status, String sessionid, String referer, String cookiekey) {
        SmsLog smsLog = new SmsLog();
        smsLog.setIp(remoteip);
        smsLog.setPhone(mobile);
        smsLog.setSmscode(code);
        smsLog.setTempcode(templateCode);
        smsLog.setType(smsCheckType);
        smsLog.setStatus(status);
        smsLog.setErrormsg(errorMsg);
        smsLog.setPhone24count(mobilecount);
        smsLog.setIp24count(ipcount);
        if (devicecount != null) {
            smsLog.setDevicecount(devicecount);
        }
        if (StrUtil.isNotBlank((CharSequence)cookiekey)) {
            smsLog.setCookiekey(cookiekey);
        }
        smsLog.setSessionid(sessionid);
        smsLog.setReferer(referer);
        smsLog.save();
    }
}

