/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.chat;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.WxChatGroupItem;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.model.main.WxChatUserItem;
import org.tio.mg.service.model.main.WxGroup;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.ChatService;
import org.tio.mg.service.service.chat.GroupService;
import org.tio.mg.service.topic.Topics;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class ChatIndexService {
    private static Logger log = LoggerFactory.getLogger(ChatIndexService.class);
    public static final ChatIndexService me = new ChatIndexService();
    final WxChatUserItem userItemDao = (WxChatUserItem)new WxChatUserItem().dao();
    final WxChatGroupItem groupItemDao = (WxChatGroupItem)new WxChatGroupItem().dao();

    public List<WxChatGroupItem> getNoActGroupIndex(Long groupid) {
        return this.getLinkActGroupIndex(groupid, (byte)1, (byte)2);
    }

    public WxChatGroupItem getFristGroupUserIndex(Long groupid) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getFristGroupUser", (Map)params);
        return (WxChatGroupItem)WxChatGroupItem.dao.findFirst(sqlPara);
    }

    public List<WxChatGroupItem> getLinkActGroupIndex(Long groupid, Byte link, Byte act) {
        if (groupid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid);
        if (link != null) {
            params.set((Object)"linkflag", (Object)link);
        }
        if (act != null) {
            params.set((Object)"actflag", (Object)act);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.linkActGroupList", (Map)params);
        return WxChatGroupItem.dao.find(sqlPara);
    }

    public List<WxChatGroupItem> getNoStartMsgGroupIndex(Long groupid) {
        if (groupid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.noStartMsgList", (Map)params);
        return WxChatGroupItem.dao.find(sqlPara);
    }

    public List<WxChatGroupItem> getGroupLinkItems(Long groupid) {
        return this.getLinkActGroupIndex(groupid, (byte)1, null);
    }

    public List<WxChatUserItem> getLinkActUserIndex(Integer uid, Byte chatmode, Byte link, Byte act) {
        if (uid == null) {
            return null;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid);
        if (link != null) {
            params.set((Object)"linkflag", (Object)link);
        }
        if (act != null) {
            params.set((Object)"actflag", (Object)act);
        }
        if (chatmode != null) {
            params.set((Object)"chatmode", (Object)chatmode);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.linkActUserList", (Map)params);
        return WxChatUserItem.dao.find(sqlPara);
    }

    public boolean chatGroupIndexUpdate(Long groupid, Integer uid, Long chatlinkid) {
        if (groupid == null || uid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"uid", (Object)uid);
        if (chatlinkid != null) {
            params.set((Object)"chatlinkid", (Object)chatlinkid);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"resetflag", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateChatGroupIndex", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatGroupIndexDelNoAct(Long groupid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.delGroupNoAct", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatGroupIndexUpdateAllLink(Long groupid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateGroupLink", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public WxChatGroupItem chatGroupIndexUpdate(Long groupid, Integer uid, Long chatlinkid, boolean isNew) {
        WxChatGroupItem item = ChatIndexService.chatGroupIndex(uid, groupid);
        this.chatGroupIndexUpdate(groupid, uid, chatlinkid);
        if (isNew) {
            return ChatIndexService.chatGroupIndex(uid, groupid);
        }
        return item;
    }

    public boolean chatGroupIndexUpdate(Integer uid, Long groupid, Byte viewFlag, Byte actflag, Byte linkflag, Byte role, Long gpulinkid, Byte resetflag, boolean removeStartMsg) {
        boolean updateflag;
        WxChatGroupItem update = new WxChatGroupItem();
        update.setUid(uid);
        update.setGroupid(groupid);
        if (viewFlag != null) {
            update.setViewflag(viewFlag);
        }
        if (actflag != null) {
            update.setActflag(actflag);
        }
        if (resetflag != null) {
            update.setResetflag(resetflag);
        }
        if (linkflag != null) {
            update.setLinkflag(linkflag);
        }
        if (gpulinkid != null) {
            update.setGpulinkid(gpulinkid);
        }
        if (removeStartMsg) {
            update.setStartmsgid(null);
        }
        if (role != null) {
            update.setGrouprole(role);
        }
        return updateflag = update.update();
    }

    public boolean actUserGroup(Long groupid, Integer uid, Long chatlinkid, Long startmsgid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)1).set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"uid", (Object)uid).set((Object)"viewflag", (Object)1);
        if (startmsgid != null) {
            params.set((Object)"startmsgid", (Object)startmsgid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actGroupIndex", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return false;
        }
        ChatIndexService.removeChatGroupCache(groupid, uid);
        return true;
    }

    public boolean actGroupToUserIndex(Long groupid, Integer uid, Long chatlinkid, Long startmsgid) {
        if (groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"actflag", (Object)1).set((Object)"viewflag", (Object)1).set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)2);
        if (startmsgid != null) {
            params.set((Object)"startmsgid", (Object)startmsgid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actGroupToUserIndex", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return false;
        }
        ChatIndexService.removeUserCache(uid, groupid, (byte)2);
        return true;
    }

    public boolean chatGroupStartMsgUpdate(Long groupid, Long startmsgid) {
        if (groupid == null || startmsgid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1).set((Object)"startmsgid", (Object)startmsgid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatGroupStartMsgUpdate", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatUserIndexUpdate(Integer uid, Long bizid, Byte mode, Long chatlinkid, Long tochatlinkid, Long startMsgId, Byte linkflag) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (chatlinkid != null) {
            params.set((Object)"chatlinkid", (Object)chatlinkid).set((Object)"actflag", (Object)1).set((Object)"viewflag", (Object)1);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
        }
        if (linkflag != null) {
            params.set((Object)"linkflag", (Object)1);
        }
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        }
        if (tochatlinkid != null) {
            params.set((Object)"tochatlinkid", (Object)tochatlinkid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.actChatUserIndex", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatuserUpdateToChatlink(Integer uid, Long bizid, Byte mode, Long tochatlinkid, Long startMsgId) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        }
        if (tochatlinkid != null) {
            params.set((Object)"tochatlinkid", (Object)tochatlinkid);
        } else {
            params.set((Object)"setnull", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateToChatlinkId", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatuserStartMsg(Integer uid, Long bizid, Byte mode, Long startMsgId) {
        if (uid == null || bizid == null || mode == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        } else {
            params.set((Object)"setnull", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatuserStartMsg", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatGroupStartMsg(Integer uid, Long groupid, Long startMsgId) {
        if (uid == null || groupid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"groupid", (Object)groupid);
        if (startMsgId != null) {
            params.set((Object)"startmsgid", (Object)startMsgId);
        } else {
            params.set((Object)"setnull", (Object)1).set((Object)"resetflag", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.chatgroupStartMsg", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatUserIndexUpdate(Integer uid, Long bizid, Byte mode, Byte oper) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
        switch (oper) {
            case 4: {
                params.set((Object)"setfidnull", (Object)1).set((Object)"linkflag", (Object)2).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
                break;
            }
            case 5: {
                params.set((Object)"tofidnull", (Object)1).set((Object)"linkflag", (Object)2);
                break;
            }
            case 2: {
                params.set((Object)"setnull", (Object)1).set((Object)"actflag", (Object)2).set((Object)"viewflag", (Object)2);
                break;
            }
            case 3: {
                params.set((Object)"block", (Object)1).set((Object)"viewflag", (Object)2);
                break;
            }
            case 6: {
                params.set((Object)"block", (Object)1).set((Object)"viewflag", (Object)1);
                break;
            }
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.updateChatUserIndex", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public boolean chatGroupIndexDel(Integer uid, Long groupid) {
        WxChatGroupItem delItem = new WxChatGroupItem();
        delItem.setUid(uid);
        delItem.setGroupid(groupid);
        boolean del = delItem.delete();
        return del;
    }

    public boolean chatUserIndexDel(Integer uid, Long bizid, Byte mode) {
        WxChatUserItem delItem = new WxChatUserItem();
        delItem.setUid(uid);
        delItem.setChatmode(mode);
        delItem.setBizid(bizid);
        boolean del = delItem.delete();
        return del;
    }

    public boolean chatUserIndexUpdate(Integer uid, Long bizid, Byte mode, Byte viewFlag, Byte actflag, Byte linkflag, Long linkid, Long chatlinkid, Long tochatlinkid) {
        boolean updateflag;
        WxChatUserItem update = new WxChatUserItem();
        update.setUid(uid);
        update.setChatmode(mode);
        update.setBizid(bizid);
        if (viewFlag != null) {
            update.setViewflag(viewFlag);
        }
        if (actflag != null) {
            update.setActflag(actflag);
        }
        if (tochatlinkid != null) {
            update.setTochatlinkid(tochatlinkid);
        }
        if (chatlinkid != null) {
            update.setChatlinkid(chatlinkid);
        }
        if (linkflag != null) {
            update.setLinkflag(linkflag);
        }
        if (linkid != null) {
            update.setLinkid(linkid);
        }
        return updateflag = update.update();
    }

    public WxChatUserItem chatUserIndexUpdate(Integer uid, Long bizid, Byte mode, Byte oper, boolean isNew) {
        WxChatUserItem item = ChatIndexService.chatUserIndex(uid, bizid, mode);
        this.chatUserIndexUpdate(uid, bizid, mode, oper);
        if (isNew) {
            return ChatIndexService.chatUserIndex(uid, bizid, mode);
        }
        return item;
    }

    public int chatGroupInit(Integer uid, Long groupid, Long chatlinkid, Long gpulinkid, Byte view, Byte act, Byte link, Byte grouprole, Long startmsgid, Byte resetflag) {
        int init;
        WxChatGroupItem item = new WxChatGroupItem();
        item.setUid(uid);
        item.setGroupid(groupid);
        item.setGpulinkid(gpulinkid);
        item.setChatlinkid(chatlinkid);
        item.setLinkflag(link);
        item.setActflag(act);
        item.setViewflag(view);
        item.setGrouprole(grouprole);
        if (startmsgid != null) {
            item.setStartmsgid(startmsgid);
        }
        if (resetflag != null) {
            item.setResetflag(resetflag);
        }
        if ((init = item.ignoreSave()) > 0) {
            ChatIndexService.setGroupIndexCache(groupid + "_" + uid, item);
        }
        return init;
    }

    public int chatGroupInit(Integer uid, Long groupid, Long chatlinkid, Long gpulinkid, Byte grouprole, Long startmsgid, Byte retsetFlag) {
        return this.chatGroupInit(uid, groupid, chatlinkid, gpulinkid, (byte)1, (byte)1, (byte)1, grouprole, startmsgid, retsetFlag);
    }

    public int chatGroupInit(Integer uid, Long groupid, Long chatlinkid, Long gpulinkid, Long startmsgid, Byte retsetFlag) {
        return this.chatGroupInit(uid, groupid, chatlinkid, gpulinkid, (byte)1, (byte)1, (byte)1, (byte)2, startmsgid, retsetFlag);
    }

    public int chatGroupInit(Integer uid, Long groupid, Long gpulinkid) {
        return this.chatGroupInit(uid, groupid, null, gpulinkid, (byte)2, (byte)2, (byte)1, (byte)2, null, null);
    }

    public int chatUserInit(Integer uid, Byte chatmode, Long bizid, Long chatlinkid, Long tochatlinkid, Long linkid, Byte viewFlag, Byte actfByte, Byte linkfByte, Long startmsgid) {
        int init;
        WxChatUserItem item = new WxChatUserItem();
        item.setUid(uid);
        item.setChatmode(chatmode);
        item.setBizid(bizid);
        item.setLinkid(linkid);
        item.setChatlinkid(chatlinkid);
        item.setTochatlinkid(tochatlinkid);
        item.setLinkflag(linkfByte);
        item.setActflag(actfByte);
        item.setViewflag(viewFlag);
        if (Objects.equals(chatmode, (byte)1)) {
            item.setFidkey(UserService.twoUid(uid, bizid.intValue()));
        }
        if (startmsgid != null) {
            item.setStartmsgid(startmsgid);
        }
        if ((init = item.ignoreSave()) > 0) {
            ChatIndexService.setUserIndexCache(uid + "_" + chatmode + "_" + bizid, item);
        }
        return init;
    }

    public int chatUserInit(Long fid, Integer uid, Byte chatmode, Long bizid, Long chatlinkid, Long tochatlinkid) {
        return this.chatUserInit(uid, chatmode, bizid, chatlinkid, tochatlinkid, fid, (byte)1, (byte)1, (byte)1, null);
    }

    public int chatUserInit(Long fid, Integer uid, Byte chatmode, Long bizid) {
        return this.chatUserInit(uid, chatmode, bizid, null, null, fid, (byte)2, (byte)2, (byte)1, null);
    }

    public int chatUserInit(Integer uid, Byte chatmode, Long bizid, Long chatlinkid, Long linkid, Long startmsgid) {
        return this.chatUserInit(uid, chatmode, bizid, chatlinkid, null, linkid, (byte)1, (byte)1, (byte)1, startmsgid);
    }

    public int chatUserInit(Integer uid, Byte chatmode, Long bizid) {
        return this.chatUserInit(uid, chatmode, bizid, null, null, null, (byte)2, (byte)2, (byte)1, null);
    }

    public static WxChatUserItem chatUserIndex(final Integer uid, final Long bizid, final Byte mode) {
        if (bizid == null || uid == null || mode == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_USER_INDEX_1);
        String key = uid + "_" + mode + "_" + bizid;
        WxChatUserItem userIndex = (WxChatUserItem)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<WxChatUserItem>(){

            public WxChatUserItem create() {
                Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)mode).set((Object)"bizid", (Object)bizid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getuserindex", (Map)params);
                WxChatUserItem userItem = (WxChatUserItem)WxChatUserItem.dao.findFirst(sqlPara);
                return userItem;
            }
        }));
        return userIndex;
    }

    public static WxChatUserItem chatUserIndex(Integer uid, Integer bizid, Byte mode) {
        return ChatIndexService.chatUserIndex(uid, new Long(bizid.intValue()), mode);
    }

    public static WxChatUserItem chatUserIndex(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatUserIndex(items.getUid(), items.getBizid(), items.getChatmode());
    }

    public static WxChatGroupItem chatGroupIndex(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null) {
            return null;
        }
        return ChatIndexService.chatGroupIndex(items.getUid(), items.getBizid());
    }

    public static WxChatUserItem fdUserIndex(Integer uid, Integer touid) {
        return ChatIndexService.chatUserIndex(uid, new Long(touid.intValue()), (Byte)1);
    }

    public static WxChatUserItem groupUserIndex(Integer uid, Long groupid) {
        return ChatIndexService.chatUserIndex(uid, groupid, (Byte)2);
    }

    public static WxChatGroupItem chatGroupIndex(final Integer uid, final Long groupid) {
        if (groupid == null || uid == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2);
        String key = groupid + "_" + uid;
        WxChatGroupItem groupindex = (WxChatGroupItem)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<WxChatGroupItem>(){

            public WxChatGroupItem create() {
                Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"uid", (Object)uid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.getgroupindex", (Map)params);
                WxChatGroupItem groupItem = (WxChatGroupItem)WxChatGroupItem.dao.findFirst(sqlPara);
                return groupItem;
            }
        }));
        return groupindex;
    }

    public static void removeBlockCache(Integer uid, Integer touid) {
        if (uid == null || touid == null) {
            return;
        }
        Caches.getCache(CacheConfig.CHAT_USER_BLOCK_1).remove(uid + "_" + touid);
    }

    public static void clearChatUserIndex(Integer uid, Long bizid, Byte mode) {
        if (bizid == null || uid == null || mode == null) {
            return;
        }
        ChatIndexService.removeUserCache(uid, bizid, mode);
        if (Objects.equals(mode, (byte)2)) {
            ChatIndexService.removeChatGroupCache(bizid, uid);
        }
    }

    public static void clearMailListCache(Integer uid) {
        Caches.getCache(CacheConfig.WX_MAILLIST_1).remove(uid + "_99");
        Caches.getCache(CacheConfig.WX_MAILLIST_1).remove(uid + "_" + 1);
        Caches.getCache(CacheConfig.WX_MAILLIST_1).remove(uid + "_" + 2);
    }

    public static void clearFriendInfoCache(Long fid, Integer uid) {
        Caches.getCache(CacheConfig.WX_MY_FRIEND).remove(fid + "");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", uid);
        String path = "/wx/friend/friendInfo";
        Topics.notifyRemoveHttpCache(path, uid, param, 2);
    }

    public static void clearChatP2pIndex(Integer uid, Integer toUid) {
        ChatIndexService.removeUserCache(uid, new Long(toUid.intValue()), (byte)1);
    }

    public static void clearChatGroupIndex(Long groupid, Integer uid) {
        ChatIndexService.removeChatGroupCache(groupid, uid);
        ChatIndexService.removeUserCache(uid, groupid, (byte)2);
    }

    public static void removeUserCache(Integer uid, Long bizid, Byte mode) {
        String key = uid + "_" + mode + "_" + bizid;
        Caches.getCache(CacheConfig.CHAT_USER_INDEX_1).remove(key);
    }

    public static void removeGroupCache(Long groupid) {
        String key = groupid + "";
        Caches.getCache(CacheConfig.WX_GROUP_1).remove(key);
    }

    public static void clearGroupUserCache(Long groupid) {
        WxGroup group = GroupService.me.getByGroupid(groupid);
        if (group == null) {
            return;
        }
        double loop = Math.ceil((double)group.getJoinnum().shortValue() / 100.0);
        for (int i = 0; (double)i < loop && i <= 3; ++i) {
            String key = groupid + "_" + (i + 1);
            Caches.getCache(CacheConfig.CHAT_GROUP_USER_LIST_2).remove(key);
        }
    }

    public static void clearGroupMsgCache(Long groupid) {
        String key = groupid + "";
        Caches.getCache(CacheConfig.WX_GROUP_CHAT_3).remove(key);
    }

    public static void removeChatGroupCache(Long groupid, Integer uid) {
        String groupKey = groupid + "_" + uid;
        Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2).remove(groupKey);
    }

    public static void setUserIndexCache(String key, WxChatUserItem userItem) {
        Caches.getCache(CacheConfig.CHAT_USER_INDEX_1).put(key, (Serializable)((Object)userItem));
    }

    public static void setGroupIndexCache(String key, WxChatGroupItem groupItem) {
        Caches.getCache(CacheConfig.CHAT_GROUP_INDEX_2).put(key, (Serializable)((Object)groupItem));
    }

    public static void removeChatItemsCache(Long chatlinkid) {
        String key = chatlinkid + "";
        Caches.getCache(CacheConfig.CHAT_ITEMS_3).remove(key);
    }
}

