/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.chat;

import cn.hutool.core.util.StrUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.WxChatGroupItem;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.model.main.WxChatUserItem;
import org.tio.mg.service.model.main.WxFriendMsg;
import org.tio.mg.service.model.main.WxGroupMsg;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.ChatIndexService;
import org.tio.mg.service.service.chat.ChatService;
import org.tio.mg.service.service.chat.FriendService;
import org.tio.mg.service.service.chat.GroupService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Devicetype;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.utils.cache.ICache;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.LockUtils;

public class ChatMsgService {
    private static Logger log = LoggerFactory.getLogger(ChatMsgService.class);
    public static final ChatMsgService me = new ChatMsgService();
    static final ICache CHAT_FOUCUS_CACHE = Caches.getCache(CacheConfig.CHAT_ON_FOCUS_1);
    public static Long MSG_BACK_MAX_TIME = 120000L;

    public Ret msgOper(User curr, Long chatlinkid, Byte oper, String mids, Byte chatmode) {
        if (chatlinkid == null || oper == null || StrUtil.isBlank((CharSequence)mids)) {
            return RetUtils.invalidParam();
        }
        if (Objects.equals(chatmode, (byte)1)) {
            return this.p2pMsgOper(curr, chatlinkid, oper, mids);
        }
        return this.groupMsgOper(curr, chatlinkid, oper, mids);
    }

    public Ret p2pMsgOper(User curr, Long chatlinkid, Byte oper, String mids) {
        WxChatUserItem chatUserItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (!ChatService.friendExistChat(chatUserItem)) {
            return RetUtils.noExistParam();
        }
        Ret ret = null;
        switch (oper) {
            case 1: {
                ret = FriendService.me.delMsg(chatUserItem, mids);
                break;
            }
            case 9: {
                ret = FriendService.me.backMsg(chatUserItem, mids);
                break;
            }
            default: {
                return RetUtils.noImplement();
            }
        }
        return ret;
    }

    public Ret groupMsgOper(User curr, Long chatlinkid, Byte oper, String mids) {
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(chatlinkid);
        Ret ret = null;
        switch (oper) {
            case 1: {
                ret = GroupService.me.delMsg(groupItem, mids);
                break;
            }
            case 9: {
                ret = GroupService.me.backMsg(groupItem, mids);
                break;
            }
            default: {
                return RetUtils.noImplement();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret onFocus(User curr, Long chatlinkid, Long groupid, Byte chatmode, Byte devicetype, Integer ipid) {
        if (Objects.equals(devicetype, Devicetype.IOS.getValue()) || Objects.equals(devicetype, Devicetype.ANDROID.getValue())) {
            devicetype = Devicetype.APP.getValue();
        }
        String key = curr.getId() + "_" + devicetype;
        FocusVo focusVo = new FocusVo();
        focusVo.setUid(curr.getId());
        focusVo.setChatlinkid(chatlinkid);
        focusVo.setDevicetype(devicetype);
        focusVo.setChatmode(chatmode);
        focusVo.setIpid(ipid);
        focusVo.setGroupid(groupid);
        ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            FocusVo old;
            Serializable object = CHAT_FOUCUS_CACHE.get(key);
            if (object != null && Objects.equals((old = (FocusVo)object).getChatmode(), (byte)2)) {
                ChatService.me.updateFocus(old.getGroupid(), old.getUid(), (byte)2);
            }
            CHAT_FOUCUS_CACHE.put(key, (Serializable)focusVo);
            if (Objects.equals(chatmode, (byte)2)) {
                ChatService.me.updateFocus(groupid, curr.getId(), (byte)1);
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        Ret ret = this.beforeFocus(curr, chatlinkid, ipid, devicetype);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFocus(User curr, Byte devicetype) {
        String key = curr.getId() + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                CHAT_FOUCUS_CACHE.remove(key);
                CHAT_FOUCUS_CACHE.put(key, object);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FocusVo getFocus(Integer uid, Byte devicetype) {
        String key = uid + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.ReadLock readLock = lock.readLock();
            readLock.lock();
            try {
                FocusVo focusVo = (FocusVo)object;
                return focusVo;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ret leaveChat(User curr, Byte devicetype) {
        String key = curr.getId() + "_" + devicetype;
        Serializable object = CHAT_FOUCUS_CACHE.get(key);
        if (object != null) {
            ReentrantReadWriteLock lock = LockUtils.getReentrantReadWriteLock((String)(CHAT_FOUCUS_CACHE.getCacheName() + "_" + key), null);
            ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
            writeLock.lock();
            try {
                FocusVo focusVo = (FocusVo)object;
                if (Objects.equals(focusVo.getChatmode(), (byte)2)) {
                    ChatService.me.updateFocus(focusVo.getGroupid(), focusVo.getUid(), (byte)2);
                }
                CHAT_FOUCUS_CACHE.remove(key);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            finally {
                writeLock.unlock();
            }
        }
        return RetUtils.okOper();
    }

    public Ret p2pMsgList(Long chatlinkid, Integer uid, Long startmid, Long endmid) {
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null || !Objects.equals(items.getChatmode(), (byte)1)) {
            return RetUtils.invalidParam();
        }
        if (!Objects.equals(items.getUid(), uid)) {
            return RetUtils.grantError();
        }
        String key = items.getFidkey();
        if (StrUtil.isBlank((CharSequence)key)) {
            return RetUtils.versionError();
        }
        if (startmid == null && endmid == null) {
            ListWithLock<WxFriendMsg> listWithLock = FriendService.me.getP2PMsgList(chatlinkid);
            if (listWithLock != null) {
                return RetUtils.okData(listWithLock.getObj());
            }
            return RetUtils.okData(new ArrayList());
        }
        if (startmid != null) {
            List<WxFriendMsg> msglistList = FriendService.me.getOtherP2PMsgList(chatlinkid, startmid);
            if (msglistList != null) {
                return RetUtils.okData(msglistList);
            }
            return RetUtils.okData(new ArrayList());
        }
        List<WxFriendMsg> msglistList = FriendService.me.getSynP2PMsgList(chatlinkid, endmid);
        if (msglistList != null) {
            return RetUtils.okData(msglistList);
        }
        return RetUtils.okData(new ArrayList());
    }

    public Ret groupMsgList(Long chatlinkid, Integer uid, Long startmid, Long endmid) {
        WxChatItems items = ChatService.me.getChatItems(chatlinkid);
        if (items == null || !Objects.equals(items.getChatmode(), (byte)2)) {
            return RetUtils.invalidParam();
        }
        if (!Objects.equals(items.getUid(), uid)) {
            return RetUtils.grantError();
        }
        if (startmid == null && endmid == null) {
            ArrayList<WxGroupMsg> list = GroupService.me.getGroupCacheMsgList(chatlinkid);
            if (list != null) {
                return RetUtils.okData(list);
            }
            return RetUtils.okData(new ArrayList());
        }
        if (startmid != null) {
            List<WxGroupMsg> msglistList = GroupService.me.getOtherGroupMsgList(chatlinkid, startmid);
            if (msglistList != null) {
                return RetUtils.okData(msglistList);
            }
            return RetUtils.okData(new ArrayList());
        }
        List<WxGroupMsg> msglistList = GroupService.me.getSynGroupMsgList(chatlinkid, endmid);
        if (msglistList != null) {
            return RetUtils.okData(msglistList);
        }
        return RetUtils.okData(new ArrayList());
    }

    public Ret afterSendFriendChatMsg(WxFriendMsg msg, User user, Long chatlinkid, Byte readflag, Byte toreadflag, Short notreadcount) {
        if (chatlinkid == null) {
            log.error("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u804a\u5929\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u804a\u5929\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        if (user == null && (user = UserService.ME.getById(msg.getUid())) == null) {
            log.error("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u6d88\u606f\u53d1\u9001\u7528\u6237\u4e0d\u5b58\u5728");
            return RetUtils.failMsg("\u6d88\u606f\u53d1\u9001\u540e\u5904\u7406,\u6d88\u606f\u53d1\u9001\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)user.getId()).set((Object)"fromnick", (Object)user.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys());
        if (readflag != null) {
            params.set((Object)"readflag", (Object)readflag);
            if (Objects.equals(readflag, (byte)1)) {
                params.set((Object)"readnull", (Object)1);
            } else if (notreadcount != null && Objects.equals((byte)2, msg.getSendbysys())) {
                params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId());
            }
        }
        if (toreadflag != null) {
            params.set((Object)"toreadflag", (Object)toreadflag);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendP2PMsg", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u540e\u5904\u7406\u4fee\u6539\u5931\u8d25");
        }
        return Ret.ok();
    }

    public Ret afterSendGroupChatMsg(WxGroupMsg msg, Short notreadcount) {
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1);
        if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
            params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
        } else if (notreadcount == null) {
            params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
        }
        if (Objects.equals(msg.getSendbysys(), (byte)1)) {
            params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupMsg", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    public Ret afterSendGroupAtMsg(WxGroupMsg msg, String ats, Short notreadcount) {
        if (StrUtil.isBlank((CharSequence)ats)) {
            return Ret.ok().set((Object)"msg", (Object)"\u65e0at\u4fe1\u606f");
        }
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"linkflag", (Object)1);
        params.set((Object)"atnotreadcount", (Object)notreadcount).set((Object)"atnotreadstartmsgid", (Object)msg.getId()).set((Object)"ats", (Object)ats).set((Object)"focusflag", (Object)2).set((Object)"atreadflag", (Object)2);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupAtMsg", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    public Ret afterSendGroupById(WxGroupMsg msg, Short notreadcount, Long chatlinkid) {
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1).set((Object)"id", (Object)chatlinkid);
        if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
            params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
        } else if (notreadcount == null) {
            params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
        }
        if (Objects.equals(msg.getSendbysys(), (byte)1)) {
            params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.sendGroupMsgById", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    public Ret delGroupChatMsg(WxGroupMsg msg, Short notreadcount) {
        Kv params = Kv.by((Object)"groupid", (Object)msg.getGroupid()).set((Object)"lastmsgid", (Object)msg.getId()).set((Object)"lastmsguid", (Object)msg.getUid()).set((Object)"fromnick", (Object)msg.getNick()).set((Object)"msgresume", (Object)msg.getResume()).set((Object)"sendtime", (Object)msg.getTime()).set((Object)"sysflag", (Object)msg.getSendbysys()).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1).set((Object)"newlink", (Object)2);
        if (notreadcount != null && Objects.equals(msg.getSendbysys(), (byte)2)) {
            params.set((Object)"notreadcount", (Object)notreadcount).set((Object)"notreadstartmsgid", (Object)msg.getId()).set((Object)"focusflag", (Object)2).set((Object)"readflag", (Object)2);
        } else if (notreadcount == null) {
            params.set((Object)"focusflag", (Object)1).set((Object)"readflag", (Object)1);
        }
        if (Objects.equals(msg.getSendbysys(), (byte)1)) {
            params.set((Object)"sysmsgkey", (Object)msg.getSysmsgkey()).set((Object)"opernick", (Object)msg.getOpernick()).set((Object)"tonicks", (Object)msg.getTonicks());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.delGroupChatMsg", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return RetUtils.okOper();
    }

    public Ret beforeFocus(final User user, final Long chatlinkid, final Integer ipid, final Byte devicetype) {
        if (chatlinkid == null) {
            log.error("\u7126\u70b9\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u7126\u70b9\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        final WxChatUserItem userItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (userItem == null) {
            return RetUtils.failMsg("\u4f1a\u8bdd\u7d22\u5f15\u4e0d\u5b58\u5728");
        }
        AbsTxAtom focus = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                Ret read;
                boolean isToRead = false;
                if (userItem.getTochatlinkid() != null) {
                    Ret toread = ChatMsgService.this.chatToRead(userItem.getTochatlinkid());
                    if (toread.isFail()) {
                        log.warn("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u5bf9\u65b9\u5df2\u8bfb\u672a\u53d8\u5316");
                    } else {
                        isToRead = true;
                    }
                }
                if ((read = ChatMsgService.this.chatRead(chatlinkid, Objects.equals(userItem.getChatmode(), (byte)1) ? null : Byte.valueOf((byte)1))).isFail()) {
                    log.warn("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u5df2\u8bfb\u672a\u53d8\u5316");
                } else if (Objects.equals(userItem.getChatmode(), (byte)1)) {
                    Ret msgRead = ChatMsgService.this.p2pMsgRead(userItem.getFidkey(), user.getId(), ipid, devicetype);
                    if (msgRead.isFail()) {
                        log.warn("\u7126\u70b9\u903b\u8f91\u5904\u7406\uff1a\u6d88\u606f\u5df2\u8bfb\u672a\u53d8\u5316");
                    } else {
                        isToRead = true;
                    }
                }
                this.okRet(isToRead);
                return true;
            }
        };
        boolean tx = Db.use((String)"tio_site_main").tx((IAtom)focus);
        if (!tx) {
            return RetUtils.sysError();
        }
        Ret okRet = focus.getRetObj();
        boolean isToRead = (Boolean)RetUtils.getOkTData(okRet);
        if (isToRead) {
            FriendService.me.clearP2pChatCache(userItem.getChatlinkid());
            if (userItem.getTochatlinkid() != null) {
                okRet.set((Object)"touid", (Object)userItem.getBizid().intValue());
                okRet.set((Object)"tochatlinkid", (Object)userItem.getTochatlinkid());
                FriendService.me.clearP2pChatCache(userItem.getChatlinkid());
            }
        }
        ChatIndexService.removeChatItemsCache(chatlinkid);
        return okRet;
    }

    public Ret chatRead(Long chatlinkid, Byte atflag) {
        if (chatlinkid == null) {
            log.error("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"readflag", (Object)1);
        if (atflag != null) {
            params.set((Object)"atreadflag", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.chatRead", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u5df2\u8bfb\u672a\u53d8\u5316");
        }
        return Ret.ok();
    }

    public Ret chatToRead(Long chatlinkid) {
        if (chatlinkid == null) {
            log.error("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
            return RetUtils.failMsg("\u5904\u7406\u5f02\u5e38\uff1a\u4f1a\u8bdd\u4e3a\u7a7a");
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid).set((Object)"toreadflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.chatToRead", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u5bf9\u65b9\u5df2\u8bfb\u672a\u53d8\u5316");
        }
        return Ret.ok();
    }

    public WxFriendMsg getLastMsg(String fidKey, Integer touid) {
        if (StrUtil.isBlank((CharSequence)fidKey) || touid == null) {
            return null;
        }
        WxFriendMsg last = (WxFriendMsg)WxFriendMsg.dao.findFirst("select * from wx_friend_msg where twouid = ? and sigleuid != ?  order by id desc limit 0,1", new Object[]{fidKey, touid});
        return last;
    }

    public Ret p2pMsgRead(String fidKey, Integer uid, Integer ipid, Byte devicetype) {
        if (StrUtil.isBlank((CharSequence)fidKey) || uid == null) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"touid", (Object)uid).set((Object)"twouid", (Object)fidKey).set((Object)"readipid", (Object)ipid).set((Object)"readdevice", (Object)devicetype).set((Object)"readflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.p2pMsgRead", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        if (update <= 0) {
            return RetUtils.failMsg("\u5df2\u8bfb\u672a\u53d8\u5316");
        }
        return Ret.ok();
    }

    public Ret groupMsgDel(String mids, Integer uid, Long groupid) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"mids", (Object)mids).set((Object)"groupid", (Object)groupid).set((Object)"yes", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgDel", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
        return Ret.ok();
    }

    public void rebindGroupMsgDeal(WxChatItems chatItems) {
        Long startMid = chatItems.getLastmsgid();
        if (startMid == null) {
            return;
        }
        Kv params = Kv.by((Object)"uid", (Object)chatItems.getUid()).set((Object)"startMid", (Object)startMid).set((Object)"groupid", (Object)chatItems.getBizid()).set((Object)"yes", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.rebindGroupMsgDeal", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
    }

    public static FocusVo isFocus(Integer uid, Long chatlinkid) {
        FocusVo pc = me.getFocus(uid, Devicetype.PC.getValue());
        if (pc != null && Objects.equals(pc.getChatlinkid(), chatlinkid)) {
            return pc;
        }
        FocusVo app = me.getFocus(uid, Devicetype.APP.getValue());
        if (app != null && Objects.equals(app.getChatlinkid(), chatlinkid)) {
            return app;
        }
        FocusVo h5 = me.getFocus(uid, Devicetype.H5.getValue());
        if (h5 != null && Objects.equals(h5.getChatlinkid(), chatlinkid)) {
            return h5;
        }
        return null;
    }

    public static interface MsgTemplate {
        public static final String create = "%%% \u9080\u8bf7 ### \u52a0\u5165\u4e86\u7fa4\u804a";
        public static final String join = "%%% \u9080\u8bf7 ### \u52a0\u5165\u4e86\u7fa4\u804a";
        public static final String ownerleave = "%%% \u9000\u51fa\u4e86\u7fa4\u804a\uff0c### \u81ea\u52a8\u6210\u4e3a\u7fa4\u4e3b";
        public static final String leave = "%%% \u9000\u51fa\u4e86\u7fa4\u804a";
        public static final String operkick = "%%% \u5c06 ### \u79fb\u9664\u4e86\u7fa4\u804a";
        public static final String tokick = "### \u88ab %%% \u79fb\u9664\u4e86\u7fa4\u804a";
        public static final String msgback = "%%% \u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f";
        public static final String ownerchange = "%%% \u5c06\u7fa4\u4e3b\u8f6c\u8ba9\u7ed9\u4e86 ###";
        public static final String applyopen = "%%% \u5f00\u542f\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u6240\u6709\u4eba\u90fd\u53ef\u4ee5\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
        public static final String applyclose = "%%% \u5173\u95ed\u4e86\u7fa4\u9080\u8bf7\u5f00\u5173\uff1a\u53ea\u6709\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u624d\u80fd\u9080\u8bf7\u4eba\u5458\u8fdb\u7fa4";
        public static final String reviewopen = "%%% \u5f00\u542f\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u524d,\u5fc5\u987b\u7fa4\u4e3b\u6216\u8005\u7fa4\u7ba1\u7406\u5458\u5ba1\u6838\u901a\u8fc7";
        public static final String reviewclose = "%%% \u5173\u95ed\u4e86\u7fa4\u5ba1\u6838\u5f00\u5173\uff1a\u6210\u5458\u8fdb\u7fa4\u4e0d\u9700\u8981\u5ba1\u6838";
        public static final String updatenotice = "%%% \u4fee\u6539\u4e86\u7fa4\u516c\u544a:###";
        public static final String updatename = "%%% \u4fee\u6539\u4e86\u7fa4\u540d\u79f0:###";
        public static final String delgroup = "%%% \u89e3\u6563\u4e86\u7fa4";
    }
}

