/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.chat;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.CPI;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Model;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.WxChatGroupItem;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.model.main.WxChatUserItem;
import org.tio.mg.service.model.main.WxFriend;
import org.tio.mg.service.model.main.WxGroup;
import org.tio.mg.service.model.main.WxUserBlackItems;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.ChatIndexService;
import org.tio.mg.service.service.chat.FriendService;
import org.tio.mg.service.service.chat.GroupService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.utils.Threads;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class ChatService {
    private static Logger log = LoggerFactory.getLogger(ChatService.class);
    public static final ChatService me = new ChatService();
    final WxChatUserItem userItemDao = (WxChatUserItem)new WxChatUserItem().dao();
    final WxChatGroupItem groupItemDao = (WxChatGroupItem)new WxChatGroupItem().dao();
    final WxChatItems itemsDao = (WxChatItems)new WxChatItems().dao();

    public Ret chatItemList(User user) {
        if (user == null) {
            log.error("\u83b7\u53d6\u804a\u5929\u5217\u8868\uff1a\u65e0\u6548\u7528\u6237");
            return Ret.fail((Object)"msg", (Object)"\u65e0\u6548\u53c2\u6570");
        }
        Kv params = Kv.by((Object)"uid", (Object)user.getId()).set((Object)"viewflag", (Object)1);
        SqlPara sqlPara = User.dao.getSqlPara("chat.list", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        return RetUtils.okList(records);
    }

    public WxChatItems getChatItems(final Long id) {
        if (id == null) {
            return null;
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_ITEMS_3);
        String key = id + "";
        WxChatItems chatItems = (WxChatItems)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<WxChatItems>(){

            public WxChatItems create() {
                return (WxChatItems)WxChatItems.dao.findById(id);
            }
        }));
        return chatItems;
    }

    public Ret mailList(final User curr, final Byte mode, final String searchkey, final Integer pageNumber) throws Exception {
        HashMap<String, Object> result;
        block6: {
            block5: {
                if (StrUtil.isBlank((CharSequence)searchkey) && (pageNumber == null || pageNumber <= 0)) {
                    String key = curr.getId() + "";
                    key = mode == null ? key + "_99" : key + "_" + mode;
                    ICache cache = Caches.getCache(CacheConfig.WX_MAILLIST_1);
                    HashMap cacheResult = (HashMap)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<HashMap<String, Object>>(){

                        public HashMap<String, Object> create() {
                            try {
                                HashMap<String, Object> result;
                                block7: {
                                    block6: {
                                        result = new HashMap<String, Object>();
                                        if (mode == null) break block6;
                                        switch (mode) {
                                            case 1: {
                                                Ret fd = FriendService.me.fdList(curr, searchkey, pageNumber);
                                                result.put("fd", RetUtils.getOkData(fd));
                                                break block7;
                                            }
                                            case 2: {
                                                Ret group = GroupService.me.groupList(curr.getId(), searchkey);
                                                result.put("group", RetUtils.getOkData(group));
                                                break block7;
                                            }
                                            default: {
                                                return null;
                                            }
                                        }
                                    }
                                    Ret fd = FriendService.me.fdList(curr, searchkey, pageNumber);
                                    result.put("fd", RetUtils.getOkData(fd));
                                    Ret group = GroupService.me.groupList(curr.getId(), searchkey);
                                    result.put("group", RetUtils.getOkData(group));
                                }
                                return result;
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                return null;
                            }
                        }
                    });
                    return RetUtils.okData(cacheResult);
                }
                result = new HashMap<String, Object>();
                if (mode == null) break block5;
                switch (mode) {
                    case 1: {
                        Ret fd = FriendService.me.fdList(curr, searchkey, pageNumber);
                        result.put("fd", RetUtils.getOkData(fd));
                        break block6;
                    }
                    case 2: {
                        Ret group = GroupService.me.groupList(curr.getId(), searchkey);
                        result.put("group", RetUtils.getOkData(group));
                        break block6;
                    }
                    default: {
                        return RetUtils.invalidParam();
                    }
                }
            }
            Ret fd = FriendService.me.fdList(curr, searchkey, pageNumber);
            result.put("fd", RetUtils.getOkData(fd));
            Ret group = GroupService.me.groupList(curr.getId(), searchkey);
            result.put("group", RetUtils.getOkData(group));
        }
        return RetUtils.okData(result);
    }

    public Ret chatUserOper(Byte oper, Integer uid, Integer touid, Long chatlinkid) {
        if (oper == null || uid == null) {
            return RetUtils.invalidParam();
        }
        Ret ret = null;
        switch (oper) {
            case 2: {
                if (uid == null || touid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.blackOper(uid, touid);
                break;
            }
            case 3: {
                if (uid == null || touid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.romoveBlackOper(uid, touid);
                break;
            }
            case 1: {
                if (chatlinkid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.removeChatItems(chatlinkid, uid);
                break;
            }
            case 8: {
                if (chatlinkid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.clearMsgRecord(chatlinkid);
                break;
            }
            case 21: {
                if (chatlinkid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.chatTop(chatlinkid, (byte)1);
                break;
            }
            case 22: {
                if (chatlinkid == null) {
                    return RetUtils.invalidParam();
                }
                ret = this.chatTop(chatlinkid, (byte)2);
                break;
            }
            default: {
                return RetUtils.failMsg("\u65e0\u6548\u64cd\u4f5c\u7801");
            }
        }
        return ret;
    }

    public Ret blackOper(final Integer uid, final Integer touid) {
        WxUserBlackItems blackItems = ChatService.getBlockItems(uid, touid);
        if (blackItems != null) {
            return RetUtils.existParam();
        }
        final WxChatUserItem userItem = ChatIndexService.fdUserIndex(uid, touid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean block;
                if (userItem != null) {
                    boolean chatUpdate;
                    if (userItem.getChatlinkid() != null && !(chatUpdate = ChatService.this.updateChatView((byte)2, userItem.getChatlinkid()))) {
                        this.failRet("\u4fee\u6539\u89c6\u56fe\u72b6\u6001\u5f02\u5e38");
                        return false;
                    }
                    boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, new Long(touid.intValue()), (byte)1, (byte)3);
                    if (!chatindex) {
                        this.failRet("\u4fee\u6539\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                        return false;
                    }
                }
                if (!(block = ChatService.this.userBlockInit(uid, touid))) {
                    this.failRet("\u4fdd\u5b58\u9ed1\u540d\u5355\u5f02\u5e38");
                    return false;
                }
                return true;
            }
        };
        boolean atomFlag = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!atomFlag) {
            return atom.getRetObj();
        }
        if (userItem != null) {
            ChatIndexService.removeUserCache(uid, new Long(touid.intValue()), (byte)1);
            if (userItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(userItem.getChatlinkid());
                return RetUtils.okData("\u62c9\u9ed1\u4f1a\u8bdd\uff1a" + userItem.getChatlinkid()).set((Object)"chatlinkid", (Object)userItem.getChatlinkid());
            }
        }
        return RetUtils.okData("\u62c9\u9ed1\u4eba\u5458\uff1a" + touid);
    }

    public Ret romoveBlackOper(final Integer uid, final Integer touid) {
        WxUserBlackItems blackItems = ChatService.getBlockItems(uid, touid);
        if (blackItems == null) {
            return RetUtils.failMsg("\u9ed1\u540d\u5355\u4e0d\u5b58\u5728");
        }
        final WxChatUserItem userItem = ChatIndexService.fdUserIndex(uid, touid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean block;
                if (userItem != null) {
                    boolean chatUpdate;
                    if (userItem.getChatlinkid() != null && !(chatUpdate = ChatService.this.updateChatView((byte)1, userItem.getChatlinkid()))) {
                        this.failRet("\u4fee\u6539\u89c6\u56fe\u72b6\u6001\u5f02\u5e38");
                        return false;
                    }
                    boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, new Long(touid.intValue()), (byte)1, (byte)6);
                    if (!chatindex) {
                        this.failRet("\u4fee\u6539\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                        return false;
                    }
                }
                if (!(block = ChatService.this.removeBlack(uid, touid))) {
                    this.failRet("\u79fb\u9664\u9ed1\u540d\u5355\u5f02\u5e38");
                    return false;
                }
                return true;
            }
        };
        boolean atomFlag = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!atomFlag) {
            return atom.getRetObj();
        }
        ChatIndexService.removeBlockCache(uid, touid);
        if (userItem != null) {
            ChatIndexService.removeUserCache(uid, new Long(touid.intValue()), (byte)1);
            if (userItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(userItem.getChatlinkid());
                return RetUtils.okData("\u79fb\u9664\u9ed1\u540d\u5355\u4f1a\u8bdd\uff1a" + userItem.getChatlinkid()).set((Object)"chatlinkid", (Object)userItem.getChatlinkid());
            }
        }
        return RetUtils.okData("\u79fb\u9664\u9ed1\u540d\u5355\u7528\u6237\uff1a" + touid);
    }

    public Ret actFdChatItems(final Integer uid, final Integer touid) {
        final WxChatUserItem userItem = ChatIndexService.fdUserIndex(uid, touid);
        if (!ChatService.existFriend(userItem)) {
            return RetUtils.failMsg("\u5bf9\u65b9\u4e0d\u662f\u4f60\u597d\u53cb");
        }
        if (ChatService.friendExistChat(userItem)) {
            WxChatItems chatItems = this.getChatItems(userItem.getChatlinkid());
            return Ret.ok((Object)"chat", (Object)((Object)chatItems)).set((Object)"actflag", (Object)2).set((Object)"chatlinkid", (Object)userItem.getChatlinkid());
        }
        final WxChatUserItem toUserItem = ChatIndexService.fdUserIndex(touid, uid);
        final User touser = UserService.ME.getById(touid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean toChatIndex;
                if (Objects.equals(uid, touid)) {
                    WxChatItems chatItems = me.chatitemsInit(userItem.getUid(), userItem.getChatmode(), userItem.getBizid(), userItem.getLinkid(), touser.getAvatar(), touser.getNick(), userItem.getLinkflag(), (byte)1, (short)0, (byte)1, null, "", "", (byte)2, null, null, null);
                    if (chatItems == null) {
                        return this.failRet("\u521d\u59cb\u5316\u804a\u5929\u4f1a\u8bdd\u5931\u8d25");
                    }
                    boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, new Long(touid.intValue()), (byte)1, chatItems.getId(), chatItems.getId(), null, null);
                    if (!chatindex) {
                        return this.failRet("\u4fee\u6539\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                    }
                    return this.okRet(chatItems.getId());
                }
                WxFriend friend = FriendService.me.getFriendInfo(userItem.getLinkid());
                if (friend == null) {
                    return this.failRet("\u597d\u53cb\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                WxChatItems chatItems = me.chatitemsInit(userItem.getUid(), userItem.getChatmode(), userItem.getBizid(), userItem.getLinkid(), touser.getAvatar(), StrUtil.isNotBlank((CharSequence)friend.getRemarkname()) ? friend.getRemarkname() : touser.getNick(), userItem.getLinkflag(), (byte)1, (short)0, (byte)1, null, "", "", (byte)2, null, null, null);
                if (chatItems == null) {
                    return this.failRet("\u521d\u59cb\u5316\u804a\u5929\u4f1a\u8bdd\u5931\u8d25");
                }
                boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, new Long(touid.intValue()), (byte)1, chatItems.getId(), null, null, null);
                if (!chatindex) {
                    return this.failRet("\u4fee\u6539\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                }
                if (ChatService.existTwoFriend(toUserItem) && !(toChatIndex = ChatIndexService.me.chatuserUpdateToChatlink(toUserItem.getUid(), toUserItem.getBizid(), (byte)1, chatItems.getId(), null))) {
                    return this.failRet("\u4fee\u6539\u597d\u53cb\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                }
                return this.okRet(chatItems.getId());
            }
        };
        boolean atomFlag = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!atomFlag) {
            return atom.getRetObj();
        }
        Long chatlinkid = (Long)RetUtils.getOkTData(atom.getRetObj());
        if (userItem != null) {
            if (userItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(userItem.getChatlinkid());
            }
            ChatIndexService.removeUserCache(uid, new Long(touid.intValue()), (byte)1);
            if (!Objects.equals(uid, touid)) {
                ChatIndexService.removeUserCache(touid, new Long(uid.intValue()), (byte)1);
            }
        }
        WxChatItems chatItems = this.getChatItems(chatlinkid);
        return Ret.ok((Object)"chat", (Object)((Object)chatItems)).set((Object)"actflag", (Object)1).set((Object)"chatlinkid", (Object)chatlinkid);
    }

    public Ret actGroupChatItems(final Long groupid, User user) {
        final WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(user.getId(), groupid);
        if (!ChatService.groupExistChat(groupItem)) {
            return RetUtils.failMsg("\u4f60\u4e0d\u662f\u7fa4\u6210\u5458");
        }
        if (ChatService.groupChatAct(groupItem)) {
            WxChatItems chatItems = this.getChatItems(groupItem.getChatlinkid());
            WxChatItems returnItems = new WxChatItems();
            BeanUtil.copyProperties((Object)CPI.getAttrs((Model)chatItems), (Object)CPI.getAttrs((Model)returnItems), (String[])new String[0]);
            returnItems.setId(-groupid.longValue());
            return Ret.ok((Object)"chat", (Object)((Object)returnItems)).set((Object)"actflag", (Object)2);
        }
        final WxGroup group = GroupService.me.getByGroupid(groupid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxChatItems chatItem = new WxChatItems();
                chatItem.setUid(groupItem.getUid());
                chatItem.setBizid(groupItem.getGroupid());
                chatItem.setLinkid(groupItem.getGpulinkid());
                chatItem.setChatmode((byte)2);
                chatItem.setBizrole(groupItem.getGrouprole());
                chatItem.setAvatar(group.getAvatar());
                chatItem.setJoinnum(group.getJoinnum());
                chatItem.setName(group.getName());
                chatItem.setChatuptime(new Date());
                boolean chatsave = chatItem.save();
                if (!chatsave) {
                    return this.failRet("\u4f1a\u8bdd\u521d\u59cb\u5316\u5f02\u5e38");
                }
                ChatIndexService.me.actGroupToUserIndex(groupid, groupItem.getUid(), chatItem.getId(), null);
                ChatIndexService.me.actUserGroup(groupid, groupItem.getUid(), chatItem.getId(), null);
                return this.okRet(chatItem.getId());
            }
        };
        boolean atomFlag = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!atomFlag) {
            return atom.getRetObj();
        }
        Long chatlinkid = (Long)RetUtils.getOkTData(atom.getRetObj());
        WxChatItems chatItems = this.getChatItems(chatlinkid);
        WxChatItems returnItems = new WxChatItems();
        BeanUtil.copyProperties((Object)CPI.getAttrs((Model)chatItems), (Object)CPI.getAttrs((Model)returnItems), (String[])new String[0]);
        returnItems.setId(-groupid.longValue());
        return Ret.ok((Object)"chat", (Object)((Object)returnItems)).set((Object)"actflag", (Object)1);
    }

    public Ret removeChatItems(final Long id, Integer operuid) {
        final WxChatItems items = (WxChatItems)this.itemsDao.findById(id);
        if (items == null) {
            return RetUtils.failMsg("\u4f1a\u8bdd\u5df2\u79fb\u9664\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
        }
        if (!Objects.equals(operuid, items.getUid())) {
            return RetUtils.grantError();
        }
        final Integer uid = items.getUid();
        final Byte chatmode = items.getChatmode();
        final Long bizid = items.getBizid();
        final Integer touid = bizid.intValue();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                if (Objects.equals(chatmode, (byte)2)) {
                    if (Objects.equals(items.getLinkflag(), (byte)2)) {
                        ChatIndexService.me.chatGroupIndexDel(uid, items.getBizid());
                        ChatIndexService.me.chatUserIndexDel(uid, items.getBizid(), items.getChatmode());
                    } else {
                        boolean groupIndex = ChatIndexService.me.chatGroupIndexUpdate(items.getBizid(), uid, null);
                        if (!groupIndex) {
                            this.failRet("\u4fee\u6539\u7fa4\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                            return false;
                        }
                        boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, bizid, chatmode, (byte)2);
                        if (!chatindex) {
                            this.failRet("\u4fee\u6539\u7528\u6237\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                            return false;
                        }
                    }
                } else {
                    boolean toChatIndex;
                    boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(uid, bizid, chatmode, (byte)2);
                    if (!chatindex) {
                        this.failRet("\u4fee\u6539\u7528\u6237\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                        return false;
                    }
                    if (Objects.equals(items.getLinkflag(), (byte)1) && !(toChatIndex = ChatIndexService.me.chatuserUpdateToChatlink(touid, new Long(uid.intValue()), (byte)1, null, null))) {
                        return this.failRet("\u4fee\u6539\u597d\u53cb\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                    }
                }
                boolean hide = ChatService.this.itemsDao.deleteById(id);
                if (!hide) {
                    this.failRet("\u79fb\u9664\u804a\u5929\u5931\u8d25");
                    return false;
                }
                return true;
            }
        };
        boolean hide = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!hide) {
            return atom.getRetObj();
        }
        ChatIndexService.clearChatUserIndex(uid, items.getBizid(), items.getChatmode());
        if (Objects.equals(chatmode, (byte)1)) {
            ChatIndexService.clearChatUserIndex(touid, new Long(uid.intValue()), (byte)1);
            FriendService.me.clearP2pChatCache(id);
        }
        ChatIndexService.removeChatItemsCache(id);
        return RetUtils.okOper().set((Object)"chatlinkid", (Object)id).set((Object)"chat", (Object)items);
    }

    public Ret clearMsgRecord(final Long chatlinkid) {
        final WxChatItems chatItems = me.getChatItems(chatlinkid);
        if (chatItems == null) {
            return RetUtils.noExistParam();
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean startTx;
                if (Objects.equals(chatItems.getChatmode(), (byte)2) && !(startTx = ChatIndexService.me.chatGroupStartMsg(chatItems.getUid(), chatItems.getBizid(), null))) {
                    return this.failRet("\u4fee\u6539\u7fa4\u7d22\u5f15\u8d77\u59cb\u6d88\u606f\u5f02\u5e38");
                }
                startTx = ChatIndexService.me.chatuserStartMsg(chatItems.getUid(), chatItems.getBizid(), chatItems.getChatmode(), null);
                if (!startTx) {
                    return this.failRet("\u4fee\u6539\u8d77\u59cb\u6d88\u606f\u5f02\u5e38");
                }
                boolean clearMsg = ChatService.this.clearChatItemMsg(chatlinkid);
                if (!clearMsg) {
                    return this.failRet("\u6e05\u7a7a\u6d88\u606f\u5f02\u5e38");
                }
                return true;
            }
        };
        boolean clear = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!clear) {
            return atom.getRetObj();
        }
        ChatIndexService.clearChatUserIndex(chatItems.getUid(), chatItems.getBizid(), chatItems.getChatmode());
        ChatIndexService.removeChatItemsCache(chatlinkid);
        if (Objects.equals(chatItems.getChatmode(), (byte)1)) {
            FriendService.me.clearP2pChatCache(chatlinkid);
        }
        return RetUtils.okOper().set((Object)"chatlinkid", (Object)chatlinkid);
    }

    public Ret chatTop(Long chatlinkid, Byte topflag) {
        WxChatItems chatItems = me.getChatItems(chatlinkid);
        if (chatItems == null) {
            return RetUtils.noExistParam();
        }
        boolean topUpdate = this.updateChatTop(topflag, chatlinkid);
        if (!topUpdate) {
            return RetUtils.failMsg("\u7f6e\u9876\u64cd\u4f5c\u5931\u8d25");
        }
        ChatIndexService.removeChatItemsCache(chatlinkid);
        return RetUtils.okOper().set((Object)"chatlinkid", (Object)chatlinkid);
    }

    public boolean deleteChatItem(Long chatid) {
        return this.itemsDao.deleteById(chatid);
    }

    public boolean updateChatView(Byte viewflag, Long chatlinkid) {
        return this.updateChatItemStatus(chatlinkid, null, viewflag, null, null, null, null);
    }

    public void updateFocus(final Long groupid, final Integer uid, final Byte focusFlag) {
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"groupid", (Object)groupid).set((Object)"focusflag", (Object)focusFlag);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatindex.focus", (Map)params);
                Db.use((String)"tio_site_main").update(sqlPara);
            }
        });
    }

    public boolean updateChatLink(Byte linkflag, Long chatlinkid) {
        return this.updateChatItemStatus(chatlinkid, linkflag, null, null, null, null, null);
    }

    public boolean updateChatTop(Byte topflag, Long chatlinkid) {
        return this.updateChatItemStatus(chatlinkid, null, null, topflag, null, null, null);
    }

    public boolean updateChatToread(Long chatlinkid) {
        return this.updateChatItemStatus(chatlinkid, null, null, null, (byte)1, null, null);
    }

    public boolean updateChatItemStatus(Long chatlinkid, Byte linkflag, Byte viewflag, Byte topflag, Byte toreadflag, Long linkid, Short joinnum) {
        WxChatItems chatItems = new WxChatItems();
        chatItems.setId(chatlinkid);
        if (linkflag != null) {
            chatItems.setLinkflag(linkflag);
        }
        if (linkid != null) {
            chatItems.setLinkid(linkid);
        }
        if (viewflag != null) {
            chatItems.setViewflag(viewflag);
        }
        if (topflag != null) {
            chatItems.setTopflag(topflag);
        }
        if (toreadflag != null) {
            chatItems.setToreadflag(toreadflag);
        }
        if (joinnum != null) {
            chatItems.setJoinnum(joinnum);
        }
        return chatItems.update();
    }

    public void updateItemJoinNum(Short joinnum, Long groupid) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1).set((Object)"joinnum", (Object)joinnum);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.chatItemUpdateJoinNum", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
    }

    public void updateChatItemInfo(Long groupid, String name, String avatar) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1).set((Object)"actflag", (Object)1);
        if (StrUtil.isNotBlank((CharSequence)name)) {
            params.set((Object)"name", (Object)name);
        }
        if (StrUtil.isNotBlank((CharSequence)avatar)) {
            params.set((Object)"avatar", (Object)avatar);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.chatItemUpdateInfo", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
    }

    public void updateChatItemById(Long chatlinkid, String name, String avatar) {
        WxChatItems items = new WxChatItems();
        items.setId(chatlinkid);
        if (StrUtil.isNotBlank((CharSequence)name)) {
            items.setName(name);
        }
        if (StrUtil.isNotBlank((CharSequence)avatar)) {
            items.setAvatar(avatar);
        }
        items.update();
    }

    public void updateActItemLink(Long groupid, Byte link) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)link).set((Object)"actflag", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.chatItemUpdateActLinK", (Map)params);
        Db.use((String)"tio_site_main").update(sqlPara);
    }

    public boolean clearChatItemMsg(Long chatlinkid) {
        if (chatlinkid == null) {
            return false;
        }
        Kv params = Kv.by((Object)"id", (Object)chatlinkid);
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.clearChatItemMsg", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public void resetHistory() {
        Threads.getGroupExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("\u5f00\u59cb\u91cd\u7f6e\u597d\u53cb\u5386\u53f2\u6570\u636e");
                    long start = System.currentTimeMillis();
                    int count = Db.use((String)"tio_site_main").queryInt("select count(1) from wx_friend");
                    int index = (int)Math.ceil(new Double(count) / 10000.0);
                    int limit = 0;
                    HashMap<String, Long> dealMap = new HashMap<String, Long>();
                    for (int i = 0; i < index; ++i) {
                        List friends = WxFriend.dao.find("select * from wx_friend order by id limit " + limit + ",10000");
                        for (WxFriend friend : friends) {
                            if (dealMap.get(friend.getId() + "") != null) continue;
                            String sql = "select id,uid, frienduid, remarkname, createtime from wx_friend where uid = ? and frienduid = ? limit 0, 1";
                            WxFriend to = (WxFriend)WxFriend.dao.findFirst(sql, new Object[]{friend.getFrienduid(), friend.getUid()});
                            WxChatUserItem wxChatUserItem = new WxChatUserItem();
                            wxChatUserItem.setUid(friend.getUid());
                            wxChatUserItem.setChatmode((byte)1);
                            wxChatUserItem.setBizid(new Long(friend.getFrienduid().intValue()));
                            wxChatUserItem.setLinkid(friend.getId());
                            wxChatUserItem.setViewflag((byte)2);
                            wxChatUserItem.setActflag((byte)2);
                            wxChatUserItem.setFidkey(UserService.twoUid(friend.getUid(), friend.getFrienduid()));
                            if (to == null) {
                                wxChatUserItem.setLinkflag((byte)2);
                                wxChatUserItem.replaceSave();
                                continue;
                            }
                            wxChatUserItem.setLinkflag((byte)1);
                            wxChatUserItem.replaceSave();
                            WxChatUserItem toitem = new WxChatUserItem();
                            toitem.setUid(friend.getFrienduid());
                            toitem.setChatmode((byte)1);
                            toitem.setBizid(new Long(friend.getUid().intValue()));
                            toitem.setLinkid(to.getId());
                            toitem.setViewflag((byte)2);
                            toitem.setActflag((byte)2);
                            toitem.setFidkey(UserService.twoUid(friend.getUid(), friend.getFrienduid()));
                            toitem.setLinkflag((byte)1);
                            toitem.replaceSave();
                            dealMap.put(to.getId() + "", to.getId());
                        }
                        limit = (i + 1) * 10000;
                    }
                    Long end = System.currentTimeMillis();
                    System.out.println("\u91cd\u7f6e\u597d\u53cb\u5386\u53f2\u6570\u636e\u5904\u7406\u65f6\u95f4\uff1a" + (end - start) / 1000L);
                    Caches.getCache(CacheConfig.CHAT_USER_INDEX_1).clear();
                    Caches.getCache(CacheConfig.CHAT_ITEMS_3).clear();
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
        });
    }

    public boolean chatitemsInit(WxChatItems items) {
        Kv params = Kv.by((Object)"uid", (Object)items.getUid()).set((Object)"chatmode", (Object)items.getChatmode()).set((Object)"bizid", (Object)items.getBizid()).set((Object)"linkid", (Object)items.getLinkid()).set((Object)"avatar", (Object)items.getAvatar()).set((Object)"name", (Object)items.getName());
        SqlPara sqlPara = User.dao.getSqlPara("chat.chatiteminit", (Map)params);
        int init = Db.use((String)"tio_site_main").update(sqlPara);
        return init > 0;
    }

    public WxChatItems chatitemsInit(Integer uid, Byte chatmode, Long bizid, Long linkid, String avatar, String name, Byte linkflag, Byte viewflag, short notreadcount, Byte readflag, Long notreadstartmsgid, String fromnick, String msgresume, Byte sysflag, Date sendtime, Long lastmsgid, Integer lastmsguid) {
        WxChatItems items = new WxChatItems();
        items.setUid(uid);
        items.setChatmode(chatmode);
        items.setBizid(bizid);
        items.setLinkid(linkid);
        items.setAvatar(avatar);
        items.setLinkflag(linkflag);
        items.setViewflag(viewflag);
        items.setName(name);
        items.setReadflag(readflag);
        items.setToreadflag((byte)1);
        items.setNotreadcount(notreadcount);
        items.setNotreadstartmsgid(notreadstartmsgid);
        items.setLastmsguid(lastmsguid);
        items.setLastmsgid(lastmsgid);
        items.setFromnick(fromnick);
        items.setMsgresume(msgresume);
        items.setChatuptime(new Date());
        if (Objects.equals(chatmode, (byte)1)) {
            items.setFidkey(UserService.twoUid(uid, bizid.intValue()));
        }
        items.setSysflag(sysflag);
        items.setSendtime(sendtime);
        boolean init = items.save();
        if (!init) {
            return null;
        }
        return items;
    }

    public WxChatItems chatitemsInitToItem(WxChatItems items, WxFriend friend, User user) {
        WxChatItems tochatItems = new WxChatItems();
        tochatItems.setUid(friend.getUid());
        tochatItems.setBizid(new Long(friend.getFrienduid().intValue()));
        tochatItems.setLinkid(friend.getId());
        tochatItems.setAvatar(user.getAvatar());
        tochatItems.setName(StrUtil.isNotBlank((CharSequence)friend.getRemarkname()) ? friend.getRemarkname() : user.getNick());
        tochatItems.setFidkey(items.getFidkey());
        tochatItems.setChatmode((byte)1);
        tochatItems.setLinkflag((byte)1);
        tochatItems.setViewflag((byte)1);
        tochatItems.setChatuptime(new Date());
        return tochatItems;
    }

    public boolean userBlockInit(WxUserBlackItems blackItems) {
        return this.userBlockInit(blackItems.getUid(), blackItems.getTouid());
    }

    public boolean userBlockInit(Integer uid, Integer touid) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"touid", (Object)touid);
        SqlPara sqlPara = User.dao.getSqlPara("chat.blackInit", (Map)params);
        int init = Db.use((String)"tio_site_main").update(sqlPara);
        return init > 0;
    }

    public boolean removeBlack(Integer uid, Integer touid) {
        WxUserBlackItems blackItems = ChatService.getBlockItems(uid, touid);
        if (blackItems == null) {
            return false;
        }
        return blackItems.delete();
    }

    public static boolean checkBlack(Integer operuid, Integer uid, Integer touid) {
        if (Objects.equals(operuid, uid)) {
            return true;
        }
        WxUserBlackItems items = ChatService.getBlockItems(uid, touid);
        return items == null;
    }

    public static WxUserBlackItems getBlockItems(final Integer uid, final Integer touid) {
        if (uid == null || touid == null) {
            return null;
        }
        String key = uid + "_" + touid;
        ICache cache = Caches.getCache(CacheConfig.CHAT_USER_BLOCK_1);
        WxUserBlackItems block = (WxUserBlackItems)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<WxUserBlackItems>(){

            public WxUserBlackItems create() {
                Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"touid", (Object)touid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chat.blockitems", (Map)params);
                WxUserBlackItems blockItems = (WxUserBlackItems)WxUserBlackItems.dao.findFirst(sqlPara);
                return blockItems;
            }
        }));
        return block;
    }

    public static String getNameChatIndex(String name) {
        return "ZA";
    }

    public static boolean existFriend(Integer uid, Integer touid) {
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
        return userItem != null && userItem.getLinkid() != null;
    }

    public static boolean existFriend(WxChatUserItem userItem) {
        return userItem != null && userItem.getLinkid() != null;
    }

    public static boolean existTwoFriend(WxChatUserItem userItem) {
        return userItem != null && userItem.getLinkid() != null && !Objects.equals(userItem.getLinkflag(), (byte)2);
    }

    public static boolean existTwoFriend(WxChatItems items) {
        return items != null && items.getLinkid() != null && !Objects.equals(items.getLinkflag(), (byte)2);
    }

    public static boolean friendExistChat(Integer uid, Integer touid) {
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
        return userItem != null && !Objects.equals(userItem.getActflag(), (byte)2) && userItem.getChatlinkid() != null;
    }

    public static boolean groupChatAct(WxChatGroupItem groupItem) {
        return groupItem != null && !Objects.equals(groupItem.getActflag(), (byte)2) && groupItem.getChatlinkid() != null;
    }

    public static boolean groupExistChat(WxChatGroupItem groupItem) {
        return groupItem != null;
    }

    public static boolean groupChatLink(WxChatGroupItem groupItem) {
        return groupItem != null && !Objects.equals(groupItem.getLinkflag(), (byte)2);
    }

    public static boolean friendExistChat(WxChatUserItem userItem) {
        return userItem != null && !Objects.equals(userItem.getActflag(), (byte)2) && userItem.getChatlinkid() != null;
    }
}

