/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.chat;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.CPI;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Model;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.model.main.WxChatUserItem;
import org.tio.mg.service.model.main.WxFriend;
import org.tio.mg.service.model.main.WxFriendApplyItems;
import org.tio.mg.service.model.main.WxFriendDelLog;
import org.tio.mg.service.model.main.WxFriendMsg;
import org.tio.mg.service.model.main.WxFriendOperMsg;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.ChatIndexService;
import org.tio.mg.service.service.chat.ChatMsgService;
import org.tio.mg.service.service.chat.ChatService;
import org.tio.mg.service.service.chat.FriendApplyService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.topic.Topics;
import org.tio.mg.service.utils.PyUtils;
import org.tio.mg.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.wx.FocusVo;
import org.tio.sitexxx.service.vo.wx.WxMsgCardVo;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.WriteLockHandler;

public class FriendService {
    public static final FriendService me = new FriendService();
    private static Logger log = LoggerFactory.getLogger(FriendService.class);
    static final ICache WX_FRIEND_MSG_CACHE = Caches.getCache(CacheConfig.WX_FRIEND_MSG_CHAT_2);
    public static final int WX_FRIEND_MSG_LIMIT = 30;
    static final int WX_FRIEND_MSG_RESUME_MAXSIZE = 20;

    public void clearP2pChatCache(Long chatlinkid) {
        WX_FRIEND_MSG_CACHE.remove(chatlinkid + "");
    }

    public ListWithLock<WxFriendMsg> getP2PMsgList(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        final WxChatUserItem userItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        String key = chatlinkid + "";
        ListWithLock listWithLock = (ListWithLock)CacheUtils.get((ICache)WX_FRIEND_MSG_CACHE, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ListWithLock<WxFriendMsg>>(){

            public ListWithLock<WxFriendMsg> create() {
                int historyCount = MgConfService.getInt("im.history.chat.count.p2p", 30);
                Long startMsg = userItem.getStartmsgid();
                Kv params = Kv.by((Object)"fidkey", (Object)userItem.getFidkey()).set((Object)"status", (Object)1).set((Object)"limit", (Object)historyCount);
                if (startMsg != null) {
                    params.set((Object)"startmsgid", (Object)startMsg);
                } else {
                    params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
                }
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.p2pMsgList", (Map)params);
                ArrayList list = (ArrayList)WxFriendMsg.dao.find(sqlPara);
                return new ListWithLock((List)list);
            }
        });
        return listWithLock;
    }

    public List<WxFriendMsg> getOtherP2PMsgList(Long chatlinkid, Long startMid) {
        if (chatlinkid == null) {
            return null;
        }
        if (startMid == null) {
            ListWithLock<WxFriendMsg> listWithLock = this.getP2PMsgList(chatlinkid);
            if (listWithLock != null) {
                return (List)listWithLock.getObj();
            }
            return null;
        }
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        Long startMsg = userItem.getStartmsgid();
        int historyCount = MgConfService.getInt("im.history.chat.count.p2p", 30);
        Kv params = Kv.by((Object)"fidkey", (Object)userItem.getFidkey()).set((Object)"status", (Object)1).set((Object)"limit", (Object)historyCount).set((Object)"limitmsgid", (Object)startMid);
        if (startMsg != null) {
            params.set((Object)"startmsgid", (Object)startMsg);
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.p2pMsgList", (Map)params);
        List list = WxFriendMsg.dao.find(sqlPara);
        return list;
    }

    public List<WxFriendMsg> getSynP2PMsgList(Long chatlinkid, Long endmid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        Long startMsg = userItem.getStartmsgid();
        int historyCount = MgConfService.getInt("im.history.chat.count.p2p", 30);
        Kv params = Kv.by((Object)"fidkey", (Object)userItem.getFidkey()).set((Object)"status", (Object)1).set((Object)"limit", (Object)historyCount);
        if (startMsg != null) {
            if (startMsg < endmid) {
                params.set((Object)"endmid", (Object)endmid);
            } else {
                params.set((Object)"startmsgid", (Object)startMsg);
            }
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.p2pMsgList", (Map)params);
        List list = WxFriendMsg.dao.find(sqlPara);
        return list;
    }

    public Ret checkAddFriend(User curr, Integer touid) {
        Integer uid = curr.getId();
        if (touid == null) {
            return RetUtils.invalidParam();
        }
        User toUser = UserService.ME.getById(touid);
        if (toUser == null) {
            RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!ChatService.checkBlack(curr.getId(), touid, uid)) {
            return RetUtils.failMsg("\u7533\u8bf7\u597d\u53cb\u5931\u8d25\uff0c\u5bf9\u65b9\u628a\u4f60\u52a0\u5165\u4e86\u9ed1\u540d\u5355");
        }
        WxChatUserItem oldItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
        if (ChatService.existFriend(oldItem)) {
            return RetUtils.failMsg("\u8bf7\u4e0d\u8981\u91cd\u590d\u7533\u8bf7\uff0c\u5bf9\u65b9\u5df2\u662f\u4f60\u597d\u53cb.");
        }
        WxChatUserItem toUserItem = ChatIndexService.chatUserIndex(touid, uid, (Byte)1);
        if (ChatService.existFriend(toUserItem)) {
            return RetUtils.setCode(WxFriend.AddRespCode.NO_WHERE);
        }
        if (Objects.equals(toUser.getFdvalidtype(), (byte)1)) {
            return RetUtils.setCode(WxFriend.AddRespCode.WHERE);
        }
        return RetUtils.setCode(WxFriend.AddRespCode.NO_WHERE);
    }

    public Ret addApply(User curr, Integer touid, String greet) {
        Integer uid = curr.getId();
        if (touid == null) {
            return RetUtils.invalidParam();
        }
        User toUser = UserService.ME.getById(touid);
        if (toUser == null) {
            RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!ChatService.checkBlack(curr.getId(), touid, uid)) {
            return RetUtils.failMsg("\u7533\u8bf7\u597d\u53cb\u5931\u8d25\uff0c\u5bf9\u65b9\u628a\u4f60\u52a0\u5165\u4e86\u9ed1\u540d\u5355");
        }
        WxChatUserItem oldItem = ChatIndexService.chatUserIndex(touid, uid, (Byte)1);
        if (ChatService.existFriend(oldItem)) {
            return RetUtils.failMsg("\u8bf7\u4e0d\u8981\u91cd\u590d\u7533\u8bf7\uff0c\u5bf9\u65b9\u5df2\u52a0\u4f60\u4e3a\u597d\u53cb.");
        }
        WxFriendApplyItems applyItems = new WxFriendApplyItems();
        int count = FriendApplyService.me.applyInit(uid, touid, greet, applyItems);
        if (count <= 0) {
            return RetUtils.failMsg("\u7533\u8bf7\u5931\u8d25");
        }
        return RetUtils.okData((Object)applyItems);
    }

    public Ret addFriend(User curr, Integer touid) throws Exception {
        WxChatUserItem oldItem;
        if (touid == null) {
            return RetUtils.invalidParam();
        }
        Integer uid = curr.getId();
        User toUser = UserService.ME.getById(touid);
        if (toUser == null) {
            RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (ChatService.existFriend(oldItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1))) {
            return RetUtils.failMsg("\u8bf7\u4e0d\u8981\u91cd\u590d\u7533\u8bf7\uff0c\u5bf9\u65b9\u5df2\u662f\u4f60\u597d\u53cb.");
        }
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(touid, uid, (Byte)1);
        if (ChatService.existFriend(userItem)) {
            return this.selfAddFriendExistToFriend(uid, touid, userItem);
        }
        return this.eachAddFriend(curr, toUser);
    }

    public Ret addSelfFriend(User curr) {
        final Integer uid = curr.getId();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxFriend friend = FriendService.this.friendInit(uid, uid, null, "");
                if (friend == null) {
                    return this.failRet("\u81ea\u5df1\u52a0\u81ea\u5df1\u597d\u53cb\u5931\u8d25");
                }
                WxChatUserItem oldItem = ChatIndexService.chatUserIndex(uid, uid, (Byte)1);
                if (oldItem != null) {
                    return this.failRet("\u81ea\u5df1\u7684\u7d22\u5f15\u5b58\u5728");
                }
                int count = ChatIndexService.me.chatUserInit(uid, (byte)1, new Long(uid.intValue()), null, null, friend.getId(), (byte)2, (byte)2, (byte)1, null);
                if (count <= 0) {
                    this.failRet("\u521b\u5efa\u7d22\u5f15\u51b2\u7a81");
                    return false;
                }
                return this.okRet((Object)friend);
            }
        };
        Db.use((String)"tio_site_main").tx((IAtom)atom);
        return atom.getRetObj();
    }

    public Ret fdList(User curr, String searchkey) throws Exception {
        Kv params = Kv.by((Object)"uid", (Object)curr.getId());
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"nick", (Object)("%" + searchkey + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friend.myFriends", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        return RetUtils.okData(records);
    }

    public Ret fdList(User curr, String searchkey, Integer pageNumber) throws Exception {
        if (pageNumber == null || pageNumber <= 0) {
            return this.fdList(curr, searchkey);
        }
        Kv params = Kv.by((Object)"uid", (Object)curr.getId());
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"nick", (Object)("%" + searchkey + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friend.myFriends", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), 16, sqlPara);
        return RetUtils.okData(records);
    }

    public Ret getOutGroupFdList(User curr, String searchkey, Long groupid) throws Exception {
        WxChatUserItem userItem = ChatIndexService.chatUserIndex(curr.getId(), groupid, (Byte)2);
        if (userItem == null) {
            return RetUtils.grantError();
        }
        Kv params = Kv.by((Object)"uid", (Object)curr.getId()).set((Object)"groupid", (Object)groupid).set((Object)"linkflag", (Object)1);
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"nick", (Object)("%" + searchkey + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("friend.getOutGroupFd", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        return RetUtils.okData(records);
    }

    public WxFriend getFriendInfo(Long fid) {
        ICache cache = Caches.getCache(CacheConfig.WX_MY_FRIEND);
        String cacheKey = fid + "";
        WxFriend ret = (WxFriend)((Object)CacheUtils.get((ICache)cache, (String)cacheKey, (boolean)true, () -> (WxFriend)WxFriend.dao.findById(fid)));
        return ret;
    }

    public Ret updateRemarkName(Integer uid, Integer touid, final String name) {
        final WxChatUserItem chatUserItem = ChatIndexService.fdUserIndex(uid, touid);
        if (!ChatService.existFriend(chatUserItem)) {
            return RetUtils.failMsg("\u597d\u53cb\u4e0d\u5b58\u5728");
        }
        final User user = UserService.ME.getById(chatUserItem.getBizid().intValue());
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxFriend friend = new WxFriend();
                friend.setId(chatUserItem.getLinkid());
                friend.setRemarkname(name);
                if (StrUtil.isNotBlank((CharSequence)name)) {
                    friend.setChatindex(PyUtils.getFristChat(name));
                } else {
                    friend.setChatindex(PyUtils.getFristChat(user.getNick()));
                }
                boolean fUpdate = friend.update();
                if (!fUpdate) {
                    return this.failRet("\u4fee\u6539\u5931\u8d25");
                }
                if (ChatService.friendExistChat(chatUserItem)) {
                    WxChatItems chatItems = new WxChatItems();
                    if (StrUtil.isBlank((CharSequence)name)) {
                        chatItems.setName(user.getNick());
                    } else {
                        chatItems.setName(name);
                    }
                    chatItems.setId(chatUserItem.getChatlinkid());
                    boolean chatupdate = chatItems.update();
                    if (!chatupdate) {
                        return this.failRet("\u4f1a\u8bdd\u540c\u6b65\u5931\u8d25");
                    }
                }
                return true;
            }
        };
        boolean atomCommit = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!atomCommit) {
            return atom.getRetObj();
        }
        if (chatUserItem.getChatlinkid() != null) {
            ChatIndexService.removeChatItemsCache(chatUserItem.getChatlinkid());
        }
        ChatIndexService.clearFriendInfoCache(chatUserItem.getLinkid(), chatUserItem.getUid());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("uid", touid);
        String path = "/user/info";
        Topics.notifyRemoveHttpCache(path, uid, param, 2);
        ChatIndexService.clearMailListCache(uid);
        return RetUtils.okData(chatUserItem.getLinkid());
    }

    public Ret getFdCard(Integer uid, Integer touid) throws Exception {
        WxChatUserItem userItem = ChatIndexService.fdUserIndex(uid, touid);
        if (!ChatService.existFriend(userItem)) {
            return RetUtils.failMsg("\u5bf9\u65b9\u4e0d\u662f\u4f60\u7684\u597d\u53cb");
        }
        User user = UserService.ME.getById(touid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        WxMsgCardVo wsMsgCardVo = new WxMsgCardVo();
        wsMsgCardVo.setCardtype(Byte.valueOf((byte)1));
        wsMsgCardVo.setBizavatar(user.getAvatar());
        wsMsgCardVo.setBizname(user.getNick());
        wsMsgCardVo.setBizid(new Long(user.getId().intValue()));
        wsMsgCardVo.setShareFromUid(uid);
        return RetUtils.okData(wsMsgCardVo);
    }

    public Ret isFriend(User curr, Integer touid) throws Exception {
        return ChatService.existFriend(curr.getId(), touid) ? RetUtils.okData((byte)1) : RetUtils.okData((byte)2);
    }

    public Ret dealApply(User curr, WxFriendApplyItems items, String remarkname) throws Exception {
        WxChatUserItem userItem;
        if (items == null) {
            return RetUtils.failMsg("\u7533\u8bf7\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        Integer applyid = items.getId();
        Integer uid = items.getFromuid();
        Integer touid = items.getTouid();
        if (uid == null || touid == null) {
            return RetUtils.invalidParam();
        }
        if (!Objects.equals(touid, curr.getId())) {
            return RetUtils.grantError();
        }
        User user = null;
        if (Objects.equals(curr.getId(), uid)) {
            user = curr;
        } else {
            user = UserService.ME.getById(uid);
            if (user == null) {
                RetUtils.failMsg("\u64cd\u4f5c\u7684\u7528\u6237\u4e0d\u5b58\u5728");
            }
        }
        User toUser = UserService.ME.getById(touid);
        if (toUser == null) {
            RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (ChatService.existFriend(userItem = ChatIndexService.fdUserIndex(uid, touid))) {
            return this.selfAddFriendExistToFriendByApply(touid, uid, userItem, applyid, remarkname).set((Object)"greet", (Object)items.getGreet()).set((Object)"applysigle", (Object)true);
        }
        boolean addTo = true;
        if (!ChatService.checkBlack(curr.getId(), uid, touid)) {
            log.warn("\u597d\u53cb\u7533\u8bf7\u5904\u7406\u8b66\u544a\uff1a\u7533\u8bf7\u4eba\u628a\u597d\u53cb\u52a0\u5165\u4e86\u9ed1\u540d\u5355\uff0cuid:{},touid:{},applyid:{}", new Object[]{uid, touid, applyid});
            addTo = false;
        }
        if (addTo) {
            return this.eachAddFriendByApply(user, toUser, items, remarkname).set((Object)"greet", (Object)items.getGreet()).set((Object)"applysigle", (Object)false);
        }
        return this.selfAddFriendBlockToFriend(user, toUser, items, remarkname).set((Object)"greet", (Object)items.getGreet());
    }

    public Ret selfAddFriendExistToFriend(final Integer uid, final Integer touid, final WxChatUserItem touserItem) {
        final WxFriendApplyItems items = FriendApplyService.me.getApply(touid, uid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean isupdate;
                boolean toUpdateChat;
                boolean update;
                WxFriend friend = FriendService.this.friendInit(uid, touid, null, "");
                if (friend == null) {
                    this.failRet("\u91cd\u590d\u52a0\u597d\u53cb");
                    return false;
                }
                WxChatUserItem oldItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
                if (oldItem != null) {
                    boolean updateflag;
                    WxChatUserItem update2 = new WxChatUserItem();
                    update2.setUid(uid);
                    update2.setChatmode((byte)1);
                    update2.setBizid(new Long(touid.intValue()));
                    update2.setLinkflag((byte)1);
                    update2.setLinkid(friend.getId());
                    if (touserItem.getChatlinkid() != null) {
                        update2.setTochatlinkid(touserItem.getChatlinkid());
                    }
                    if (!(updateflag = update2.update())) {
                        return false;
                    }
                } else {
                    int count = ChatIndexService.me.chatUserInit(uid, (byte)1, new Long(touid.intValue()), null, touserItem.getChatlinkid(), friend.getId(), (byte)2, (byte)2, (byte)1, null);
                    if (count <= 0) {
                        this.failRet("\u521b\u5efa\u7d22\u5f15\u51b2\u7a81");
                        return false;
                    }
                }
                if (!(update = ChatIndexService.me.chatUserIndexUpdate(touid, new Long(uid.intValue()), (byte)1, null, null, (byte)1, null, null, null))) {
                    this.failRet("\u66f4\u65b0\u7d22\u5f15\u5931\u8d25");
                    return false;
                }
                if (touserItem.getChatlinkid() != null && !(toUpdateChat = ChatService.me.updateChatLink((byte)1, touserItem.getChatlinkid()))) {
                    this.failRet("\u66f4\u65b0\u597d\u53cb\u4f1a\u8bdd\u5931\u8d25");
                    return false;
                }
                if (items != null && !Objects.equals(items.getStatus(), (byte)1) && !(isupdate = FriendApplyService.me.update(items.getId(), (byte)1))) {
                    this.failRet("\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
                    return false;
                }
                this.retObj = RetUtils.okData((Object)friend);
                return true;
            }
        };
        boolean add = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (add) {
            ChatIndexService.clearChatP2pIndex(uid, touid);
            ChatIndexService.clearChatP2pIndex(touid, uid);
            if (touserItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(touserItem.getChatlinkid());
            }
        }
        return atom.getRetObj();
    }

    public Ret selfAddFriendExistToFriendByApply(final Integer uid, final Integer touid, final WxChatUserItem touserItem, Integer applyid, final String remarkname) {
        final WxFriendApplyItems items = FriendApplyService.me.getById(applyid);
        final User user = UserService.ME.getById(touid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean isupdate;
                WxChatUserItem oldItem;
                WxFriend friend = FriendService.this.friendInit(uid, touid, null, remarkname);
                if (friend == null) {
                    this.failRet("\u91cd\u590d\u52a0\u597d\u53cb");
                    return false;
                }
                WxChatItems chatItems = new WxChatItems();
                chatItems.setUid(uid);
                chatItems.setChatmode((byte)1);
                chatItems.setBizid(new Long(touid.intValue()));
                chatItems.setAvatar(user.getAvatar());
                chatItems.setLinkflag((byte)1);
                chatItems.setViewflag((byte)1);
                chatItems.setName(StrUtil.isNotBlank((CharSequence)remarkname) ? remarkname : user.getNick());
                chatItems.setLinkid(friend.getId());
                chatItems.setChatuptime(new Date());
                chatItems.setFidkey(UserService.twoUid(uid, touid));
                boolean chatinit = chatItems.save();
                if (!chatinit) {
                    this.failRet("\u804a\u5929\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                boolean toInit = false;
                if (!ChatService.friendExistChat(touserItem)) {
                    User touser = UserService.ME.getById(touid);
                    WxFriend myfriend = me.getFriendInfo(touserItem.getLinkid());
                    WxChatItems toChatItems = ChatService.me.chatitemsInit(touserItem.getUid(), touserItem.getChatmode(), touserItem.getBizid(), touserItem.getLinkid(), touser.getAvatar(), StrUtil.isNotBlank((CharSequence)myfriend.getRemarkname()) ? myfriend.getRemarkname() : touser.getNick(), (byte)1, (byte)1, (short)0, (byte)1, null, "", "", (byte)2, null, null, null);
                    if (toChatItems == null) {
                        return this.failRet("\u521d\u59cb\u5316\u804a\u5929\u4f1a\u8bdd\u5931\u8d25");
                    }
                    touserItem.setChatlinkid(toChatItems.getId());
                    toInit = true;
                }
                if ((oldItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1)) != null) {
                    boolean updateflag;
                    WxChatUserItem update = new WxChatUserItem();
                    update.setUid(uid);
                    update.setChatmode((byte)1);
                    update.setBizid(new Long(touid.intValue()));
                    update.setLinkflag((byte)1);
                    update.setViewflag((byte)1);
                    update.setActflag((byte)1);
                    update.setLinkid(friend.getId());
                    update.setChatlinkid(chatItems.getId());
                    if (touserItem.getChatlinkid() != null) {
                        update.setTochatlinkid(touserItem.getChatlinkid());
                    }
                    if (!(updateflag = update.update())) {
                        return false;
                    }
                } else {
                    int count = ChatIndexService.me.chatUserInit(uid, (byte)1, new Long(touid.intValue()), chatItems.getId(), touserItem.getChatlinkid(), friend.getId(), (byte)1, (byte)1, (byte)1, null);
                    if (count <= 0) {
                        this.failRet("\u521b\u5efa\u7d22\u5f15\u51b2\u7a81");
                        return false;
                    }
                }
                if (toInit) {
                    boolean chatindex = ChatIndexService.me.chatUserIndexUpdate(touid, new Long(uid.intValue()), (byte)1, touserItem.getChatlinkid(), chatItems.getId(), null, (byte)1);
                    if (!chatindex) {
                        return this.failRet("\u4fee\u6539\u7d22\u5f15\u72b6\u6001\u5f02\u5e38");
                    }
                } else {
                    boolean update = ChatIndexService.me.chatUserIndexUpdate(touid, new Long(uid.intValue()), (byte)1, (byte)1, (byte)1, (byte)1, null, touserItem.getChatlinkid(), chatItems.getId());
                    if (!update) {
                        this.failRet("\u66f4\u65b0\u7d22\u5f15\u5931\u8d25");
                        return false;
                    }
                    boolean toUpdateChat = ChatService.me.updateChatLink((byte)1, touserItem.getChatlinkid());
                    if (!toUpdateChat) {
                        this.failRet("\u66f4\u65b0\u597d\u53cb\u4f1a\u8bdd\u5931\u8d25");
                        return false;
                    }
                }
                if (items != null && !Objects.equals(items.getStatus(), (byte)1) && !(isupdate = FriendApplyService.me.update(items.getId(), (byte)1))) {
                    this.failRet("\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
                    return false;
                }
                this.retObj = RetUtils.okData((Object)friend).set((Object)"send", (Object)"double").set((Object)"tochatlinkid", (Object)chatItems.getId()).set((Object)"chatlinkid", (Object)touserItem.getChatlinkid()).set((Object)"friend", (Object)friend);
                return true;
            }
        };
        boolean add = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (add) {
            ChatIndexService.clearChatP2pIndex(uid, touid);
            ChatIndexService.clearChatP2pIndex(touid, uid);
            if (touserItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(touserItem.getChatlinkid());
            }
        }
        return atom.getRetObj();
    }

    public Ret eachAddFriend(final User user, User toUser) {
        final Integer uid = user.getId();
        final Integer touid = toUser.getId();
        final WxFriendApplyItems items = FriendApplyService.me.getApply(touid, uid);
        final WxFriendApplyItems toitems = FriendApplyService.me.getApply(uid, touid);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean isupdate;
                int apply = FriendApplyService.me.applyInit(uid, touid, "\u9ed8\u8ba4\u52a0\u4e3a\u597d\u53cb", (byte)1, (byte)1);
                if (apply <= 0) {
                    this.failRet("\u81ea\u52a8\u7533\u8bf7\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                WxFriend friend = FriendService.this.friendInit(uid, touid, null, "");
                if (friend == null) {
                    this.failRet("\u597d\u53cb\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                WxFriend tofriend = FriendService.this.friendInit(touid, uid, null, user.getNick());
                if (tofriend == null) {
                    this.failRet("to\u597d\u53cb\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                int indexinit = ChatIndexService.me.chatUserInit(friend.getId(), uid, (byte)1, new Long(touid.intValue()));
                if (indexinit <= 0) {
                    this.failRet("\u597d\u53cb\u7d22\u5f15\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                int toindexinit = ChatIndexService.me.chatUserInit(tofriend.getId(), touid, (byte)1, new Long(uid.intValue()));
                if (toindexinit <= 0) {
                    this.failRet("to\u597d\u53cb\u7d22\u5f15\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                if (items != null && !Objects.equals(items.getStatus(), (byte)1) && !(isupdate = FriendApplyService.me.update(items.getId(), (byte)1))) {
                    this.failRet("\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
                    return false;
                }
                if (toitems != null && !Objects.equals(toitems.getStatus(), (byte)1) && !(isupdate = FriendApplyService.me.update(toitems.getId(), (byte)1))) {
                    this.failRet("to\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
                    return false;
                }
                this.retObj = RetUtils.okData((Object)friend).set((Object)"friend", (Object)friend).set((Object)"tofriend", (Object)tofriend);
                return true;
            }
        };
        Db.use((String)"tio_site_main").tx((IAtom)atom);
        return atom.getRetObj();
    }

    public Ret eachAddFriendByApply(final User user, User toUser, WxFriendApplyItems items, final String remarkName) {
        final Integer uid = user.getId();
        final Integer touid = toUser.getId();
        final Integer applyid = items.getId();
        if (!Objects.equals((byte)2, items.getStatus())) {
            return RetUtils.failMsg("\u5ba1\u6838\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        final WxFriendApplyItems toItems = FriendApplyService.me.getApply(touid, uid);
        final WxChatItems chatItems = new WxChatItems();
        chatItems.setUid(uid);
        chatItems.setChatmode((byte)1);
        chatItems.setBizid(new Long(touid.intValue()));
        chatItems.setAvatar(toUser.getAvatar());
        chatItems.setLinkflag((byte)1);
        chatItems.setViewflag((byte)1);
        chatItems.setName(toUser.getNick());
        chatItems.setFidkey(UserService.twoUid(uid, touid));
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean isupdate;
                boolean apply = FriendApplyService.me.update(applyid, (byte)1);
                if (!apply) {
                    this.failRet("\u7533\u8bf7\u8bb0\u5f55\u4fee\u6539\u5931\u8d25");
                    return false;
                }
                WxFriend friend = FriendService.this.friendInit(uid, touid, null, "");
                if (friend == null) {
                    this.failRet("\u597d\u53cb\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                WxFriend tofriend = FriendService.this.friendInit(touid, uid, null, remarkName);
                if (tofriend == null) {
                    this.failRet("to\u597d\u53cb\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                chatItems.setLinkid(friend.getId());
                chatItems.setChatuptime(new Date());
                boolean chatinit = chatItems.save();
                if (!chatinit) {
                    this.failRet("\u804a\u5929\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                WxChatItems tochatItems = ChatService.me.chatitemsInitToItem(chatItems, tofriend, user);
                boolean toChatinit = tochatItems.save();
                if (!toChatinit) {
                    this.failRet("to\u804a\u5929\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                int indexinit = ChatIndexService.me.chatUserInit(friend.getId(), uid, (byte)1, new Long(touid.intValue()), chatItems.getId(), tochatItems.getId());
                if (indexinit <= 0) {
                    this.failRet("\u597d\u53cb\u7d22\u5f15\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                int toindexinit = ChatIndexService.me.chatUserInit(tofriend.getId(), touid, (byte)1, new Long(uid.intValue()), tochatItems.getId(), chatItems.getId());
                if (toindexinit <= 0) {
                    this.failRet("to\u597d\u53cb\u7d22\u5f15\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                if (toItems != null && !Objects.equals(toItems.getStatus(), (byte)1) && !(isupdate = FriendApplyService.me.update(toItems.getId(), (byte)1))) {
                    this.failRet("to\u66f4\u65b0\u7533\u8bf7\u8bb0\u5f55\u5931\u8d25");
                    return false;
                }
                this.retObj = RetUtils.okData((Object)tofriend).set((Object)"send", (Object)"double").set((Object)"chatlinkid", (Object)chatItems.getId()).set((Object)"tochatlinkid", (Object)tochatItems.getId()).set((Object)"friend", (Object)friend).set((Object)"tofriend", (Object)tofriend);
                return true;
            }
        };
        Db.use((String)"tio_site_main").tx((IAtom)atom);
        return atom.getRetObj();
    }

    public Ret selfAddFriendBlockToFriend(final User user, User toUser, WxFriendApplyItems items, final String remarkName) {
        final Integer uid = user.getId();
        final Integer touid = toUser.getId();
        final Integer applyid = items.getId();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean apply = FriendApplyService.me.update(applyid, (byte)1);
                if (!apply) {
                    this.failRet("\u7533\u8bf7\u8bb0\u5f55\u4fee\u6539\u5931\u8d25");
                    return false;
                }
                WxFriend friend = FriendService.this.friendInit(touid, uid, null, remarkName);
                if (friend == null) {
                    this.failRet("\u91cd\u590d\u52a0\u597d\u53cb");
                    return false;
                }
                WxChatItems chatItems = new WxChatItems();
                chatItems.setUid(touid);
                chatItems.setChatmode((byte)1);
                chatItems.setBizid(new Long(uid.intValue()));
                chatItems.setAvatar(user.getAvatar());
                chatItems.setLinkflag((byte)2);
                chatItems.setViewflag((byte)1);
                chatItems.setName(StrUtil.isNotBlank((CharSequence)remarkName) ? remarkName : user.getNick());
                chatItems.setLinkid(friend.getId());
                chatItems.setChatuptime(new Date());
                chatItems.setFidkey(UserService.twoUid(uid, touid));
                boolean chatinit = chatItems.save();
                if (!chatinit) {
                    this.failRet("\u804a\u5929\u8bb0\u5f55\u4fdd\u5b58\u5931\u8d25");
                    return false;
                }
                int count = ChatIndexService.me.chatUserInit(touid, (byte)1, new Long(uid.intValue()), chatItems.getId(), null, friend.getId(), (byte)1, (byte)1, (byte)2, null);
                if (count <= 0) {
                    this.failRet("\u521b\u5efa\u7d22\u5f15\u51b2\u7a81");
                    return false;
                }
                this.retObj = RetUtils.okData((Object)friend).set((Object)"send", (Object)"one").set((Object)"tochatlinkid", (Object)chatItems.getId()).set((Object)"friend", (Object)friend);
                return true;
            }
        };
        Db.use((String)"tio_site_main").tx((IAtom)atom);
        return atom.getRetObj();
    }

    public boolean delFriend(Long fid) {
        return WxFriend.dao.deleteById(fid);
    }

    public Ret delFriend(User curr, final Integer touid, final Integer ipid) throws Exception {
        if (touid == null) {
            return RetUtils.invalidParam();
        }
        final Integer uid = curr.getId();
        final WxChatUserItem userItem = ChatIndexService.chatUserIndex(uid, touid, (Byte)1);
        if (!ChatService.existFriend(userItem)) {
            return RetUtils.failMsg("\u597d\u53cb\u4e0d\u5b58\u5728");
        }
        final WxChatUserItem toUserItem = ChatIndexService.chatUserIndex(touid, uid, (Byte)1);
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean remove;
                boolean del = FriendService.this.delFriend(userItem.getLinkid());
                if (!del) {
                    this.failRet("\u5220\u9664\u597d\u53cb\u5931\u8d25");
                    return false;
                }
                FriendApplyService.me.removeApply(touid, uid);
                if (ChatService.friendExistChat(uid, touid) && !(remove = ChatService.me.deleteChatItem(userItem.getChatlinkid()))) {
                    this.failRet("\u6e05\u9664\u804a\u5929\u5217\u8868\u5931\u8d25");
                    return false;
                }
                if (ChatService.existFriend(toUserItem)) {
                    boolean toUpdateChat;
                    boolean updateIndex = ChatIndexService.me.chatUserIndexUpdate(uid, userItem.getBizid(), userItem.getChatmode(), (byte)4);
                    if (!updateIndex) {
                        this.failRet("\u4fee\u6539\u597d\u53cb\u7d22\u5f15\u5931\u8d25");
                        return false;
                    }
                    boolean toUpdateIndex = ChatIndexService.me.chatUserIndexUpdate(touid, toUserItem.getBizid(), toUserItem.getChatmode(), (byte)5);
                    if (!toUpdateIndex) {
                        this.failRet("\u4fee\u6539\u5bf9\u65b9\u597d\u53cb\u7d22\u5f15\u5931\u8d25");
                        return false;
                    }
                    if (toUserItem.getChatlinkid() != null && !(toUpdateChat = ChatService.me.updateChatLink((byte)2, toUserItem.getChatlinkid()))) {
                        this.failRet("\u4fee\u6539\u5bf9\u65b9\u597d\u53cb\u4f1a\u8bdd\u5931\u8d25");
                        return false;
                    }
                } else {
                    boolean toDelIndex;
                    boolean delIndex = ChatIndexService.me.chatUserIndexDel(uid, userItem.getBizid(), userItem.getChatmode());
                    if (!delIndex) {
                        this.failRet("\u5220\u9664\u597d\u53cb\u7d22\u5f15\u5931\u8d25");
                        return false;
                    }
                    if (toUserItem != null && !(toDelIndex = ChatIndexService.me.chatUserIndexDel(touid, toUserItem.getBizid(), toUserItem.getChatmode()))) {
                        this.failRet("\u5220\u9664\u5bf9\u65b9\u597d\u53cb\u7d22\u5f15\u5931\u8d25");
                        return false;
                    }
                }
                FriendService.this.saveDelFriendOper(uid, touid, ipid);
                return true;
            }
        };
        boolean delFlag = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (delFlag) {
            Ret ret = RetUtils.okOper();
            ChatIndexService.clearChatP2pIndex(uid, touid);
            ChatIndexService.clearChatP2pIndex(touid, uid);
            if (userItem.getChatlinkid() != null) {
                ret.set((Object)"chatlinkid", (Object)userItem.getChatlinkid());
                ChatIndexService.removeChatItemsCache(userItem.getChatlinkid());
                this.clearP2pChatCache(userItem.getChatlinkid());
            }
            if (ChatService.friendExistChat(toUserItem)) {
                ret.set((Object)"tochatlinkid", (Object)toUserItem.getChatlinkid());
                ChatIndexService.removeChatItemsCache(toUserItem.getChatlinkid());
            }
            ChatIndexService.clearMailListCache(uid);
            return ret.set((Object)"fid", (Object)userItem.getLinkid());
        }
        return atom.getRetObj();
    }

    public WxFriend friendInit(Integer uid, Integer touid, Long msgid, String remark) {
        WxFriend friend = new WxFriend();
        friend.setUid(uid);
        friend.setRemarkname(remark);
        friend.setStartmsgid(msgid);
        friend.setFrienduid(touid);
        if (StrUtil.isBlank((CharSequence)remark)) {
            User user = UserService.ME.getById(touid);
            friend.setChatindex(PyUtils.getFristChat(user.getNick()));
        } else {
            friend.setChatindex(PyUtils.getFristChat(remark));
        }
        int count = friend.ignoreSave();
        if (count < 1) {
            return null;
        }
        ChatIndexService.clearMailListCache(uid);
        return friend;
    }

    public void resetFdChatIndex() {
        List records = Db.use((String)"tio_site_main").find("select id,uid,frienduid from wx_friend");
        if (CollectionUtil.isNotEmpty((Collection)records)) {
            for (Record record : records) {
                Long id = record.getLong("id");
                WxFriend friend = new WxFriend();
                friend.setId(id);
                String remarkname = record.getStr("remarkname");
                if (StrUtil.isBlank((CharSequence)remarkname)) {
                    Integer touid = record.getInt("frienduid");
                    User user = UserService.ME.getById(touid);
                    friend.setChatindex(PyUtils.getFristChat(user.getNick()));
                } else {
                    friend.setChatindex(PyUtils.getFristChat(remarkname));
                }
                try {
                    friend.update();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void saveDelFriendOper(Integer uid, Integer touid, Integer ipid) {
        WxFriendDelLog wxFriendDelLog = new WxFriendDelLog();
        wxFriendDelLog.setIpid(ipid);
        wxFriendDelLog.setFrienduid(uid);
        wxFriendDelLog.setUid(touid);
        wxFriendDelLog.save();
    }

    public Ret delMsg(final WxChatUserItem chatUserItem, final String mids) {
        final Integer uid = chatUserItem.getUid();
        ChatIndexService.removeChatItemsCache(chatUserItem.getChatlinkid());
        final WxChatItems chatItems = ChatService.me.getChatItems(chatUserItem.getChatlinkid());
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                String[] midArr = mids.split(",");
                boolean lastFlag = false;
                for (String midStr : midArr) {
                    Long mid = Long.parseLong(midStr);
                    WxFriendMsg delmsg = (WxFriendMsg)WxFriendMsg.dao.findById(mid);
                    if (delmsg == null) continue;
                    if (Objects.equals(delmsg.getSigleflag(), (byte)1) || Objects.equals(delmsg.getUid(), delmsg.getTouid())) {
                        boolean del = delmsg.delete();
                        if (!del) {
                            return this.failRet(RetUtils.sysError());
                        }
                    } else {
                        WxFriendMsg updateMsg = new WxFriendMsg();
                        updateMsg.setId(delmsg.getId());
                        updateMsg.setSigleflag((byte)1);
                        updateMsg.setSigleuid(chatUserItem.getBizid().intValue());
                        boolean update = updateMsg.update();
                        if (!update) {
                            return this.failRet(RetUtils.sysError());
                        }
                    }
                    if (!Objects.equals(chatItems.getLastmsgid(), delmsg.getId())) continue;
                    lastFlag = true;
                }
                Byte clear = 2;
                Byte chat = 2;
                if (lastFlag) {
                    WxFriendMsg lastmsg = ChatMsgService.me.getLastMsg(chatUserItem.getFidkey(), chatUserItem.getBizid().intValue());
                    if (lastmsg == null) {
                        boolean startTx = ChatIndexService.me.chatuserStartMsg(chatItems.getUid(), chatItems.getBizid(), chatItems.getChatmode(), null);
                        if (!startTx) {
                            return this.failRet("\u4fee\u6539\u8d77\u59cb\u6d88\u606f\u5f02\u5e38");
                        }
                        boolean clearMsg = ChatService.me.clearChatItemMsg(chatUserItem.getChatlinkid());
                        if (!clearMsg) {
                            return this.failRet("\u6e05\u7a7a\u6d88\u606f\u5f02\u5e38");
                        }
                        clear = 1;
                    } else {
                        Ret itemRet;
                        Byte toread = null;
                        if (Objects.equals(lastmsg.getUid(), uid)) {
                            toread = lastmsg.getReadflag();
                        }
                        if ((itemRet = ChatMsgService.me.afterSendFriendChatMsg(lastmsg, null, chatUserItem.getChatlinkid(), null, toread, null)).isFail()) {
                            return this.failRet(itemRet);
                        }
                        chat = 1;
                    }
                }
                return this.okRet(Ret.ok().set((Object)"clear", (Object)clear).set((Object)"chat", (Object)chat));
            }
        };
        boolean del = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!del) {
            return atom.getRetObj();
        }
        Byte clear = (Byte)RetUtils.getOkTData(atom.getRetObj(), "clear");
        Byte chat = (Byte)RetUtils.getOkTData(atom.getRetObj(), "chat");
        Byte send = 2;
        if (Objects.equals(clear, (byte)1)) {
            ChatIndexService.clearChatUserIndex(chatItems.getUid(), chatItems.getBizid(), chatItems.getChatmode());
            ChatIndexService.removeChatItemsCache(chatUserItem.getChatlinkid());
            send = 1;
        } else if (Objects.equals(chat, (byte)1)) {
            ChatIndexService.removeChatItemsCache(chatUserItem.getChatlinkid());
            send = 1;
        }
        me.clearP2pChatCache(chatUserItem.getChatlinkid());
        return Ret.ok().set((Object)"chatindex", (Object)chatUserItem).set((Object)"msg", null).set((Object)"send", (Object)send);
    }

    public Ret backMsg(WxChatUserItem chatUserItem, String midStr) {
        Long mid = Long.parseLong(midStr);
        WxFriendMsg msg = (WxFriendMsg)WxFriendMsg.dao.findById(mid);
        if (msg == null) {
            return RetUtils.failMsg("\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        long offset = DateUtil.betweenMs((Date)msg.getTime(), (Date)new Date());
        if (offset > ChatMsgService.MSG_BACK_MAX_TIME) {
            return RetUtils.failMsg("\u8d85\u8fc72\u5206\u949f,\u65e0\u6cd5\u64a4\u56de");
        }
        boolean del = msg.delete();
        if (!del) {
            return RetUtils.sysError();
        }
        return Ret.ok().set((Object)"chatindex", (Object)chatUserItem).set((Object)"msg", (Object)msg);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, String text, Integer uid, Integer touid, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, text, uid, touid, (Byte)1, isread);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, String text, Integer uid, Integer touid, Byte contenttype, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, (byte)2, text, uid, touid, contenttype, (byte)2, null, isread);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, String text, Integer uid, Integer touid, Byte contenttype, Long frommsgid, Byte fromchatmode, Byte sysflag, String operBizData, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, (byte)2, text, uid, touid, contenttype, sysflag, null, (byte)1, null, isread, operBizData, frommsgid, fromchatmode);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, Byte reverseflag, String text, Integer uid, Integer touid, Byte contenttype, Byte sendbysys, Integer sigleuid, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, reverseflag, text, uid, touid, contenttype, sendbysys, sigleuid, (byte)1, null, isread, "", null, null);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, Integer uid, String text, Integer touid, Byte oper, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, (byte)2, text, uid, touid, (byte)1, (byte)1, uid, (byte)1, oper, isread, "", null, null);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, String text, Integer uid, Byte oper, String operbizdata, FocusVo isread) {
        Byte msgtype = 1;
        if (oper != null) {
            msgtype = 2;
        }
        return this.addChatMsg(devicetype, sessionid, ip, (byte)2, text, uid, uid, (byte)1, (byte)1, uid, msgtype, oper, isread, operbizdata, null, null);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, Byte reverseflag, String text, Integer uid, Integer touid, Integer sigleuid, FocusVo isread) {
        return this.addChatMsg(devicetype, sessionid, ip, reverseflag, text, uid, touid, (byte)1, (byte)2, sigleuid, (byte)1, null, isread, "", null, null);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, Byte reverseflag, String text, Integer uid, Integer touid, Byte oper, Integer sigleuid, FocusVo isread) {
        Byte msgtype = 1;
        if (oper != null) {
            msgtype = 2;
        }
        return this.addChatMsg(devicetype, sessionid, ip, reverseflag, text, uid, touid, (byte)1, (byte)1, sigleuid, msgtype, oper, isread, "", null, null);
    }

    public WxFriendMsg addChatMsg(Byte devicetype, String sessionid, String ip, Byte reverseflag, String text, Integer uid, Integer touid, Byte contenttype, Byte sendbysys, Integer sigleuid, Byte msgtype, Byte oper, FocusVo focusVo, String operBizData, Long frommsgid, Byte fromchatmode) {
        IpInfo ipInfo = IpInfoService.ME.save(ip);
        WxFriendMsg wxFriendMsg = new WxFriendMsg();
        wxFriendMsg.setText(text);
        wxFriendMsg.setFrommode(fromchatmode);
        String resume = "";
        switch (contenttype) {
            case 1: {
                resume = StrUtil.trim((CharSequence)HtmlUtil.cleanHtmlTag((String)text));
                resume = StrUtil.subWithLength((String)resume, (int)0, (int)20);
                break;
            }
            case 4: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u97f3\u9891";
                break;
            }
            case 2: {
                resume = "\u53d1\u4e00\u6761\u535a\u5ba2";
                break;
            }
            case 3: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u6587\u4ef6";
                break;
            }
            case 6: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u56fe\u7247";
                break;
            }
            case 5: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u89c6\u9891";
                break;
            }
            case 9: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u540d\u7247";
                break;
            }
        }
        wxFriendMsg.setResume(resume);
        wxFriendMsg.setOperbizdata(operBizData);
        wxFriendMsg.setIpid(ipInfo.getId());
        wxFriendMsg.setDevice(devicetype);
        wxFriendMsg.setTime(new Date());
        wxFriendMsg.setTouid(touid);
        wxFriendMsg.setUid(uid);
        if (Objects.equals(reverseflag, (byte)1)) {
            wxFriendMsg.setTosession(sessionid);
        } else {
            wxFriendMsg.setSession(sessionid);
        }
        wxFriendMsg.setContenttype(contenttype);
        wxFriendMsg.setStatus((byte)1);
        if (sendbysys != null) {
            wxFriendMsg.setSendbysys(sendbysys);
        }
        if (sigleuid != null) {
            wxFriendMsg.setSigleflag((byte)1);
            wxFriendMsg.setSigleuid(sigleuid);
        } else {
            wxFriendMsg.setSigleuid(Const.MSG_DEFAULT_UID);
        }
        wxFriendMsg.setMsgtype(msgtype);
        wxFriendMsg.setOper(oper);
        wxFriendMsg.setFrommsgid(frommsgid);
        if (focusVo != null) {
            wxFriendMsg.setReaddevice(focusVo.getDevicetype());
            wxFriendMsg.setReadflag((byte)1);
            wxFriendMsg.setReadipid(focusVo.getIpid());
            wxFriendMsg.setReadtime(new Date());
        } else {
            wxFriendMsg.setReadflag((byte)2);
        }
        if (oper != null) {
            WxFriendOperMsg operMsg = new WxFriendOperMsg();
            BeanUtil.copyProperties((Object)CPI.getAttrs((Model)wxFriendMsg), (Object)CPI.getAttrs((Model)operMsg), (String[])new String[0]);
            operMsg.setTwouid(UserService.twoUid(wxFriendMsg.getUid(), wxFriendMsg.getTouid()));
            boolean add = operMsg.save();
            if (!add) {
                return null;
            }
            wxFriendMsg.setId(operMsg.getId());
        } else {
            boolean add = this.msgAdd(wxFriendMsg);
            if (!add) {
                return null;
            }
        }
        return wxFriendMsg;
    }

    public boolean msgAdd(WxFriendMsg wxFriendMsg) {
        wxFriendMsg.setTwouid(UserService.twoUid(wxFriendMsg.getUid(), wxFriendMsg.getTouid()));
        boolean save = wxFriendMsg.save();
        return save;
    }

    public void putToP2pCache(final WxFriendMsg chatRecord, Long chatlinkid, Long tochatlinkid) {
        String key;
        String tokey;
        ListWithLock listWithLock;
        if (7 == chatRecord.getContenttype()) {
            return;
        }
        final int historyCount = MgConfService.getInt("im.history.chat.count.p2p", 30);
        if (tochatlinkid != null && (listWithLock = (ListWithLock)WX_FRIEND_MSG_CACHE.get(tokey = tochatlinkid + "", ListWithLock.class)) != null) {
            listWithLock.handle((WriteLockHandler)new WriteLockHandler<List<WxFriendMsg>>(){

                public void handler(List<WxFriendMsg> list) {
                    list.add(0, chatRecord);
                    while (list.size() > historyCount) {
                        list.remove(historyCount);
                    }
                }
            });
        }
        if (chatlinkid != null && (listWithLock = (ListWithLock)WX_FRIEND_MSG_CACHE.get(key = chatlinkid + "", ListWithLock.class)) != null) {
            listWithLock.handle((WriteLockHandler)new WriteLockHandler<List<WxFriendMsg>>(){

                public void handler(List<WxFriendMsg> list) {
                    list.add(0, chatRecord);
                    while (list.size() > historyCount) {
                        list.remove(historyCount);
                    }
                }
            });
        }
    }
}

