/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.chat;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.main.IpInfo;
import org.tio.mg.service.model.main.User;
import org.tio.mg.service.model.main.WxChatGroupItem;
import org.tio.mg.service.model.main.WxChatItems;
import org.tio.mg.service.model.main.WxFriendMsg;
import org.tio.mg.service.model.main.WxGroup;
import org.tio.mg.service.model.main.WxGroupMeta;
import org.tio.mg.service.model.main.WxGroupMsg;
import org.tio.mg.service.model.main.WxGroupUser;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.base.IpInfoService;
import org.tio.mg.service.service.base.UserService;
import org.tio.mg.service.service.chat.ChatIndexService;
import org.tio.mg.service.service.chat.ChatMsgService;
import org.tio.mg.service.service.chat.ChatService;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.utils.CommonUtils;
import org.tio.mg.service.utils.RetUtils;
import org.tio.sitexxx.service.vo.Const;
import org.tio.sitexxx.service.vo.wx.SysMsgVo;
import org.tio.sitexxx.service.vo.wx.WxMsgCardVo;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;
import org.tio.utils.json.Json;
import org.tio.utils.lock.ListWithLock;
import org.tio.utils.lock.WriteLockHandler;
import org.tio.utils.resp.Resp;

public class GroupService {
    private static Logger log = LoggerFactory.getLogger(GroupService.class);
    public static final GroupService me = new GroupService();
    static final ICache GROUP_MSG_CACHE = Caches.getCache(CacheConfig.WX_GROUP_CHAT_3);
    public static final int GROUP_MSG_LIMIT = 30;
    static final int GROUP_MSG_RESUME_MAXSIZE = 20;
    static final int GROUP_USER_VIEW_DEFAULT = 11;

    public WxGroup getByGroupid(final Long groupid) {
        String key = groupid + "";
        ICache cache = Caches.getCache(CacheConfig.WX_GROUP_1);
        WxGroup group = (WxGroup)((Object)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<WxGroup>(){

            public WxGroup create() {
                return (WxGroup)WxGroup.dao.findFirst("select g.*,m.joinnum from wx_group g INNER JOIN wx_group_meta m on m.groupid = g.id where g.id = ?", new Object[]{groupid});
            }
        }));
        return group;
    }

    public Ret modifyAvatar(final Long groupid, final String avatar) {
        final WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxGroup group = new WxGroup();
                group.setId(wxGroup.getId());
                group.setAvatar(avatar);
                boolean update = group.update();
                if (!update) {
                    return this.failRet("\u4fee\u6539\u5931\u8d25");
                }
                ChatService.me.updateChatItemInfo(groupid, "", avatar);
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!commit) {
            return atom.getRetObj();
        }
        ChatIndexService.removeGroupCache(groupid);
        return RetUtils.okOper();
    }

    public Ret modifyGroupNick(Long groupid, String nick, Integer uid) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        WxChatGroupItem chatGroupItem = ChatIndexService.chatGroupIndex(uid, groupid);
        if (!ChatService.groupChatLink(chatGroupItem)) {
            return RetUtils.failMsg("\u4e0d\u662f\u7fa4\u6210\u5458");
        }
        WxGroupUser update = new WxGroupUser();
        update.setId(chatGroupItem.getGpulinkid());
        if (StrUtil.isBlank((CharSequence)nick)) {
            User user = UserService.ME.getById(uid);
            update.setGroupnick(user.getNick());
            update.setAutoflag((byte)1);
        } else {
            update.setAutoflag((byte)2);
            update.setGroupnick(nick);
        }
        boolean up = update.update();
        if (!up) {
            return RetUtils.failOper();
        }
        ChatIndexService.clearGroupUserCache(groupid);
        UserService.ME.initSynInfo(uid, (byte)3, nick, groupid);
        return RetUtils.okOper();
    }

    public Ret modifyName(Integer uid, Long groupid, String name) {
        return this.modifyName(uid, groupid, name, false);
    }

    public Ret modifyName(Integer uid, final Long groupid, final String name, final boolean auto) {
        if (!auto) {
            WxGroup wxGroup = this.getByGroupid(groupid);
            if (wxGroup == null) {
                return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
            }
            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(uid, groupid);
            if (!ChatService.groupChatLink(groupItem)) {
                return RetUtils.failMsg("\u4e0d\u662f\u7fa4\u7528\u6237");
            }
            if (!Objects.equals(groupItem.getGrouprole(), (byte)1)) {
                return RetUtils.failMsg("\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u540d\u5b57");
            }
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxGroup group = new WxGroup();
                group.setId(groupid);
                if (!auto) {
                    group.setAutoflag((byte)2);
                }
                group.setName(name);
                boolean update = group.update();
                if (!update) {
                    return this.failRet("\u4fee\u6539\u5931\u8d25");
                }
                ChatService.me.updateChatItemInfo(groupid, name, "");
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!commit) {
            return atom.getRetObj();
        }
        ChatIndexService.removeGroupCache(groupid);
        return RetUtils.okOper();
    }

    public Ret backMsg(WxChatGroupItem groupItem, String midStr) {
        Long mid = Long.parseLong(midStr);
        WxGroupMsg msg = (WxGroupMsg)WxGroupMsg.dao.findById(mid);
        if (msg == null) {
            return RetUtils.failMsg("\u6d88\u606f\u4e0d\u5b58\u5728");
        }
        long offset = DateUtil.betweenMs((Date)msg.getTime(), (Date)new Date());
        if (offset > ChatMsgService.MSG_BACK_MAX_TIME) {
            return RetUtils.failMsg("\u8d85\u8fc72\u5206\u949f,\u65e0\u6cd5\u64a4\u56de");
        }
        boolean del = msg.delete();
        if (!del) {
            return RetUtils.sysError();
        }
        return Ret.ok().set((Object)"chatindex", (Object)groupItem).set((Object)"msg", (Object)msg);
    }

    public Ret delMsg(final WxChatGroupItem groupItem, final String mids) {
        if (StrUtil.isBlank((CharSequence)mids)) {
            return RetUtils.failMsg("\u6d88\u606fid\u4e3a\u7a7a");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                Ret ret = ChatMsgService.me.groupMsgDel(mids, groupItem.getUid(), groupItem.getGroupid());
                if (ret.isFail()) {
                    return this.failRet(ret);
                }
                Byte clear = 2;
                Byte chat = 2;
                if (groupItem.getChatlinkid() != null) {
                    ChatIndexService.removeChatItemsCache(groupItem.getChatlinkid());
                    WxChatItems chatItems = ChatService.me.getChatItems(groupItem.getChatlinkid());
                    if (chatItems != null && chatItems.getLastmsgid() != null && ("," + mids + ",").indexOf("," + chatItems.getLastmsgid() + ",") >= 0) {
                        WxGroupMsg msg = GroupService.this.getGroupFristMsg(chatItems);
                        if (msg == null) {
                            boolean startTx = ChatIndexService.me.chatGroupStartMsg(chatItems.getUid(), chatItems.getBizid(), null);
                            if (!startTx) {
                                return this.failRet("\u4fee\u6539\u8d77\u59cb\u6d88\u606f\u5f02\u5e38");
                            }
                            boolean clearMsg = ChatService.me.clearChatItemMsg(groupItem.getChatlinkid());
                            if (!clearMsg) {
                                return this.failRet("\u6e05\u7a7a\u6d88\u606f\u5f02\u5e38");
                            }
                            clear = 1;
                        } else {
                            Ret itemRet = ChatMsgService.me.afterSendGroupById(msg, null, chatItems.getId());
                            if (itemRet.isFail()) {
                                return this.failRet(itemRet);
                            }
                            chat = 1;
                        }
                    }
                }
                return this.okRet(Ret.ok().set((Object)"clear", (Object)clear).set((Object)"chat", (Object)chat));
            }
        };
        boolean del = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!del) {
            return atom.getRetObj();
        }
        Byte clear = (Byte)RetUtils.getOkTData(atom.getRetObj(), "clear");
        Byte chat = (Byte)RetUtils.getOkTData(atom.getRetObj(), "chat");
        if (Objects.equals(clear, (byte)1)) {
            ChatIndexService.clearChatUserIndex(groupItem.getUid(), groupItem.getGroupid(), (byte)2);
            ChatIndexService.removeChatItemsCache(groupItem.getChatlinkid());
        } else if (Objects.equals(chat, (byte)1)) {
            ChatIndexService.removeChatItemsCache(groupItem.getChatlinkid());
        }
        ChatIndexService.clearGroupMsgCache(groupItem.getGroupid());
        return atom.getRetObj();
    }

    public Ret groupInfo(Long groupid, Integer uid) {
        WxChatGroupItem groupItem;
        Ret ret = Ret.ok();
        WxGroup group = this.getByGroupid(groupid);
        if (uid != null && ChatService.groupChatLink(groupItem = ChatIndexService.chatGroupIndex(uid, groupid))) {
            WxGroupUser groupUser = this.getGroupUser(groupItem);
            ret.set((Object)"groupuser", (Object)groupUser);
        }
        return ret.set((Object)"group", (Object)group);
    }

    public Ret groupList(Integer uid, String searchkey) {
        Kv params = Kv.by((Object)"uid", (Object)uid).set((Object)"chatmode", (Object)2).set((Object)"linkflag", (Object)1);
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"nick", (Object)("%" + searchkey + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.grouplist", (Map)params);
        List records = Db.use((String)"tio_site_main").find(sqlPara);
        return RetUtils.okData(records);
    }

    public WxGroupUser getGroupUser(Integer uid, Long groupid) {
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(uid, groupid);
        return this.getGroupUser(groupItem);
    }

    public WxGroupUser getGroupUser(WxChatGroupItem groupItem) {
        if (groupItem == null || groupItem.getGpulinkid() == null) {
            return null;
        }
        return this.getGroupUser(groupItem.getGpulinkid());
    }

    public WxGroupUser getGroupUser(Long linkid) {
        return (WxGroupUser)WxGroupUser.dao.findById(linkid);
    }

    public Ret groupUserList(final Long groupid, final Byte allFlag) {
        String key = groupid + "";
        if (allFlag == null || Objects.equals(allFlag, (byte)2)) {
            key = key + "_11";
        }
        ICache cache = Caches.getCache(CacheConfig.CHAT_GROUP_USER_LIST_2);
        ArrayList records = (ArrayList)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ArrayList<Record>>(){

            public ArrayList<Record> create() {
                Kv params = Kv.by((Object)"groupid", (Object)groupid);
                if (allFlag == null || Objects.equals(allFlag, (byte)2)) {
                    params.set((Object)"limitnum", (Object)11);
                }
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.groupUserlist", (Map)params);
                ArrayList records = (ArrayList)Db.use((String)"tio_site_main").find(sqlPara);
                return records;
            }
        });
        return RetUtils.okList(records);
    }

    public Ret groupUserList(final Long groupid, Integer pageNumber, String searchkey) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            Kv params = Kv.by((Object)"groupid", (Object)groupid).set((Object)"searchkey", (Object)("%" + searchkey + "%")).set((Object)"yes", (Object)1).set((Object)"no", (Object)2);
            SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.groupUserlist", (Map)params);
            Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), 100, sqlPara);
            return RetUtils.okList(records);
        }
        final Integer page = pageNumber;
        String key = groupid + "_" + pageNumber;
        ICache cache = Caches.getCache(CacheConfig.CHAT_GROUP_USER_LIST_2);
        Page records = (Page)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<Page<Record>>(){

            public Page<Record> create() {
                Kv params = Kv.by((Object)"groupid", (Object)groupid);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.groupUserlist", (Map)params);
                Page records = Db.use((String)"tio_site_main").paginate(page.intValue(), 100, sqlPara);
                return records;
            }
        });
        return RetUtils.okList(records);
    }

    public Ret atGroupUserList(Long groupid, String searchkey) {
        Kv params = Kv.by((Object)"groupid", (Object)groupid);
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%")).set((Object)"yes", (Object)1).set((Object)"no", (Object)2);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.groupUserlist", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(1, 30, sqlPara);
        return RetUtils.okList(records.getList());
    }

    public Ret changeOwner(final Integer uid, final Integer otherUid, final Long groupid) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return RetUtils.noExistParam();
        }
        if (!Objects.equals(wxGroup.getUid(), uid)) {
            return RetUtils.grantError();
        }
        final WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(uid, groupid);
        if (!ChatService.groupChatLink(groupItem)) {
            return RetUtils.failMsg("\u7fa4\u4e3b\u65e0\u6548");
        }
        final WxChatGroupItem otherGroupItem = ChatIndexService.chatGroupIndex(otherUid, groupid);
        if (!ChatService.groupChatLink(otherGroupItem)) {
            return RetUtils.failMsg("\u8f6c\u8ba9\u7528\u6237\u4e0d\u662f\u7fa4\u6709\u6548\u7528\u6237");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                WxChatItems chatItems;
                WxGroup updateGroup = new WxGroup();
                updateGroup.setId(groupid);
                updateGroup.setUid(otherUid);
                boolean update = updateGroup.update();
                if (!update) {
                    return this.failRet("\u7fa4\u8f6c\u8ba9\u5931\u8d25");
                }
                WxGroupMeta meta = new WxGroupMeta();
                meta.setGroupid(groupid);
                meta.setTransfercount((short)1);
                GroupService.this.updateMeta(meta);
                ChatIndexService.me.chatGroupIndexUpdate(otherUid, groupid, null, null, null, (byte)1, null, null, false);
                ChatIndexService.me.chatGroupIndexUpdate(uid, groupid, null, null, null, (byte)2, null, null, false);
                WxGroupUser memberUser = new WxGroupUser();
                memberUser.setGrouprole((byte)2);
                memberUser.setId(groupItem.getGpulinkid());
                boolean memberUpdate = GroupService.this.updateGroupUser(memberUser);
                if (!memberUpdate) {
                    return this.failRet("\u7fa4\u89d2\u8272\u4fee\u6539\u5931\u8d25");
                }
                WxGroupUser ownerUser = new WxGroupUser();
                ownerUser.setGrouprole((byte)1);
                ownerUser.setId(otherGroupItem.getGpulinkid());
                boolean ownerUpdate = GroupService.this.updateGroupUser(ownerUser);
                if (!ownerUpdate) {
                    return this.failRet("\u7fa4\u89d2\u8272\u4fee\u6539\u5931\u8d25");
                }
                if (otherGroupItem.getChatlinkid() != null) {
                    chatItems = new WxChatItems();
                    chatItems.setId(otherGroupItem.getChatlinkid());
                    chatItems.setBizrole((byte)1);
                    chatItems.update();
                }
                if (groupItem.getChatlinkid() != null) {
                    chatItems = new WxChatItems();
                    chatItems.setId(groupItem.getChatlinkid());
                    chatItems.setBizrole((byte)2);
                    chatItems.update();
                }
                return true;
            }
        };
        boolean del = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!del) {
            return atom.getRetObj();
        }
        otherGroupItem.setGrouprole((byte)1);
        groupItem.setGrouprole((byte)2);
        ChatIndexService.removeUserCache(uid, groupid, (byte)2);
        ChatIndexService.removeUserCache(otherUid, groupid, (byte)2);
        ChatIndexService.removeGroupCache(groupid);
        if (otherGroupItem.getChatlinkid() != null) {
            ChatIndexService.removeChatItemsCache(otherGroupItem.getChatlinkid());
        }
        if (groupItem.getChatlinkid() != null) {
            ChatIndexService.removeChatItemsCache(groupItem.getChatlinkid());
        }
        ChatIndexService.clearGroupUserCache(groupid);
        return Ret.ok().set((Object)"other", (Object)otherGroupItem).set((Object)"owner", (Object)groupItem);
    }

    public Ret delGroup(User curr, final Long groupid) throws Exception {
        WxGroup group = me.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.noExistParam();
        }
        final WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(curr.getId(), groupid);
        if (!ChatService.groupChatLink(groupItem) || !Objects.equals(groupItem.getGrouprole(), (byte)1)) {
            return RetUtils.grantError();
        }
        final Integer uid = curr.getId();
        final Byte chatmode = 2;
        final Long chatlinkid = groupItem.getChatlinkid();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean remove;
                WxGroup delGroup = new WxGroup();
                delGroup.setId(groupid);
                boolean del = delGroup.delete();
                if (!del) {
                    return this.failRet("\u7fa4\u5220\u9664\u5f02\u5e38");
                }
                if (chatlinkid != null && !(remove = ChatService.me.deleteChatItem(chatlinkid))) {
                    this.failRet("\u6e05\u9664\u804a\u5929\u5217\u8868\u5931\u8d25");
                    return false;
                }
                GroupService.this.delGroupUser(groupItem.getGpulinkid());
                ChatIndexService.me.chatGroupIndexDel(uid, groupid);
                ChatIndexService.me.chatUserIndexDel(uid, groupid, chatmode);
                return true;
            }
        };
        boolean del = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!del) {
            return atom.getRetObj();
        }
        if (chatlinkid != null) {
            ChatIndexService.removeChatItemsCache(chatlinkid);
        }
        ChatIndexService.clearChatUserIndex(uid, groupid, chatmode);
        ChatIndexService.removeGroupCache(groupid);
        return Ret.ok().set((Object)"groupitem", (Object)groupItem).set((Object)"group", (Object)group);
    }

    public Ret createGroup(final User curr, final WxGroup group, String nicks, final Byte devicetype, final String sessionid, final String ip, final short joinnum) throws Exception {
        final Integer uid = curr.getId();
        String name = group.getName();
        Resp resp = CommonUtils.checkGroupName(name, "\u7fa4\u540d");
        if (!resp.isOk()) {
            return RetUtils.failMsg(resp.getMsg());
        }
        String avatar = group.getAvatar();
        if (StrUtil.isBlank((CharSequence)avatar)) {
            group.setAvatar("/img/group.png");
        }
        group.setUid(uid);
        final SysMsgVo sysMsgVo = new SysMsgVo(curr.getNick(), "%%% \u9080\u8bf7 ### \u52a0\u5165\u4e86\u7fa4\u804a", nicks, "create");
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean save = group.save();
                if (!save) {
                    return this.failRet("\u7fa4\u57fa\u7840\u4fe1\u606f\u521d\u59cb\u5316\u5f02\u5e38");
                }
                Long groupid = group.getId();
                WxGroupUser groupUser = new WxGroupUser();
                groupUser.setGroupid(groupid);
                groupUser.setUid(uid);
                groupUser.setAutoflag((byte)1);
                groupUser.setGroupnick(curr.getNick());
                groupUser.setSrcnick(curr.getNick());
                groupUser.setGroupavator(curr.getAvatar());
                groupUser.setGrouprole((byte)1);
                boolean userSave = groupUser.save();
                if (!userSave) {
                    return this.failRet("\u7fa4\u4e3b\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38");
                }
                WxGroupMsg groupMsg = me.addSysMsg(devicetype, sessionid, sysMsgVo.toText(), uid, ip, groupid, "", sysMsgVo, groupUser);
                if (groupMsg == null) {
                    return this.failRet("\u6d88\u606f\u4fdd\u5b58\u5931\u8d25");
                }
                WxChatItems chatItem = new WxChatItems();
                chatItem.setUid(uid);
                chatItem.setBizid(groupid);
                chatItem.setLinkid(groupUser.getId());
                chatItem.setChatmode((byte)2);
                chatItem.setBizrole(groupUser.getGrouprole());
                chatItem.setAvatar(group.getAvatar());
                chatItem.setName(group.getName());
                chatItem.setLastmsgid(groupMsg.getId());
                chatItem.setLastmsguid(uid);
                chatItem.setFromnick(curr.getNick());
                chatItem.setSysflag(groupMsg.getSendbysys());
                chatItem.setMsgresume(groupMsg.getResume());
                chatItem.setSendtime(groupMsg.getTime());
                chatItem.setNotreadstartmsgid(groupMsg.getId());
                chatItem.setNotreadcount((short)0);
                chatItem.setJoinnum(joinnum);
                chatItem.setStartmsgid(groupMsg.getId());
                chatItem.setChatuptime(new Date());
                boolean chatsave = chatItem.save();
                if (!chatsave) {
                    return this.failRet("\u4f1a\u8bdd\u521d\u59cb\u5316\u5f02\u5e38");
                }
                ChatIndexService.clearMailListCache(uid);
                ChatIndexService.me.chatUserInit(uid, (byte)2, groupid, chatItem.getId(), groupUser.getId(), groupMsg.getId());
                ChatIndexService.me.chatGroupInit(uid, groupid, chatItem.getId(), groupUser.getId(), (byte)1, groupMsg.getId(), null);
                WxGroupMeta meta = new WxGroupMeta();
                meta.setGroupid(groupid);
                meta.setJoinnum(joinnum);
                boolean metaSave = meta.save();
                if (!metaSave) {
                    return this.failRet("\u7fa4\u7edf\u8ba1\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38");
                }
                group.setJoinnum(joinnum);
                this.retObj = Ret.ok().set((Object)"owner", (Object)chatItem).set((Object)"msg", (Object)groupMsg);
                return true;
            }
        };
        boolean init = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!init) {
            return atom.getRetObj();
        }
        return atom.getRetObj().set((Object)"sysmsgvo", (Object)sysMsgVo);
    }

    public Ret joinGroup(User curr, final Long groupid, final String uids, Integer applyuid) throws Exception {
        boolean msgclear;
        int otheruid;
        WxChatGroupItem groupItem;
        Ret checkRet;
        if (StrUtil.isBlank((CharSequence)uids)) {
            return RetUtils.invalidParam();
        }
        Integer operUid = curr.getId();
        if (applyuid != null) {
            operUid = applyuid;
        }
        if ((checkRet = this.checkJoinGroup(operUid, groupid, null, null)).isFail()) {
            return checkRet;
        }
        final WxGroup group = this.getByGroupid(groupid);
        final String[] uidArr = StrUtil.split((CharSequence)uids, (CharSequence)",");
        if (uidArr.length == 1 && ChatService.groupChatLink(groupItem = ChatIndexService.chatGroupIndex(otheruid = Integer.parseInt(uidArr[0]), groupid))) {
            return RetUtils.failMsg("\u7528\u6237\u5df2\u5728\u7fa4\u7ec4\u4e2d");
        }
        if (uidArr.length > 50) {
            return RetUtils.failMsg("\u4e00\u6b21\u9080\u8bf7\u4e0d\u8981\u8d85\u8fc750\u54e6");
        }
        final ArrayList resetBindList = new ArrayList();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                short joinnum = 0;
                String nickStr = "";
                String groupname = group.getName();
                boolean updateGroupName = false;
                boolean msgClear = false;
                if (StrUtil.isNotBlank((CharSequence)uids)) {
                    for (String uidStr : uidArr) {
                        if (!StrUtil.isNotBlank((CharSequence)uidStr)) continue;
                        try {
                            String newName;
                            int otheruid = Integer.parseInt(uidStr);
                            User user = UserService.ME.getById(otheruid);
                            if (user == null) {
                                log.error("\u9080\u8bf7\u7528\u6237\u4e0d\u5b58\u5728\uff1auid:{},groupid:{}", (Object)otheruid, (Object)groupid);
                                continue;
                            }
                            nickStr = nickStr + "\u3001" + user.getNick();
                            WxGroupUser otherUser = new WxGroupUser();
                            otherUser.setGroupid(groupid);
                            otherUser.setUid(otheruid);
                            otherUser.setSrcnick(user.getNick());
                            otherUser.setAutoflag((byte)1);
                            otherUser.setGroupnick(user.getNick());
                            otherUser.setGroupavator(user.getAvatar());
                            int otherSave = otherUser.ignoreSave();
                            if (otherSave <= 0) {
                                log.error("\u5df2\u5b58\u5728\u7fa4\u7528\u6237\uff1auid:{},groupid:{}", (Object)otheruid, (Object)groupid);
                                continue;
                            }
                            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(otheruid, groupid);
                            if (groupItem != null) {
                                ChatIndexService.me.chatUserIndexUpdate(otheruid, groupid, (byte)2, null, null, (byte)1, otherUser.getId(), null, null);
                                if (groupItem.getChatlinkid() != null) {
                                    ChatIndexService.me.chatGroupIndexUpdate(otheruid, groupid, null, null, (byte)1, null, otherUser.getId(), (byte)1, false);
                                    ChatService.me.updateChatItemStatus(groupItem.getChatlinkid(), (byte)1, null, null, null, otherUser.getId(), group.getJoinnum());
                                    WxChatItems chatItems = ChatService.me.getChatItems(groupItem.getChatlinkid());
                                    ChatMsgService.me.rebindGroupMsgDeal(chatItems);
                                    msgClear = true;
                                } else {
                                    ChatIndexService.me.chatGroupIndexUpdate(otheruid, groupid, null, null, (byte)1, null, otherUser.getId(), (byte)1, true);
                                }
                                resetBindList.add(groupItem);
                            } else {
                                ChatIndexService.me.chatUserInit(otheruid, (byte)2, groupid);
                                ChatIndexService.me.chatGroupInit(otheruid, groupid, null, otherUser.getId(), (byte)2, (byte)2, (byte)1, (byte)2, null, (byte)1);
                            }
                            joinnum = (short)(joinnum + 1);
                            if (Objects.equals(group.getAutoflag(), (byte)1) && (newName = groupname + "\u3001" + user.getNick()).length() <= 30) {
                                updateGroupName = true;
                            }
                            ChatIndexService.clearMailListCache(otheruid);
                        }
                        catch (Exception e) {
                            log.error(e.toString(), (Throwable)e);
                        }
                    }
                }
                WxGroupMeta meta = new WxGroupMeta();
                meta.setGroupid(groupid);
                meta.setJoinnum(joinnum);
                boolean metaSave = GroupService.this.updateMeta(meta);
                if (!metaSave) {
                    return this.failRet("\u7fa4\u7edf\u8ba1\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38");
                }
                ChatService.me.updateItemJoinNum(joinnum, groupid);
                this.retObj = RetUtils.okData(nickStr.substring(1)).set((Object)"joinnum", (Object)joinnum);
                if (updateGroupName) {
                    this.retObj.set((Object)"nameupdate", (Object)1);
                }
                this.retObj.set((Object)"msgclear", (Object)msgClear);
                return true;
            }
        };
        boolean init = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!init) {
            return atom.getRetObj();
        }
        if (CollectionUtil.isNotEmpty(resetBindList)) {
            atom.getRetObj().set((Object)"rebind", resetBindList);
        }
        if (msgclear = ((Boolean)RetUtils.getOkTData(atom.getRetObj(), "msgclear")).booleanValue()) {
            ChatIndexService.clearGroupMsgCache(groupid);
        }
        ChatIndexService.removeGroupCache(groupid);
        ChatIndexService.clearGroupUserCache(groupid);
        return atom.getRetObj();
    }

    public Ret kickGroup(User curr, final Long groupid, final String uids) throws Exception {
        if (StrUtil.isBlank((CharSequence)uids)) {
            return RetUtils.invalidParam();
        }
        final WxGroup group = this.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.noExistParam();
        }
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(curr.getId(), groupid);
        if (Objects.equals(groupItem.getGrouprole(), (byte)2)) {
            return RetUtils.grantError();
        }
        if (("," + uids + ",").indexOf("," + curr.getId() + ",") >= 0) {
            return RetUtils.failMsg("\u4e0d\u80fd\u5bf9\u81ea\u5df1\u64cd\u4f5c");
        }
        final String[] uidArr = StrUtil.split((CharSequence)uids, (CharSequence)",");
        final Byte mode = 2;
        final ArrayList kickGroupItem = new ArrayList();
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                short joinnum = 0;
                String nickStr = "";
                String groupname = group.getName();
                boolean updateGroupName = false;
                if (StrUtil.isNotBlank((CharSequence)uids)) {
                    for (String uidStr : uidArr) {
                        if (!StrUtil.isNotBlank((CharSequence)uidStr)) continue;
                        try {
                            int otheruid = Integer.parseInt(uidStr);
                            WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(otheruid, groupid);
                            if (!ChatService.groupChatLink(groupItem)) continue;
                            kickGroupItem.add(groupItem);
                            joinnum = (short)(joinnum - 1);
                            User user = UserService.ME.getById(otheruid);
                            if (user == null) {
                                log.error("\u88ab\u8e22\u7528\u6237\u4e0d\u5b58\u5728\uff1auid:{},groupid:{}", (Object)otheruid, (Object)groupid);
                                ChatIndexService.me.chatGroupIndexDel(otheruid, groupid);
                                ChatIndexService.me.chatUserIndexDel(otheruid, groupid, mode);
                                if (groupItem.getChatlinkid() == null) continue;
                                ChatService.me.deleteChatItem(groupItem.getChatlinkid());
                                continue;
                            }
                            nickStr = nickStr + "\u3001" + user.getNick();
                            GroupService.this.delGroupUser(groupItem.getGpulinkid());
                            if (groupItem.getChatlinkid() != null) {
                                ChatIndexService.me.chatGroupIndexUpdate(otheruid, groupid, null, null, (byte)2, null, null, (byte)1, false);
                                ChatIndexService.me.chatUserIndexUpdate(otheruid, groupid, mode, null, null, (byte)2, null, null, null);
                                ChatService.me.updateChatItemStatus(groupItem.getChatlinkid(), (byte)2, null, null, null, null, null);
                            } else {
                                ChatIndexService.me.chatGroupIndexDel(otheruid, groupid);
                                ChatIndexService.me.chatUserIndexDel(otheruid, groupid, mode);
                            }
                            if (Objects.equals(group.getAutoflag(), (byte)1) && ("\u3001" + groupname + "\u3001").indexOf("\u3001" + user.getNick() + "\u3001") >= 0) {
                                updateGroupName = true;
                            }
                            ChatIndexService.clearMailListCache(otheruid);
                        }
                        catch (Exception e) {
                            log.error(e.toString(), (Throwable)e);
                        }
                    }
                }
                WxGroupMeta meta = new WxGroupMeta();
                meta.setGroupid(groupid);
                meta.setJoinnum(joinnum);
                boolean metaSave = GroupService.this.updateMeta(meta);
                if (!metaSave) {
                    return this.failRet("\u7fa4\u7edf\u8ba1\u6570\u636e\u521d\u59cb\u5316\u5f02\u5e38");
                }
                ChatService.me.updateItemJoinNum(joinnum, groupid);
                this.retObj = RetUtils.okData(nickStr.substring(1)).set((Object)"joinnum", (Object)joinnum);
                if (updateGroupName) {
                    this.retObj.set((Object)"nameupdate", (Object)1);
                }
                return true;
            }
        };
        boolean init = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!init) {
            return atom.getRetObj();
        }
        ChatIndexService.clearMailListCache(curr.getId());
        ChatIndexService.removeGroupCache(groupid);
        ChatIndexService.clearGroupUserCache(groupid);
        return atom.getRetObj().set((Object)"kick", kickGroupItem);
    }

    public Ret checkJoinGroup(Integer operuid, Long groupid, Integer uid, Date sendtime) {
        WxChatGroupItem joinGroupItem;
        WxGroup group = this.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.failMsg("\u7fa4\u5df2\u89e3\u6563");
        }
        if (uid != null && ChatService.groupChatLink(joinGroupItem = ChatIndexService.chatGroupIndex(uid, groupid))) {
            return Ret.ok().set((Object)"joinflag", (Object)1);
        }
        WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(operuid, groupid);
        if (!ChatService.groupChatLink(groupItem)) {
            return RetUtils.failMsg("\u9080\u8bf7\u94fe\u63a5\u5df2\u5931\u6548");
        }
        if (Objects.equals(groupItem.getGrouprole(), (byte)1) || Objects.equals(groupItem.getGrouprole(), (byte)3)) {
            WxChatGroupItem joinGroupItem2;
            if (uid != null && ChatService.groupChatLink(joinGroupItem2 = ChatIndexService.chatGroupIndex(uid, groupid))) {
                return Ret.ok().set((Object)"joinflag", (Object)1);
            }
            return Ret.ok().set((Object)"joinflag", (Object)2);
        }
        if (sendtime != null && DateUtil.betweenMs((Date)sendtime, (Date)new Date()) > 259200000L) {
            return RetUtils.failMsg("\u9080\u8bf7\u94fe\u63a5\u5df2\u5931\u6548");
        }
        if (Objects.equals(group.getApplyflag(), (byte)2)) {
            return RetUtils.failMsg("\u8be5\u7fa4\u804a\u672a\u5f00\u653e\u9080\u8bf7");
        }
        return Ret.ok().set((Object)"joinflag", (Object)2);
    }

    public Ret leaveGroup(final User curr, final Long groupid) throws Exception {
        final Integer uid = curr.getId();
        final WxGroup group = this.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        final WxChatGroupItem groupItem = ChatIndexService.chatGroupIndex(uid, groupid);
        if (!ChatService.groupChatLink(groupItem)) {
            return RetUtils.grantError();
        }
        final Byte chatmode = 2;
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean metaUpdate;
                WxChatGroupItem newOnwerGroupItem;
                boolean remove;
                String groupname = group.getName();
                boolean change = false;
                if (groupItem.getChatlinkid() != null && !(remove = ChatService.me.deleteChatItem(groupItem.getChatlinkid()))) {
                    return this.failRet("\u6e05\u9664\u804a\u5929\u5217\u8868\u5931\u8d25");
                }
                ChatIndexService.me.chatGroupIndexDel(uid, groupid);
                ChatIndexService.me.chatUserIndexDel(uid, groupid, chatmode);
                GroupService.this.delGroupUser(groupItem.getGpulinkid());
                this.retObj = Ret.ok();
                if (Objects.equals((byte)1, groupItem.getGrouprole()) && (newOnwerGroupItem = ChatIndexService.me.getFristGroupUserIndex(groupid)) != null) {
                    Integer otherUid = newOnwerGroupItem.getUid();
                    WxGroup updateGroup = new WxGroup();
                    updateGroup.setId(groupid);
                    updateGroup.setUid(otherUid);
                    boolean update = updateGroup.update();
                    if (!update) {
                        return this.failRet("\u7fa4\u8f6c\u8ba9\u5931\u8d25");
                    }
                    WxGroupUser groupUser = new WxGroupUser();
                    groupUser.setGrouprole((byte)1);
                    groupUser.setId(newOnwerGroupItem.getGpulinkid());
                    boolean userUpdate = GroupService.this.updateGroupUser(groupUser);
                    if (!userUpdate) {
                        return this.failRet("\u7fa4\u89d2\u8272\u4fee\u6539\u5931\u8d25");
                    }
                    ChatIndexService.me.chatGroupIndexUpdate(otherUid, groupid, null, null, null, (byte)1, null, null, false);
                    if (newOnwerGroupItem.getChatlinkid() != null) {
                        WxChatItems chatItems = new WxChatItems();
                        chatItems.setId(newOnwerGroupItem.getChatlinkid());
                        chatItems.setBizrole((byte)1);
                        chatItems.update();
                    }
                    newOnwerGroupItem.setGrouprole((byte)1);
                    this.retObj.set((Object)"owner", (Object)newOnwerGroupItem);
                    change = true;
                }
                this.retObj.set((Object)"change", (Object)change);
                WxGroupMeta meta = new WxGroupMeta();
                meta.setGroupid(groupid);
                meta.setJoinnum((short)-1);
                if (change) {
                    meta.setTransfercount((short)1);
                    meta.setLeavecount((short)1);
                }
                if (!(metaUpdate = GroupService.this.updateMeta(meta))) {
                    return this.failRet("\u7fa4\u7edf\u8ba1\u6570\u636e\u4fee\u6539\u5f02\u5e38");
                }
                ChatService.me.updateItemJoinNum((short)-1, groupid);
                if (Objects.equals(group.getAutoflag(), (byte)1) && ("\u3001" + groupname + "\u3001").indexOf("\u3001" + curr.getNick() + "\u3001") >= 0) {
                    this.retObj.set((Object)"nameupdate", (Object)1);
                }
                return true;
            }
        };
        boolean init = Db.use((String)"tio_site_main").tx((IAtom)atom);
        if (!init) {
            return atom.getRetObj();
        }
        Ret ret = atom.getRetObj();
        boolean change = (Boolean)RetUtils.getOkTData(ret, "change");
        if (change) {
            WxChatGroupItem newgroupitItem = (WxChatGroupItem)((Object)RetUtils.getOkTData(ret, "owner"));
            if (newgroupitItem.getChatlinkid() != null) {
                ChatIndexService.removeChatItemsCache(newgroupitItem.getChatlinkid());
            }
            ChatIndexService.removeUserCache(newgroupitItem.getUid(), groupid, (byte)2);
        }
        ChatIndexService.clearChatUserIndex(uid, groupid, (byte)2);
        if (groupItem.getChatlinkid() != null) {
            ChatIndexService.removeChatItemsCache(groupItem.getChatlinkid());
        }
        ChatIndexService.clearGroupUserCache(groupid);
        ChatIndexService.removeGroupCache(groupid);
        ChatIndexService.clearMailListCache(uid);
        return ret.set((Object)"leave", (Object)groupItem);
    }

    public WxGroupMsg addMsg(Byte devicetype, String sessionid, String text, Integer uid, String ip, long groupid, Long frommsgid, Byte fromchatmode, WxGroupUser groupUser) {
        return this.addMsg(devicetype, sessionid, text, uid, ip, groupid, (byte)1, (byte)2, null, null, frommsgid, fromchatmode, "", null, groupUser);
    }

    public WxGroupMsg addMsg(Byte devicetype, String sessionid, String text, Integer uid, String ip, long groupid, Byte contenttype, Long frommsgid, Byte fromchatmode, Byte sendbysys, String operBizData, SysMsgVo sysMsgVo, WxGroupUser groupUser) {
        return this.addMsg(devicetype, sessionid, text, uid, ip, groupid, contenttype, sendbysys, null, null, frommsgid, fromchatmode, operBizData, sysMsgVo, groupUser);
    }

    public WxGroupMsg addSysMsg(Byte devicetype, String sessionid, String text, Integer uid, String ip, long groupid, String operBizData, SysMsgVo sysMsgVo, WxGroupUser groupUser) {
        return this.addMsg(devicetype, sessionid, text, uid, ip, groupid, (byte)1, (byte)1, null, null, null, null, operBizData, sysMsgVo, groupUser);
    }

    public WxGroupMsg addMsg(Byte devicetype, String sessionid, String text, Integer uid, String ip, long groupid, Byte contenttype, Byte sendbysys, Integer sigleuid, Integer whereuid, Long frommsgid, Byte fromchatmode, String operBizData, SysMsgVo sysMsgVo, WxGroupUser groupUser) {
        IpInfo ipInfo = IpInfoService.ME.save(ip);
        WxGroupMsg msg = new WxGroupMsg();
        String resume = "";
        switch (contenttype) {
            case 1: {
                resume = StrUtil.trim((CharSequence)HtmlUtil.cleanHtmlTag((String)text));
                resume = StrUtil.subWithLength((String)resume, (int)0, (int)20);
                if (!Objects.equals(sendbysys, (byte)1) || sysMsgVo == null) break;
                msg.setOpernick(sysMsgVo.getOpernick());
                msg.setSysmsgkey(sysMsgVo.getMsgkey());
                msg.setTonicks(sysMsgVo.getTonicks());
                break;
            }
            case 4: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u97f3\u9891";
                break;
            }
            case 2: {
                resume = "\u53d1\u4e00\u6761\u535a\u5ba2";
                break;
            }
            case 3: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u6587\u4ef6";
                break;
            }
            case 6: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u56fe\u7247";
                break;
            }
            case 5: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u89c6\u9891";
                break;
            }
            case 9: {
                resume = "\u5206\u4eab\u4e00\u4e2a\u540d\u7247";
                break;
            }
        }
        msg.setFrommode(fromchatmode);
        msg.setOperbizdata(operBizData);
        msg.setResume(resume);
        msg.setText(text);
        msg.setGroupid(groupid);
        msg.setIpid(ipInfo.getId());
        msg.setDevice(devicetype);
        msg.setTime(new Date());
        msg.setUid(uid);
        if (groupUser == null) {
            msg.setAutoflag((byte)2);
            User sender = UserService.ME.getById(uid);
            msg.setNick(sender.getNick());
            msg.setAvatar(sender.getAvatar());
        } else {
            msg.setNick(groupUser.getGroupnick());
            msg.setAvatar(groupUser.getGroupavator());
            msg.setAutoflag(groupUser.getAutoflag());
        }
        msg.setSession(sessionid);
        msg.setSendbysys(sendbysys);
        msg.setContenttype(contenttype);
        msg.setStatus((byte)1);
        if (sigleuid != null) {
            msg.setSigleflag((byte)1);
            msg.setSigleuid(sigleuid);
        } else {
            msg.setSigleuid(Const.MSG_DEFAULT_UID);
        }
        if (whereuid != null) {
            msg.setWhereflag((byte)1);
            msg.setWhereuid(whereuid + "");
        }
        msg.setFrommsgid(frommsgid);
        boolean save = msg.save();
        if (!save) {
            log.error("\u6d88\u606f\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)Json.toJson((Object)((Object)msg)));
            return null;
        }
        return msg;
    }

    public ArrayList<WxGroupMsg> getGroupCacheMsgList(Long chatlinkid) {
        String key;
        ArrayList msgList;
        if (chatlinkid == null) {
            return null;
        }
        WxChatGroupItem userItem = ChatIndexService.chatGroupIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        final WxChatItems chatItems = ChatService.me.getChatItems(chatlinkid);
        if (chatItems == null) {
            return null;
        }
        final int historyCount = MgConfService.getInt("im.history.chat.count.group", 30);
        if ((Objects.equals(userItem.getResetflag(), (byte)2) || Objects.equals(chatItems.getLinkflag(), (byte)1) && chatItems.getMsgcount() >= historyCount) && CollectionUtil.isNotEmpty((Collection)(msgList = (ArrayList)CacheUtils.get((ICache)GROUP_MSG_CACHE, (String)(key = chatItems.getBizid() + ""), (boolean)true, (FirsthandCreater)new FirsthandCreater<ArrayList<WxGroupMsg>>(){

            public ArrayList<WxGroupMsg> create() {
                Kv params = Kv.by((Object)"groupid", (Object)chatItems.getBizid()).set((Object)"status", (Object)1).set((Object)"limit", (Object)historyCount);
                SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgList", (Map)params);
                ArrayList list = (ArrayList)WxGroupMsg.dao.find(sqlPara);
                return list;
            }
        })))) {
            for (WxGroupMsg msg : msgList) {
                if (!Objects.equals(msg.getWhereflag(), (byte)2) && msg.getWhereuid().indexOf("," + userItem.getUid() + ",") >= 0) continue;
                return msgList;
            }
        }
        Long startMsg = userItem.getStartmsgid();
        Kv params = Kv.by((Object)"groupid", (Object)userItem.getGroupid()).set((Object)"status", (Object)1).set((Object)"uidstr", (Object)("," + userItem.getUid() + ",")).set((Object)"uid", (Object)userItem.getUid()).set((Object)"limit", (Object)historyCount);
        if (startMsg != null) {
            params.set((Object)"startmsgid", (Object)startMsg);
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        if (Objects.equals(chatItems.getLinkflag(), (byte)2) && chatItems.getLastmsgid() != null) {
            params.set((Object)"kickmsgid", (Object)chatItems.getLastmsgid());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgList", (Map)params);
        List list = WxGroupMsg.dao.find(sqlPara);
        return (ArrayList)list;
    }

    public WxGroupMsg getGroupFristMsg(WxChatItems chatItems) {
        WxChatGroupItem userItem = ChatIndexService.chatGroupIndex(chatItems.getId());
        if (userItem == null) {
            return null;
        }
        Long startMsg = userItem.getStartmsgid();
        Kv params = Kv.by((Object)"groupid", (Object)userItem.getGroupid()).set((Object)"status", (Object)1).set((Object)"uidstr", (Object)("," + userItem.getUid() + ",")).set((Object)"uid", (Object)userItem.getUid());
        if (startMsg != null) {
            params.set((Object)"startmsgid", (Object)startMsg);
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.firstGroupMsg", (Map)params);
        WxGroupMsg msg = (WxGroupMsg)WxGroupMsg.dao.findFirst(sqlPara);
        return msg;
    }

    public List<WxGroupMsg> getGroupMsgList(Long chatlinkid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatGroupItem userItem = ChatIndexService.chatGroupIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        int historyCount = MgConfService.getInt("im.history.chat.count.group", 30);
        Long startMsg = userItem.getStartmsgid();
        Kv params = Kv.by((Object)"groupid", (Object)userItem.getGroupid()).set((Object)"status", (Object)1).set((Object)"limit", (Object)historyCount);
        if (startMsg != null) {
            params.set((Object)"startmsgid", (Object)startMsg);
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgList", (Map)params);
        List list = WxGroupMsg.dao.find(sqlPara);
        return list;
    }

    public List<WxGroupMsg> getOtherGroupMsgList(Long chatlinkid, Long startMid) {
        if (chatlinkid == null) {
            return null;
        }
        if (startMid == null) {
            ArrayList<WxGroupMsg> first = this.getGroupCacheMsgList(chatlinkid);
            return first;
        }
        WxChatGroupItem userItem = ChatIndexService.chatGroupIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        Long startMsg = userItem.getStartmsgid();
        int historyCount = MgConfService.getInt("im.history.chat.count.group", 30);
        Kv params = Kv.by((Object)"groupid", (Object)userItem.getGroupid()).set((Object)"status", (Object)1).set((Object)"uidstr", (Object)("," + userItem.getUid() + ",")).set((Object)"uid", (Object)userItem.getUid()).set((Object)"limit", (Object)historyCount).set((Object)"limitmsgid", (Object)startMid);
        if (startMsg != null) {
            params.set((Object)"startmsgid", (Object)startMsg);
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgList", (Map)params);
        List list = WxGroupMsg.dao.find(sqlPara);
        return list;
    }

    public List<WxGroupMsg> getSynGroupMsgList(Long chatlinkid, Long endmid) {
        if (chatlinkid == null) {
            return null;
        }
        WxChatGroupItem userItem = ChatIndexService.chatGroupIndex(chatlinkid);
        if (userItem == null) {
            return null;
        }
        Long startMsg = userItem.getStartmsgid();
        int historyCount = MgConfService.getInt("im.history.chat.count.group", 30);
        Kv params = Kv.by((Object)"groupid", (Object)userItem.getGroupid()).set((Object)"status", (Object)1).set((Object)"uidstr", (Object)("," + userItem.getUid() + ",")).set((Object)"uid", (Object)userItem.getUid()).set((Object)"limit", (Object)historyCount);
        if (startMsg != null) {
            if (startMsg < endmid) {
                params.set((Object)"endmid", (Object)endmid);
            } else {
                params.set((Object)"startmsgid", (Object)startMsg);
            }
        } else {
            params.set((Object)"startmsgid", (Object)WxFriendMsg.maxid);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("chatmsg.groupMsgList", (Map)params);
        List list = WxGroupMsg.dao.find(sqlPara);
        return list;
    }

    public Ret checkSendCard(Integer operuid, Long groupid) {
        WxGroup group = me.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(operuid, group.getUid())) {
            return RetUtils.okOper();
        }
        if (Objects.equals(group.getApplyflag(), (byte)2)) {
            return RetUtils.failMsg("\u5f53\u524d\u7fa4\u804a\u672a\u5f00\u542f\u6210\u5458\u9080\u8bf7");
        }
        return RetUtils.okOper();
    }

    public Ret getGroupCard(Integer uid, Long groupid) throws Exception {
        Ret ret = this.checkJoinGroup(uid, groupid, null, null);
        if (ret.isFail()) {
            return ret;
        }
        WxGroup group = this.getByGroupid(groupid);
        if (group == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        WxMsgCardVo wsMsgCardVo = new WxMsgCardVo();
        wsMsgCardVo.setCardtype(Byte.valueOf((byte)2));
        wsMsgCardVo.setBizavatar(group.getAvatar());
        wsMsgCardVo.setBizname(group.getName());
        wsMsgCardVo.setBizid(groupid);
        wsMsgCardVo.setShareFromUid(uid);
        return RetUtils.okData(wsMsgCardVo);
    }

    public void putToGroupCache(final WxGroupMsg msg, Long groupid) {
        String key;
        ListWithLock listWithLock;
        if (groupid != null && (listWithLock = (ListWithLock)GROUP_MSG_CACHE.get(key = groupid + "", ListWithLock.class)) != null) {
            listWithLock.handle((WriteLockHandler)new WriteLockHandler<List<WxGroupMsg>>(){

                public void handler(List<WxGroupMsg> list) {
                    list.add(0, msg);
                    int historyCount = MgConfService.getInt("im.history.chat.count.group", 30);
                    while (list.size() > historyCount) {
                        list.remove(historyCount);
                    }
                }
            });
        }
    }

    public boolean updateMeta(WxGroupMeta meta) {
        if (meta.getGroupid() == null) {
            return false;
        }
        Kv params = Kv.by((Object)"groupid", (Object)meta.getGroupid());
        if (meta.getJoinnum() != null) {
            params.set((Object)"joinnum", (Object)meta.getJoinnum());
        }
        if (meta.getKickcount() != null) {
            params.set((Object)"kickcount", (Object)meta.getKickcount());
        }
        if (meta.getLeavecount() != null) {
            params.set((Object)"leavecount", (Object)meta.getLeavecount());
        }
        if (meta.getTransfercount() != null) {
            params.set((Object)"transfercount", (Object)meta.getTransfercount());
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("group.updateMeta", (Map)params);
        int update = Db.use((String)"tio_site_main").update(sqlPara);
        return update > 0;
    }

    public Ret modifyApply(User curr, Long groupid, Byte mode) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return RetUtils.failMsg("\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u9080\u8bf7\u5f00\u5173");
        }
        WxGroup updateGroup = new WxGroup();
        updateGroup.setId(groupid);
        updateGroup.setApplyflag(mode);
        boolean f = updateGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Ret.ok();
        }
        return RetUtils.failMsg("\u64cd\u4f5c\u5931\u8d25");
    }

    public Ret modifyReview(User curr, Long groupid, Byte mode) {
        WxGroup wxGroup = this.getByGroupid(groupid);
        if (wxGroup == null) {
            return RetUtils.failMsg("\u7fa4\u4e0d\u5b58\u5728");
        }
        if (!Objects.equals(wxGroup.getUid(), curr.getId())) {
            return RetUtils.failMsg("\u53ea\u6709\u7fa4\u4e3b\u624d\u80fd\u4fee\u6539\u7fa4\u5ba1\u6838\u5f00\u5173");
        }
        WxGroup updateGroup = new WxGroup();
        updateGroup.setId(groupid);
        updateGroup.setJoinmode(mode);
        boolean f = updateGroup.update();
        if (f) {
            ChatIndexService.removeGroupCache(groupid);
            return Ret.ok();
        }
        return RetUtils.failMsg("\u64cd\u4f5c\u5931\u8d25");
    }

    public boolean delGroupUser(Long id) {
        return WxGroupUser.dao.deleteById(id);
    }

    public boolean updateGroupUser(WxGroupUser groupUser) {
        if (groupUser.getId() == null) {
            return false;
        }
        return groupUser.update();
    }

    public static String remorveGroupNick(String groupname, String nick) {
        groupname = ("\u3001" + groupname + "\u3001").replace("\u3001" + nick + "\u3001", "\u3001");
        if (groupname.indexOf("\u3001") == 0) {
            groupname = groupname.substring(1);
        }
        if (groupname.lastIndexOf("\u3001") == groupname.length() - 1) {
            groupname = groupname.substring(0, groupname.length() - 1);
        }
        return groupname;
    }

    public List<WxGroup> getAllGroup() {
        return WxGroup.dao.findAll();
    }
}

