/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.conf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.model.conf.Area;

public class AreaService {
    private static Logger log = LoggerFactory.getLogger(AreaService.class);
    public static final AreaService me = new AreaService();
    static final Area areaDao = (Area)new Area().dao();
    private static List<Area> allchildData = null;
    private static Map<String, Area> childCacheData = null;
    private static Map<String, Area> parentCacheData = null;

    public static void clearCache() {
        allchildData = null;
        childCacheData = null;
        parentCacheData = null;
    }

    public static void init() {
        AreaService.loadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        HashMap<String, Area> childCacheDataTemp = new HashMap<String, Area>();
        HashMap<String, Area> parentCacheDataTemp = new HashMap<String, Area>();
        ArrayList<Area> allchildDataTemp = new ArrayList<Area>();
        ArrayList<Map<String, Area>> depthChildAreaList = new ArrayList<Map<String, Area>>();
        try {
            String whereSql = " where pcode = 'area' and  status = 1";
            List depthArea = areaDao.find(AreaService.getSelectSql() + whereSql);
            int depth = 0;
            while (depthArea != null && !depthArea.isEmpty()) {
                HashMap<String, Area> depthChildMap = new HashMap<String, Area>();
                for (Area area : depthArea) {
                    Area copy = AreaService.copyArea(area);
                    if (depth == 0) {
                        allchildDataTemp.add(area);
                        parentCacheDataTemp.put(area.getCode(), copy);
                    } else {
                        Area parentArea = (Area)((Object)parentCacheDataTemp.get(area.getPcode()));
                        copy.setParentArea(parentArea);
                        parentCacheDataTemp.put(area.getCode(), copy);
                    }
                    childCacheDataTemp.put(area.getCode(), area);
                    depthChildMap.put(area.getCode(), area);
                }
                depthChildAreaList.add(depthChildMap);
                whereSql = AreaService.getWhereSql(whereSql);
                depthArea = areaDao.find(AreaService.getSelectSql() + whereSql);
                ++depth;
            }
            if (depthChildAreaList != null && !depthChildAreaList.isEmpty()) {
                for (depth = 0; depth < depthChildAreaList.size(); ++depth) {
                    Map depthMap = (Map)depthChildAreaList.get(depth);
                    if (depthMap == null || depthMap.isEmpty()) continue;
                    for (String key : depthMap.keySet()) {
                        Area area = (Area)((Object)depthMap.get(key));
                        AreaService.areaChildInit(area, depth, depthChildAreaList);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            childCacheData = childCacheDataTemp;
            parentCacheData = parentCacheDataTemp;
            allchildData = allchildDataTemp;
        }
    }

    private static void areaChildInit(Area area, int depth, List<Map<String, Area>> depthAreaList) {
        if (depth >= depthAreaList.size() - 1) {
            return;
        }
        Map<String, Area> childAreaMap = depthAreaList.get(depth + 1);
        String childPcode = area.getCode();
        ArrayList<Area> childArea = new ArrayList<Area>();
        for (String key : childAreaMap.keySet()) {
            Area child = childAreaMap.get(key);
            if (!child.getPcode().equals(childPcode)) continue;
            childArea.add(child);
        }
        area.setChildArea(childArea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Area getParent(String code) {
        if (allchildData != null) return parentCacheData.get(code);
        Class<AreaService> clazz = AreaService.class;
        synchronized (AreaService.class) {
            if (allchildData != null) return parentCacheData.get(code);
            AreaService.loadData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return parentCacheData.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Area getChild(String code) {
        if (allchildData != null) return childCacheData.get(code);
        Class<AreaService> clazz = AreaService.class;
        synchronized (AreaService.class) {
            if (allchildData != null) return childCacheData.get(code);
            AreaService.loadData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return childCacheData.get(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Area> getAreaTree() {
        if (allchildData != null) return allchildData;
        Class<AreaService> clazz = AreaService.class;
        synchronized (AreaService.class) {
            if (allchildData != null) return allchildData;
            AreaService.loadData();
            // ** MonitorExit[var0] (shouldn't be in output)
            return allchildData;
        }
    }

    private static String getWhereSql(String whereSql) {
        StringBuffer retSql = new StringBuffer();
        retSql.append(" where status = ").append(1).append(" and pcode in ( ").append("select code from area ").append(whereSql).append(")");
        return retSql.toString();
    }

    private static String getSelectSql() {
        return "select code,name,pcode from area ";
    }

    private static Area copyArea(Area area) {
        Area copyArea = new Area();
        copyArea.setName(area.getName());
        copyArea.setCode(area.getCode());
        copyArea.setPcode(area.getPcode());
        return copyArea;
    }

    public static void main(String[] args) {
    }
}

