/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.conf;

import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.conf.Conf;
import org.tio.mg.service.model.conf.ConfDev;
import org.tio.mg.service.utils.RetUtils;
import org.tio.utils.lock.LockUtils;

public class MgConfService {
    private static Logger log = LoggerFactory.getLogger(MgConfService.class);
    public static final MgConfService me = new MgConfService();
    static final Conf confDao = (Conf)new Conf().dao();
    static final ConfDev confDevDao = (ConfDev)new ConfDev().dao();
    private static Map<String, String> cacheData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Class<MgConfService> clazz = MgConfService.class;
        synchronized (MgConfService.class) {
            cacheData = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadData() {
        HashMap<String, String> tempCache = new HashMap<String, String>();
        ArrayList<Conf> list = null;
        try {
            List list2;
            list = confDao.find("select * from conf");
            if (list == null) {
                list = new ArrayList<Conf>();
            }
            if ((list2 = confDevDao.find("select * from conf_dev")) != null) {
                for (ConfDev item : list2) {
                    Conf conf = new Conf();
                    conf.setName(item.getName());
                    conf.setValue(item.getValue());
                    conf.setRemark(item.getRemark());
                    list.add(conf);
                }
            }
            if (list.size() == 0) {
                return;
            }
            for (Conf conf : list) {
                tempCache.put(conf.getName(), conf.getValue());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            cacheData = tempCache;
        }
    }

    public static String getString(String name, String defaultValue) {
        String value;
        if (cacheData == null) {
            try {
                LockUtils.runWriteOrWaitRead((String)MgConfService.class.getName(), MgConfService.class, () -> {
                    if (cacheData == null) {
                        MgConfService.loadData();
                    }
                });
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        if (!StrUtil.isBlank((CharSequence)(value = cacheData.get(name)))) {
            return value;
        }
        return defaultValue;
    }

    public static Integer getInt(String name, Integer defaultValue) {
        String value = MgConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static Byte getByte(String name, Byte defaultValue) {
        String value = MgConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Byte.parseByte(value);
    }

    public static Float getFloat(String name, Float defaultValue) {
        String value = MgConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Double getDouble(String name, Double defaultValue) {
        String value = MgConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    public static Boolean getBoolean(String name, String defaultValue, String trueValue) {
        String value = MgConfService.getString(name, defaultValue);
        return value.equalsIgnoreCase(trueValue);
    }

    public static Boolean getBoolean(String name, String defaultValue) {
        String value = MgConfService.getString(name, defaultValue);
        return value.equalsIgnoreCase("true");
    }

    public static Long getLong(String name, Long defaultValue) {
        String value = MgConfService.getString(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Long.parseLong(value);
    }

    public Ret list(String searchkey, Byte type) {
        if (StrUtil.isBlank((CharSequence)searchkey) && type == null) {
            return RetUtils.okList(confDao.find("select * from conf order by name"));
        }
        Kv params = Kv.create();
        if (type != null) {
            params.set((Object)"type", (Object)type);
        }
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%"));
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.conflist", (Map)params);
        return RetUtils.okList(confDao.find(sqlPara));
    }

    public Ret add(Conf conf) {
        if (StrUtil.isBlank((CharSequence)conf.getName())) {
            return RetUtils.failMsg("\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)conf.getValue())) {
            return RetUtils.failMsg("\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)conf.getTitle())) {
            return RetUtils.failMsg("\u914d\u7f6e\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String exist = MgConfService.getString(conf.getName(), null);
        if (StrUtil.isNotBlank((CharSequence)exist)) {
            return RetUtils.failMsg("\u53c2\u6570\u540d\u5df2\u5b58\u5728");
        }
        boolean save = conf.save();
        if (!save) {
            return RetUtils.failOper();
        }
        MgConfService.clearCache();
        return RetUtils.okOper();
    }

    public Ret update(Conf conf) {
        if (StrUtil.isBlank((CharSequence)conf.getName())) {
            return RetUtils.failMsg("\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean update = conf.update();
        if (!update) {
            return RetUtils.failOper();
        }
        MgConfService.clearCache();
        return RetUtils.okOper();
    }
}

