/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.mg;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.mg.MguserLoginStat;
import org.tio.mg.service.utils.PeriodUtils;
import org.tio.mg.service.utils.RetUtils;

public class MgLoginStatService {
    private static Logger log = LoggerFactory.getLogger(MgLoginStatService.class);
    public static final MgLoginStatService ME = new MgLoginStatService();

    public void loginTimeStat(Date date) {
        DateTime dateTime = DateUtil.offsetDay((Date)date, (int)-1);
        String dayPeriod = PeriodUtils.dateToPeriodByType((Date)dateTime, (byte)1);
        List records = Db.use((String)"tio_mg").find("select dayperiod,count(DISTINCT mguid) uidcount,count(1) logincount from mg_user_login_log where dayperiod =?", new Object[]{dayPeriod});
        if (CollectionUtil.isEmpty((Collection)records)) {
            return;
        }
        int usercount = ((Record)records.get(0)).getInt("uidcount");
        int totalcount = ((Record)records.get(0)).getInt("logincount");
        if (usercount == 0 || totalcount == 0) {
            return;
        }
        MguserLoginStat daystat = new MguserLoginStat();
        daystat.setMguid(-1);
        daystat.setDayperiod(dayPeriod);
        daystat.setUsercount(usercount);
        daystat.setTotalcount(totalcount);
        daystat.setRemark("\u5929\u7edf\u8ba1");
        daystat.replaceSave();
        List userLogins = Db.use((String)"tio_mg").find("select  mguid,count(1) logincount from mg_user_login_log where dayperiod = ? group by mguid", new Object[]{dayPeriod});
        if (CollectionUtil.isEmpty((Collection)userLogins)) {
            log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        for (Record userLogin : userLogins) {
            Integer uid = userLogin.getInt("mguid");
            int count = userLogin.getInt("logincount");
            List hourLogins = Db.use((String)"tio_mg").find("select hourperiod,count(1) hourcount from mg_user_login_log where dayperiod = ?  and mguid = ? group by hourperiod", new Object[]{dayPeriod, uid});
            if (CollectionUtil.isEmpty((Collection)hourLogins)) {
                log.error("\u767b\u5f55\u7edf\u8ba1\u5f02\u5e38\uff1a\u7528\u6237\u767b\u5f55\u8bb0\u5f55\u4e0d\u5b58\u5728-\u5c0f\u65f6");
                continue;
            }
            MguserLoginStat userStat = new MguserLoginStat();
            userStat.setMguid(uid);
            userStat.setDayperiod(dayPeriod);
            userStat.setTotalcount(count);
            for (Record hourLogin : hourLogins) {
                MgLoginStatService.dateToLoginStat(userStat, hourLogin.getStr("hourperiod"), hourLogin.getInt("hourcount"));
            }
            userStat.replaceSave();
            MguserLoginStat record = (MguserLoginStat)MguserLoginStat.dao.findFirst("select  * from mguser_login_stat where mguid = ? and dayperiod = -1", new Object[]{uid});
            if (record == null) {
                record = new MguserLoginStat();
                record.setMguid(uid);
                record.setDayperiod("-1");
                record.setUsercount(1);
                record.setTotalcount(count);
                record.setRemark("\u7528\u6237\u603b\u7edf\u8ba1");
                record.replaceSave();
                continue;
            }
            Db.use((String)"tio_mg").update("update mguser_login_stat set totalcount = totalcount + ? where id = ? ", new Object[]{count, record.getId()});
        }
    }

    public Ret statTimeList(Integer pageNumber, Integer pageSize, String starttime, String endtime) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)starttime)) {
            params.set((Object)"starttime", (Object)starttime);
        }
        if (StrUtil.isNotBlank((CharSequence)endtime)) {
            params.set((Object)"endtime", (Object)endtime);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.statTimeList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret statTimeUserList(Integer pageNumber, Integer pageSize, String period) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        if (StrUtil.isBlank((CharSequence)period)) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"dayperiod", (Object)period);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.statTimeUserList", (Map)params);
        Page list = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(list);
    }

    public Ret statLoginList(String period, Integer mguid) {
        if (StrUtil.isBlank((CharSequence)period) || mguid == null) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"dayperiod", (Object)period).set((Object)"mguid", (Object)mguid);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.statLoginList", (Map)params);
        List list = Db.use((String)"tio_mg").find(sqlPara);
        return RetUtils.okList(list);
    }

    public Ret statUserList(Integer pageNumber, Integer pageSize, String searchkey) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%"));
            params.set((Object)"searchid", (Object)searchkey);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.statUserList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret statUserDayList(Integer pageNumber, Integer pageSize, Integer mguid) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"mguid", (Object)mguid);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.statUserDayList", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret loginList(Integer pageNumber, Integer pageSize, String searchkey, String ip, String starttime, String endtime, Byte role) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)starttime)) {
            params.set((Object)"starttime", (Object)starttime);
        }
        if (StrUtil.isNotBlank((CharSequence)endtime)) {
            params.set((Object)"endtime", (Object)endtime);
        }
        if (StrUtil.isNotBlank((CharSequence)ip)) {
            params.set((Object)"searchip", (Object)ip);
        }
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%"));
            params.set((Object)"searchid", (Object)searchkey);
        }
        if (role != null) {
            params.set((Object)"rid", (Object)role);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mgloginstat.loginlist", (Map)params);
        Page records = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public static void dateToLoginStat(MguserLoginStat stat, String field, int value) {
        switch (field) {
            case "00": {
                stat.setHour0(value);
                break;
            }
            case "01": {
                stat.setHour1(value);
                break;
            }
            case "02": {
                stat.setHour2(value);
                break;
            }
            case "03": {
                stat.setHour3(value);
                break;
            }
            case "04": {
                stat.setHour4(value);
                break;
            }
            case "05": {
                stat.setHour5(value);
                break;
            }
            case "06": {
                stat.setHour6(value);
                break;
            }
            case "07": {
                stat.setHour7(value);
                break;
            }
            case "08": {
                stat.setHour8(value);
                break;
            }
            case "09": {
                stat.setHour9(value);
                break;
            }
            case "10": {
                stat.setHour10(value);
                break;
            }
            case "11": {
                stat.setHour11(value);
                break;
            }
            case "12": {
                stat.setHour12(value);
                break;
            }
            case "13": {
                stat.setHour13(value);
                break;
            }
            case "14": {
                stat.setHour14(value);
                break;
            }
            case "15": {
                stat.setHour15(value);
                break;
            }
            case "16": {
                stat.setHour16(value);
                break;
            }
            case "17": {
                stat.setHour17(value);
                break;
            }
            case "18": {
                stat.setHour18(value);
                break;
            }
            case "19": {
                stat.setHour19(value);
                break;
            }
            case "20": {
                stat.setHour20(value);
                break;
            }
            case "21": {
                stat.setHour21(value);
                break;
            }
            case "22": {
                stat.setHour22(value);
                break;
            }
            case "23": {
                stat.setHour23(value);
                break;
            }
        }
    }
}

