/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.mg;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgRole;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.mg.MgAuthService;
import org.tio.mg.service.utils.RetUtils;

public class MgRoleService {
    private static Logger log = LoggerFactory.getLogger(MgRoleService.class);
    public static final MgRoleService ME = new MgRoleService();

    public Ret list(Byte status) {
        Kv params = Kv.by((Object)"status", (Object)1);
        if (status != null) {
            params.set((Object)"rolestatus", (Object)status);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.rolelist", (Map)params);
        List list = Db.use((String)"tio_mg").find(sqlPara);
        return RetUtils.okList(list);
    }

    public Record userRoles(Integer mguid) {
        Kv params = Kv.by((Object)"mguid", (Object)mguid);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mguser.userRoles", (Map)params);
        Record record = Db.use((String)"tio_mg").findFirst(sqlPara);
        return record;
    }

    public Ret dictlist() {
        Kv params = Kv.by((Object)"status", (Object)1);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.roledict", (Map)params);
        List list = Db.use((String)"tio_mg").find(sqlPara);
        return RetUtils.okList(list);
    }

    public Ret add(MgRole role) {
        if (role == null || StrUtil.isBlank((CharSequence)role.getName())) {
            log.error("\u65b0\u589e\u89d2\u8272\uff0c\u53c2\u6570\u4e3a\u7a7a");
            return RetUtils.invalidParam();
        }
        boolean save = role.save();
        if (!save) {
            return RetUtils.failMsg("\u65b0\u589e\u5931\u8d25");
        }
        return RetUtils.okOper();
    }

    public Ret grant(final Integer rid, final String aids, String closeOperaids) {
        if (rid == null) {
            return RetUtils.invalidParam();
        }
        if (StrUtil.isBlank((CharSequence)aids) && StrUtil.isBlank((CharSequence)closeOperaids)) {
            return RetUtils.failMsg("\u8bf7\u9009\u62e9\u6743\u9650\u5217\u8868");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                MgAuthService.ME.delRidGrantList(rid);
                if (StrUtil.isNotBlank((CharSequence)aids)) {
                    MgAuthService.ME.initRidGrant(rid, "(" + aids + ")", (byte)1);
                }
                return true;
            }
        };
        boolean grant = Db.use((String)"tio_mg").tx((IAtom)atom);
        if (!grant) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public Ret roleAuthTree(Integer rid) {
        Kv params = Kv.by((Object)"status", (Object)1).set((Object)"rid", (Object)rid);
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("sys.roleAuthlist", (Map)params);
        List authlist = MgAuth.dao.find(sqlPara);
        if (CollectionUtil.isEmpty((Collection)authlist)) {
            return RetUtils.okData(new ArrayList());
        }
        short deep = ((MgAuth)((Object)authlist.get(0))).getDeep();
        ArrayList<MgAuth> treeList = new ArrayList<MgAuth>();
        HashedMap treeMap = new HashedMap();
        HashMap<String, MgAuth> menuMap = new HashMap<String, MgAuth>();
        for (MgAuth auth : authlist) {
            MgAuth menuAuth;
            if (Objects.equals(deep, auth.getDeep())) {
                treeList.add(auth);
                treeMap.put(auth.getId() + "", auth);
                if (!Objects.equals(auth.getType(), (byte)1)) continue;
                menuMap.put(auth.getId() + "", auth);
                continue;
            }
            MgAuth pAuth = (MgAuth)((Object)treeMap.get(auth.getPid() + ""));
            if (pAuth == null) {
                log.warn("\u83b7\u53d6\u6743\u9650\u6811\u8b66\u544a:\u6ca1\u6709\u4e0a\u7ea7\u83dc\u5355\u6216\u9875\u9762\uff1aid\uff1a{}\uff0cpid:{},name:{}", new Object[]{auth.getId(), auth.getPid(), auth.getName()});
                continue;
            }
            List<MgAuth> childs = pAuth.getChilds();
            if (childs == null) {
                childs = new ArrayList<MgAuth>();
                pAuth.setChilds(childs);
            }
            childs.add(auth);
            treeMap.put(auth.getId() + "", auth);
            if (Objects.equals(auth.getType(), (byte)1)) {
                menuMap.put(auth.getId() + "", auth);
            } else if (Objects.equals(auth.getType(), (byte)3)) continue;
            if ((menuAuth = (MgAuth)((Object)menuMap.get(auth.getPid() + ""))) == null) continue;
            menuAuth.setInchildids(menuAuth.getInchildids() + "," + auth.getId());
            while (menuAuth != null) {
                menuAuth.setChildids(menuAuth.getChildids() + "," + auth.getId());
                menuAuth = (MgAuth)((Object)menuMap.get(menuAuth.getPid() + ""));
            }
        }
        return RetUtils.okData(treeList);
    }

    public Ret update(MgRole role) {
        if (role == null || role.getId() == null || StrUtil.isBlank((CharSequence)role.getName())) {
            return RetUtils.invalidParam();
        }
        boolean update = role.update();
        if (!update) {
            return RetUtils.failMsg("\u4fee\u6539\u5931\u8d25");
        }
        return RetUtils.okOper();
    }

    public Ret del(final Integer rid) {
        MgRole role = (MgRole)MgRole.dao.findById(rid);
        if (role == null) {
            return RetUtils.failMsg("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                MgRoleService.this.delRoleUser(rid);
                MgRoleService.this.delRoleAuth(rid);
                boolean del = MgRole.dao.deleteById(rid);
                return del;
            }
        };
        boolean commit = Db.use((String)"tio_mg").tx((IAtom)atom);
        if (!commit) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).clear();
        return RetUtils.okOper();
    }

    public void delRoleAuth(Integer rid) {
        Db.use((String)"tio_mg").delete("delete from mg_role_auth where rid = ?", new Object[]{rid});
    }

    public void delRoleUser(Integer rid) {
        Db.use((String)"tio_mg").delete("delete from mg_user_role where rid = ?", new Object[]{rid});
    }
}

