/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.mg;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.mg.MgAuth;
import org.tio.mg.service.model.mg.MgRole;
import org.tio.mg.service.model.mg.MgUser;
import org.tio.mg.service.model.mg.MgUserBase;
import org.tio.mg.service.model.mg.MgUserRole;
import org.tio.mg.service.service.atom.AbsTxAtom;
import org.tio.mg.service.service.conf.MgConfService;
import org.tio.mg.service.service.mg.MgAuthService;
import org.tio.mg.service.service.mg.MgRoleService;
import org.tio.mg.service.utils.RetUtils;
import org.tio.mg.service.vo.MgAuthVo;
import org.tio.mg.service.vo.MgConst;
import org.tio.mg.service.vo.MgMenuVo;
import org.tio.mg.service.vo.MgUserAuthInfoVo;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class MgUserService {
    private static Logger log = LoggerFactory.getLogger(MgUserService.class);
    public static final MgUserService ME = new MgUserService();

    public Ret login(String loginname, String pd5) {
        String code = "code";
        if (StrUtil.isBlank((CharSequence)loginname)) {
            log.error("\u65e0\u6548\u53c2\u6570");
            return RetUtils.invalidParam().set((Object)"code", (Object)"1");
        }
        MgUser user = this.getByLoginname(loginname, null);
        if (user == null) {
            log.info("can find user by loginname:\u3010{}\u3011", (Object)loginname);
            return Ret.fail((Object)code, (Object)1);
        }
        if (!Objects.equals(pd5, user.getPwd())) {
            log.info("password is invalid, loginname:[{}], md5pwd:[{}], need md5pwd:[{}]", new Object[]{loginname, pd5, user.getPwd()});
            return Ret.fail((Object)code, (Object)2);
        }
        return RetUtils.okData((Object)user);
    }

    public MgUser getById(Integer id) {
        if (id == null) {
            return null;
        }
        MgUser user = (MgUser)MgUser.dao.findById(id);
        if (user == null || !Objects.equals(user.getStatus(), (byte)1)) {
            return null;
        }
        Record role = MgRoleService.ME.userRoles(id);
        if (role != null) {
            user.setRids(role.getStr("rids"));
            user.setRolename(role.getStr("rolename"));
        }
        return user;
    }

    public MgUser getByLoginname(String loginname, Byte status) {
        MgUser user = (MgUser)MgUser.dao.findFirst("select * from mg_user where loginname = ? and `status` <> ?", new Object[]{loginname, (byte)3});
        return user;
    }

    public MgUserAuthInfoVo getMgUserAuth(final Integer mguid) {
        final String rootPath = MgConfService.getString("mg.vue.root.path", "/");
        final String rootComponent = MgConfService.getString("mg.vue.root.component", "SystemPub");
        ICache cache = Caches.getCache(CacheConfig.MG_USER_MENU_AUTH);
        String key = mguid + "_";
        MgUserAuthInfoVo authInfoVo = (MgUserAuthInfoVo)CacheUtils.get((ICache)cache, (String)key, (boolean)false, (FirsthandCreater)new FirsthandCreater<MgUserAuthInfoVo>(){

            public MgUserAuthInfoVo create() {
                Kv params = Kv.by((Object)"mguid", (Object)mguid).set((Object)"status", (Object)1);
                SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mguser.mguserauth", (Map)params);
                List auth = MgAuth.dao.find(sqlPara);
                if (CollectionUtil.isEmpty((Collection)auth)) {
                    return null;
                }
                MgUserAuthInfoVo authInfoVo = new MgUserAuthInfoVo(mguid);
                ArrayList<MgMenuVo> userMenuList = authInfoVo.getMenuList();
                HashMap<String, MgMenuVo> menuMap = new HashMap<String, MgMenuVo>();
                HashMap<String, MgAuthVo> userallAuth = authInfoVo.getAllAuth();
                HashMap<String, MgAuthVo> useroperAuth = authInfoVo.getOperAuth();
                HashMap<String, MgAuthVo> usermenuAuth = authInfoVo.getMenuAuth();
                HashMap<String, MgAuthVo> userpageAuth = authInfoVo.getPageAuth();
                short topDeep = 1;
                for (MgAuth record : auth) {
                    MgMenuVo menuVo;
                    String routekey = record.getRoutekey();
                    String authurl = record.getAuthurl();
                    MgAuthVo mgAuthVo = new MgAuthVo();
                    mgAuthVo.setName(record.getName());
                    mgAuthVo.setType(record.getType());
                    mgAuthVo.setComponent(authurl);
                    mgAuthVo.setIcon(record.getIcon());
                    mgAuthVo.setPath(routekey);
                    if (Objects.equals(record.getDeep(), topDeep)) {
                        if (Objects.equals(record.getType(), (byte)2)) {
                            MgMenuVo virMenu = new MgMenuVo();
                            virMenu.setDeep(record.getDeep());
                            virMenu.setName("");
                            virMenu.setType(record.getType());
                            virMenu.setVirtualmenuflag((byte)1);
                            virMenu.setComponent(rootComponent);
                            virMenu.setPath(rootPath);
                            userMenuList.add(virMenu);
                            ArrayList<MgMenuVo> virChilds = new ArrayList<MgMenuVo>();
                            virMenu.setChilds(virChilds);
                            menuVo = new MgMenuVo();
                            menuVo.setId(record.getId());
                            menuVo.setDeep((short)(record.getDeep() + 1));
                            menuVo.setName(record.getName());
                            menuVo.setType(record.getType());
                            menuVo.setComponent(authurl);
                            menuVo.setIcon(record.getIcon());
                            menuVo.setPath(routekey);
                            menuVo.setLevelname(record.getName());
                            virChilds.add(menuVo);
                            menuMap.put(record.getId() + "", menuVo);
                        } else {
                            MgMenuVo menuVo2 = new MgMenuVo();
                            menuVo2.setId(record.getId());
                            menuVo2.setDeep(record.getDeep());
                            menuVo2.setName(record.getName());
                            menuVo2.setIcon(record.getIcon());
                            menuVo2.setType(record.getType());
                            menuVo2.setComponent(rootComponent);
                            menuVo2.setLevelname(record.getName());
                            menuVo2.setPath(rootPath);
                            userMenuList.add(menuVo2);
                            menuMap.put(record.getId() + "", menuVo2);
                        }
                    } else {
                        MgMenuVo pMenuVo = (MgMenuVo)menuMap.get(record.getPid() + "");
                        if (pMenuVo == null) {
                            log.error("\u83dc\u5355\u914d\u7f6e\u5f02\u5e38\uff1a\u51fa\u73b0\u7236\u8282\u70b9\u4e0d\u5b58\u5728\u7684\u914d\u7f6e\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\uff1aid:{},pid:{},mguid:{}", new Object[]{record.getId(), record.getPid(), mguid});
                            continue;
                        }
                        if (Objects.equals(record.getType(), (byte)3)) {
                            useroperAuth.put(authurl, mgAuthVo);
                            Map<String, MgAuthVo> menuOperAuth = pMenuVo.getOperAuth();
                            if (menuOperAuth == null) {
                                menuOperAuth = new HashMap<String, MgAuthVo>();
                                pMenuVo.setOperAuth(menuOperAuth);
                            }
                            menuOperAuth.put(authurl, mgAuthVo);
                            userallAuth.put(authurl, mgAuthVo);
                        } else {
                            List<MgMenuVo> childs = pMenuVo.getChilds();
                            if (childs == null) {
                                childs = new ArrayList<MgMenuVo>();
                                pMenuVo.setChilds(childs);
                            }
                            menuVo = new MgMenuVo();
                            menuVo.setId(record.getId());
                            menuVo.setDeep(record.getDeep());
                            menuVo.setName(record.getName());
                            menuVo.setIcon(record.getIcon());
                            menuVo.setComponent(authurl);
                            menuVo.setPath(routekey);
                            menuVo.setLevelname(pMenuVo.getLevelname() + "," + record.getName());
                            menuVo.setType(record.getType());
                            childs.add(menuVo);
                            menuMap.put(record.getId() + "", menuVo);
                        }
                    }
                    if (Objects.equals(record.getType(), (byte)1)) {
                        usermenuAuth.put(record.getId() + "", mgAuthVo);
                        continue;
                    }
                    if (!Objects.equals(record.getType(), (byte)2)) continue;
                    userallAuth.put(authurl, mgAuthVo);
                    userpageAuth.put(authurl, mgAuthVo);
                }
                List<MgAuth> operList = MgAuthService.ME.operlist("");
                if (CollectionUtil.isNotEmpty(operList)) {
                    for (MgAuth oper : operList) {
                        MgMenuVo pMenuVo = (MgMenuVo)menuMap.get(oper.getPid() + "");
                        if (pMenuVo == null) {
                            log.error("\u83dc\u5355\u914d\u7f6e\u5f02\u5e38\uff1a\u51fa\u73b0\u9875\u9762\u8282\u70b9\u4e0d\u5b58\u5728\u7684\u914d\u7f6e\uff0c\u5df2\u81ea\u52a8\u5ffd\u7565\uff1aid:{},pid:{},mguid:{}", new Object[]{oper.getId(), oper.getPid(), mguid});
                            continue;
                        }
                        String routekey = oper.getRoutekey();
                        String authurl = oper.getAuthurl();
                        if (useroperAuth.get(authurl) != null) continue;
                        MgAuthVo mgAuthVo = new MgAuthVo();
                        mgAuthVo.setName(oper.getName());
                        mgAuthVo.setType(oper.getType());
                        mgAuthVo.setComponent(authurl);
                        mgAuthVo.setIcon(oper.getIcon());
                        mgAuthVo.setPath(routekey);
                        mgAuthVo.setOperstatus((byte)2);
                        useroperAuth.put(authurl, mgAuthVo);
                        Map<String, MgAuthVo> menuOperAuth = pMenuVo.getOperAuth();
                        if (menuOperAuth == null) {
                            menuOperAuth = new HashMap<String, MgAuthVo>();
                            pMenuVo.setOperAuth(menuOperAuth);
                        }
                        menuOperAuth.put(authurl, mgAuthVo);
                        userallAuth.put(authurl, mgAuthVo);
                    }
                }
                return authInfoVo;
            }
        });
        return authInfoVo;
    }

    public Ret getMenu(Integer mguid) {
        MgUserAuthInfoVo authInfoVo = this.getMgUserAuth(mguid);
        if (authInfoVo == null || CollectionUtil.isEmpty(authInfoVo.getMenuList())) {
            return RetUtils.failMsg("\u6ca1\u6709\u5206\u914d\u6743\u9650");
        }
        return RetUtils.okData(authInfoVo.getMenuList());
    }

    public Ret userList(String searchKey, Integer rid, Byte status, Integer pageNumber, Integer pageSize) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (status != null) {
            params.set((Object)"status", (Object)status);
        } else {
            params.set((Object)"defaultstatus", (Object)3);
        }
        if (rid != null) {
            params.set((Object)"rid", (Object)rid);
        }
        if (StrUtil.isNotBlank((CharSequence)searchKey)) {
            params.set((Object)"searchkey", (Object)searchKey);
        }
        SqlPara sqlPara = Db.use((String)"tio_mg").getSqlPara("mguser.mguserlist", (Map)params);
        Page userPage = Db.use((String)"tio_mg").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(userPage);
    }

    public Ret resetPwd(Integer mguid) {
        if (mguid == null) {
            return RetUtils.invalidParam();
        }
        MgUser user = (MgUser)MgUser.dao.findById(mguid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String resetPwd = MgUserService.getMd5Pwd(user.getLoginname(), MgConst.MG_USER_DEFAULT_PWD);
        MgUser update = new MgUser();
        update.setId(user.getId());
        update.setPwd(resetPwd);
        boolean ret = update.update();
        if (!ret) {
            return RetUtils.failOper();
        }
        return RetUtils.okOper();
    }

    public Ret updatePwd(Integer mguid, String pwd, String newpwd) {
        MgUser user = (MgUser)MgUser.dao.findById(mguid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (!user.getPwd().equals(pwd)) {
            return RetUtils.failMsg("\u539f\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        MgUser update = new MgUser();
        update.setId(user.getId());
        update.setPwd(newpwd);
        boolean ret = update.update();
        if (!ret) {
            return RetUtils.failOper();
        }
        return RetUtils.okOper();
    }

    public Ret add(final MgUser user) {
        if (user == null) {
            return RetUtils.invalidParam();
        }
        if (StrUtil.isBlank((CharSequence)user.getRids())) {
            return RetUtils.failMsg("\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AbsTxAtom add = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                String[] ridStrs;
                boolean init = user.save();
                if (!init) {
                    return this.failRet("\u4fdd\u5b58\u5931\u8d25");
                }
                MgUserBase base = new MgUserBase();
                base.setMguid(user.getId());
                base.setRealname(user.getRealname());
                base.setPhone(user.getPhone());
                base.setDeptname(user.getDeptname());
                base.setPosition(user.getPosition());
                boolean baseInit = base.save();
                if (!baseInit) {
                    return this.failRet("\u9644\u5c5e\u4fe1\u606f\u4fdd\u5b58\u5f02\u5e38");
                }
                for (String ridStr : ridStrs = user.getRids().split(",")) {
                    Integer rid = Integer.parseInt(ridStr);
                    MgRole role = (MgRole)MgRole.dao.findById(rid);
                    if (role == null) {
                        log.error("\u521b\u5efa\u7528\u6237\u65f6\uff0c\u9009\u62e9\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
                        continue;
                    }
                    MgUserRole userRole = new MgUserRole();
                    userRole.setMguid(user.getId());
                    userRole.setRid(rid);
                    userRole.replaceSave();
                }
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_mg").tx((IAtom)add);
        if (!commit) {
            return add.getRetObj();
        }
        return RetUtils.okOper();
    }

    public Ret update(final MgUser user) {
        if (user.getId() == null) {
            return RetUtils.invalidParam();
        }
        AbsTxAtom atom = new AbsTxAtom(){

            @Override
            public boolean noTxRun() {
                boolean update = user.update();
                if (!update) {
                    return this.failRet("\u4fee\u6539\u5931\u8d25");
                }
                MgUserBase userBase = MgUserService.this.getBase(user.getId());
                MgUserBase baseUpdate = new MgUserBase();
                baseUpdate.setId(userBase.getId());
                baseUpdate.setPhone(MgUserService.this.strNull(user.getPhone()));
                baseUpdate.setRealname(MgUserService.this.strNull(user.getRealname()));
                baseUpdate.setDeptname(MgUserService.this.strNull(user.getDeptname()));
                baseUpdate.setPosition(MgUserService.this.strNull(user.getPosition()));
                boolean baseflag = baseUpdate.update();
                if (!baseflag) {
                    return this.failRet("\u9644\u5c5e\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
                }
                if (StrUtil.isNotBlank((CharSequence)user.getRids())) {
                    String[] ridStrs;
                    MgUserService.this.delUserRole(user.getId());
                    for (String ridStr : ridStrs = user.getRids().split(",")) {
                        Integer rid = Integer.parseInt(ridStr);
                        MgRole role = (MgRole)MgRole.dao.findById(rid);
                        if (role == null) {
                            log.error("\u4fee\u6539\u7528\u6237\u65f6\uff0c\u9009\u62e9\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
                            continue;
                        }
                        MgUserRole userRole = new MgUserRole();
                        userRole.setMguid(user.getId());
                        userRole.setRid(rid);
                        userRole.replaceSave();
                    }
                }
                return true;
            }
        };
        boolean commit = Db.use((String)"tio_mg").tx((IAtom)atom);
        if (!commit) {
            return atom.getRetObj();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).remove(user.getId() + "");
        return RetUtils.okOper();
    }

    public void delUserRole(Integer mguid) {
        Db.use((String)"tio_mg").delete("delete from mg_user_role where mguid = ?", new Object[]{mguid});
    }

    public String strNull(String str) {
        return StrUtil.isBlank((CharSequence)str) ? "" : str;
    }

    public MgUserBase getBase(Integer mguid) {
        return (MgUserBase)MgUserBase.dao.findFirst("select * from mg_user_base where mguid = ?", new Object[]{mguid});
    }

    public Ret del(Integer mguid) {
        MgUser user = (MgUser)MgUser.dao.findById(mguid);
        if (user == null) {
            return RetUtils.failMsg("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (Objects.equals(user.getStatus(), (byte)3)) {
            return RetUtils.failMsg("\u7528\u6237\u5df2\u5220\u9664");
        }
        MgUser update = new MgUser();
        update.setId(mguid);
        update.setStatus((byte)3);
        boolean del = update.update();
        if (!del) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_USER_MENU_AUTH).remove(mguid + "");
        return RetUtils.okOper();
    }

    public static String getMd5Pwd(String loginname, String plainpwd) {
        String pwd = SecureUtil.md5((String)("${" + StrUtil.trim((CharSequence)loginname) + "}" + StrUtil.trim((CharSequence)plainpwd)));
        return pwd;
    }
}

