/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.recharge;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.mg.service.model.main.RechargeItem;
import org.tio.mg.service.service.UserCoinService;
import org.tio.mg.service.service.atom.AbsAtom;
import org.tio.mg.service.service.atom.RechargeAtom;
import org.tio.mg.service.service.conf.MgConfService;

public class RechargeItemService {
    private static Logger log = LoggerFactory.getLogger(RechargeItemService.class);
    public static final RechargeItemService me = new RechargeItemService();
    public static final RechargeItem dao = (RechargeItem)new RechargeItem().dao();

    public boolean save(RechargeItem rechargeItem) {
        return rechargeItem.save();
    }

    public boolean update(RechargeItem rechargeItem) {
        return rechargeItem.update();
    }

    public RechargeItem selectByTradeno(String tradeno) {
        if (StrUtil.isBlank((CharSequence)tradeno)) {
            return null;
        }
        return (RechargeItem)RechargeItem.dao.findFirst("select * from recharge_item where tradeno = ?", new Object[]{tradeno});
    }

    public RechargeItem selectByReceipt(String receipt, Integer id) {
        if (StrUtil.isBlank((CharSequence)receipt)) {
            return null;
        }
        return (RechargeItem)RechargeItem.dao.findFirst("select * from recharge_item where receipt = ? and id != ?", new Object[]{receipt, id});
    }

    public void updateUserAndRecharge(RechargeItem rechargeItem) throws Exception {
        if (rechargeItem == null) {
            return;
        }
        Double amount = rechargeItem.getAmount();
        Integer uid = rechargeItem.getUserid();
        if (amount == null || uid == null) {
            return;
        }
        RechargeAtom rechare = new RechargeAtom(rechargeItem);
        boolean isRecharge = Db.use((String)"tio_site_main").tx((IAtom)rechare);
        if (!isRecharge) {
            log.error("\u5145\u503c\u66f4\u65b0\u8d22\u52a1\u5931\u8d25\uff1auid:{},amount:{},msg:{}", new Object[]{uid, amount, rechare.getMsg()});
            throw new RuntimeException(rechare.getMsg());
        }
    }

    public void attackRecharge(final RechargeItem rechargeItem) throws Exception {
        AbsAtom attackAtom = new AbsAtom(){

            public boolean run() throws SQLException {
                boolean update = RechargeItemService.this.update(rechargeItem);
                if (!update) {
                    log.error("\u653b\u51fb\u5145\u503c-\u8ba2\u5355\u6570\u636e\u4fee\u6539\u5931\u8d25\uff0c\u8ba2\u5355id:{}", (Object)rechargeItem.getId());
                    return false;
                }
                Double addCoin = NumberUtil.mul((double)rechargeItem.getAmount(), (float)MgConfService.getInt("cny.to.coin.time.ios", 70).intValue());
                boolean saveCoin = UserCoinService.me.addAttackcoin(rechargeItem.getUserid(), addCoin);
                if (!saveCoin) {
                    log.error("\u653b\u51fb\u5145\u503c-\u4fee\u6539\u8d22\u52a1\u4fe1\u606f\uff1a\u65e0\u6570\u636e\u66f4\u65b0\uff0c\u8ba2\u5355id:{}", (Object)rechargeItem.getId());
                }
                return true;
            }
        };
        Db.use((String)"tio_site_main").tx((IAtom)attackAtom);
    }

    public static void main(String[] args) {
    }
}

