/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.tioim;

import cn.hutool.core.util.StrUtil;
import com.google.common.base.Objects;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.model.main.WxApp;
import org.tio.mg.service.utils.RetUtils;

public class TioAppService {
    private static Logger log = LoggerFactory.getLogger(TioAppService.class);
    public static final TioAppService me = new TioAppService();

    public Ret appList(Integer pageNumber, Integer pageSize, String version, Byte mode, Byte type, Byte status) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)version)) {
            params.set((Object)"version", (Object)("%" + version + "%"));
        }
        if (mode != null) {
            params.set((Object)"updatemode", (Object)mode);
        }
        if (mode != null) {
            params.set((Object)"type", (Object)type);
        }
        if (mode != null) {
            params.set((Object)"status", (Object)status);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_main").getSqlPara("app.list", (Map)params);
        Page records = Db.use((String)"tio_site_main").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret add(WxApp app) {
        if (StrUtil.isBlank((CharSequence)app.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)app.getVersion())) {
            return RetUtils.failMsg("\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        if (app.getUpdatemode() == null) {
            return RetUtils.failMsg("\u66f4\u65b0\u6a21\u5f0f\u4e3a\u7a7a");
        }
        if (app.getType() == null) {
            return RetUtils.failMsg("\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (Objects.equal((Object)app.getType(), (Object)1) && StrUtil.isBlank((CharSequence)app.getFileurl())) {
            return RetUtils.failMsg("\u5b89\u5353\u5fc5\u987b\u4e0a\u4f20\u5b89\u88c5\u5305");
        }
        return RetUtils.saveRet(app);
    }

    public Ret update(WxApp app) {
        if (app.getId() == null) {
            log.error("\u4fee\u6539id\u4e3a\u7a7a");
            return RetUtils.failMsg("id\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)app.getName())) {
            return RetUtils.failMsg("\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)app.getVersion())) {
            return RetUtils.failMsg("\u7248\u672c\u53f7\u4e3a\u7a7a");
        }
        if (app.getUpdatemode() == null) {
            return RetUtils.failMsg("\u66f4\u65b0\u6a21\u5f0f\u4e3a\u7a7a");
        }
        if (app.getType() == null) {
            return RetUtils.failMsg("\u7c7b\u578b\u4e3a\u7a7a");
        }
        if (Objects.equal((Object)app.getType(), (Object)1) && StrUtil.isBlank((CharSequence)app.getFileurl())) {
            return RetUtils.failMsg("\u5b89\u5353\u5fc5\u987b\u4e0a\u4f20\u5b89\u88c5\u5305");
        }
        return RetUtils.upateRet(app);
    }

    public Ret del(Integer id) {
        WxApp app = (WxApp)WxApp.dao.findById(id);
        if (app == null) {
            return RetUtils.failMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        boolean update = WxApp.dao.deleteById(id);
        if (!update) {
            return RetUtils.failOper();
        }
        return RetUtils.okOper();
    }
}

