/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.tioim;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.filter.config.ConfigTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.mg.service.cache.CacheConfig;
import org.tio.mg.service.cache.Caches;
import org.tio.mg.service.model.conf.EmailServer;
import org.tio.mg.service.utils.EmailKit;
import org.tio.mg.service.utils.RetUtils;
import org.tio.utils.cache.CacheUtils;
import org.tio.utils.cache.FirsthandCreater;
import org.tio.utils.cache.ICache;

public class TioEmailService {
    private static Logger log = LoggerFactory.getLogger(TioEmailService.class);
    public static final TioEmailService me = new TioEmailService();
    private static int index = 0;
    static final EmailServer dao = (EmailServer)new EmailServer().dao();

    public List<EmailServer> getAll() {
        ICache cache = Caches.getCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5_LOCAL);
        String key = "EmailServerList";
        ArrayList list = (ArrayList)CacheUtils.get((ICache)cache, (String)key, (boolean)true, (FirsthandCreater)new FirsthandCreater<ArrayList<EmailServer>>(){

            public ArrayList<EmailServer> create() {
                ArrayList list = (ArrayList)dao.find("select * from email_server where status = 1");
                return list;
            }
        });
        return list;
    }

    public List<EmailServer> getAll(String searchKey) {
        if (StrUtil.isBlank((CharSequence)searchKey)) {
            ArrayList list = (ArrayList)dao.find("select * from email_server ");
            return list;
        }
        ArrayList list = (ArrayList)dao.find("select * from email_server where email like '%" + searchKey + "%'");
        return list;
    }

    public EmailServer next() {
        int i;
        List<EmailServer> list = this.getAll();
        if (list == null || list.size() == 0) {
            log.error("\u6ca1\u6709\u914d\u7f6e\u90ae\u7bb1\u670d\u52a1\u5668");
            return null;
        }
        if ((i = index++) >= list.size()) {
            index = 0;
            i = index++;
        }
        return list.get(i);
    }

    public Ret sendEmail(Integer startid, Integer endid, String title, String content) {
        if (startid == null || endid == null || StrUtil.isBlank((CharSequence)title) || StrUtil.isBlank((CharSequence)content)) {
            return RetUtils.invalidParam();
        }
        if (startid > endid) {
            return RetUtils.failMsg("\u8d77\u59cbid\u5927\u4e8e\u622a\u81f3id");
        }
        EmailServer emailServer = this.next();
        String emailPass = "";
        try {
            emailPass = EmailKit.getEmailUserPwd(emailServer.getPwd());
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        int sendCount = 0;
        List list = Db.use((String)"tio_site_main").find("select loginname from `user` where id >=? and id <=? and `status` = 1 and  loginname REGEXP '^[A-Z0-9._%-]+@[A-Z0-9.-]+.[A-Z]{2,4}$'", new Object[]{startid, endid});
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            for (Record record : list) {
                String loginName = record.getStr("loginname");
                EmailKit.sendEmail(emailServer.getServer(), emailServer.getEmail(), emailPass, loginName, title, content);
                ++sendCount;
            }
        }
        return RetUtils.okData("\u6210\u529f\u53d1\u9001\u90ae\u4ef6" + sendCount + "\u6b21");
    }

    public boolean exist(String email) {
        List records = dao.find("select * from email_server where email = ?", new Object[]{email});
        return CollectionUtil.isNotEmpty((Collection)records);
    }

    public Ret add(EmailServer emailServer) {
        if (StrUtil.isBlank((CharSequence)emailServer.getEmail())) {
            return RetUtils.failMsg("\u8d26\u53f7\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)emailServer.getServer())) {
            return RetUtils.failMsg("\u670d\u52a1\u5668\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)emailServer.getPwd())) {
            return RetUtils.failMsg("\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (this.exist(emailServer.getEmail())) {
            return RetUtils.failMsg("\u90ae\u4ef6\u670d\u52a1\u5df2\u5b58\u5728");
        }
        try {
            emailServer.setPwd(ConfigTools.encrypt((String)emailServer.getPwd()));
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
            return RetUtils.failMsg("\u52a0\u5bc6\u5931\u8d25");
        }
        boolean save = emailServer.save();
        if (!save) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5_LOCAL).clear();
        index = 0;
        return RetUtils.okOper();
    }

    public Ret update(EmailServer emailServer) {
        boolean update;
        if (StrUtil.isBlank((CharSequence)emailServer.getEmail())) {
            return RetUtils.failMsg("\u8d26\u53f7\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)emailServer.getServer())) {
            return RetUtils.failMsg("\u670d\u52a1\u5668\u4e3a\u7a7a");
        }
        if (StrUtil.isNotBlank((CharSequence)emailServer.getPwd())) {
            try {
                emailServer.setPwd(ConfigTools.encrypt((String)emailServer.getPwd()));
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
                return RetUtils.failMsg("\u52a0\u5bc6\u5931\u8d25");
            }
        }
        if (!(update = emailServer.update())) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5_LOCAL).clear();
        index = 0;
        return RetUtils.okOper();
    }

    public Ret del(String email) {
        if (StrUtil.isBlank((CharSequence)email)) {
            return RetUtils.failMsg("\u8d26\u53f7\u4e3a\u7a7a");
        }
        EmailServer emailServer = (EmailServer)dao.findById(email);
        if (emailServer == null) {
            return RetUtils.failMsg("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        boolean update = dao.deleteById(email);
        if (!update) {
            return RetUtils.failOper();
        }
        Caches.getCache(CacheConfig.MG_TIME_TO_LIVE_MINUTE_5_LOCAL).clear();
        index = 0;
        return RetUtils.okOper();
    }
}

