/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.service.tioim;

import cn.hutool.core.util.StrUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.kit.Kv;
import org.tio.jfinal.kit.Ret;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.Page;
import org.tio.jfinal.plugin.activerecord.SqlPara;
import org.tio.mg.service.utils.RetUtils;
import org.tio.utils.jfinal.P;

public class TioStatService {
    private static Logger log = LoggerFactory.getLogger(TioStatService.class);
    public static final TioStatService me = new TioStatService();

    public Ret userStatList(Integer pageNumber, Integer pageSize, String searchkey) {
        boolean allowOper;
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.create();
        if (StrUtil.isNotBlank((CharSequence)searchkey)) {
            params.set((Object)"searchkey", (Object)("%" + searchkey + "%"));
        }
        if (!(allowOper = P.getBoolean((String)"oper.open.flag", (Boolean)true).booleanValue())) {
            params.set((Object)"noemail", (Object)1);
        } else {
            params.set((Object)"email", (Object)1);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_stat").getSqlPara("stat.userstatlist", (Map)params);
        Page records = Db.use((String)"tio_site_stat").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret areadict() {
        List records = Db.use((String)"tio_site_stat").find("SELECT province, GROUP_CONCAT(city ORDER BY citychatindex SEPARATOR ',') citys FROM area_stat where type = 1 GROUP BY charindex");
        return RetUtils.okList(records);
    }

    public Ret userLoginCount(Integer uid) {
        Integer count = Db.use((String)"tio_site_stat").queryInt("select totalcount from user_time_login_stat where uid = ? and dayperiod = '-1'", new Object[]{uid});
        if (count == null || count < 0) {
            count = 0;
        }
        return RetUtils.okData(count);
    }

    public Ret ipRegisterCount(String ip) {
        Integer count = Db.use((String)"tio_site_stat").queryInt("select regcount from user_register_stat where type = 2 and statbizstr = ?", new Object[]{ip});
        if (count == null || count < 0) {
            count = 0;
        }
        return RetUtils.okData(count);
    }

    public Ret areaRegisterCount(String province, String city) {
        Integer count = Db.use((String)"tio_site_stat").queryInt("select bizcount from area_stat where province = ? and city = ?", new Object[]{province, city});
        if (count == null || count < 0) {
            count = 0;
        }
        return RetUtils.okData(count);
    }

    public Ret timeRegisterCount(String period) {
        Integer count = Db.use((String)"tio_site_stat").queryInt("select regcount from user_register_stat where type = 1 and statbizstr = ?", new Object[]{period});
        if (count == null || count < 0) {
            count = 0;
        }
        return RetUtils.okData(count);
    }

    public Ret userRegisterStat(Integer pageNumber, Integer pageSize, String start, String end, String searchip, Byte type, String province, String city, String order) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        if (type == null) {
            return RetUtils.invalidParam();
        }
        Kv params = Kv.by((Object)"type", (Object)type);
        if (Objects.equals(type, (byte)1)) {
            params.set((Object)"time", (Object)1);
        } else {
            params.set((Object)"ip", (Object)1);
            if (StrUtil.isBlank((CharSequence)order)) {
                order = "regcount";
            }
            params.set((Object)"order", (Object)order);
            if (StrUtil.isNotBlank((CharSequence)province)) {
                params.set((Object)"province", (Object)province);
            }
            if (StrUtil.isNotBlank((CharSequence)city)) {
                params.set((Object)"city", (Object)city);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)start)) {
            params.set((Object)"starttime", (Object)start);
        }
        if (StrUtil.isNotBlank((CharSequence)start)) {
            params.set((Object)"endtime", (Object)end);
        }
        if (StrUtil.isNotBlank((CharSequence)searchip)) {
            params.set((Object)"searchip", (Object)searchip);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_stat").getSqlPara("stat.userRegistList", (Map)params);
        Page records = Db.use((String)"tio_site_stat").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret groupStat(String starttime, String endtime, Integer pageNumber, Integer pageSize, Byte type) {
        if (type == null) {
            return RetUtils.invalidParam();
        }
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageSize <= 0) {
            pageSize = 16;
        }
        Kv params = Kv.by((Object)"type", (Object)type);
        if (StrUtil.isNotBlank((CharSequence)starttime)) {
            params.set((Object)"starttime", (Object)starttime);
        }
        if (StrUtil.isNotBlank((CharSequence)endtime)) {
            params.set((Object)"endtime", (Object)endtime);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_stat").getSqlPara("stat.groupstat", (Map)params);
        Page records = Db.use((String)"tio_site_stat").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }

    public Ret userIpTimeRegisterStat(Integer pageNumber, Integer pageSize, Integer ipid, String order) {
        if (pageNumber == null || pageNumber <= 0) {
            pageNumber = 1;
        }
        if (pageSize == null || pageNumber <= 0) {
            pageSize = 16;
        }
        if (StrUtil.isBlank((CharSequence)order)) {
            order = "statbizstr";
        }
        Kv params = Kv.by((Object)"ipid", (Object)ipid).set((Object)"type", (Object)3);
        if (StrUtil.isNotBlank((CharSequence)order)) {
            params.set((Object)"order", (Object)order);
        }
        SqlPara sqlPara = Db.use((String)"tio_site_stat").getSqlPara("stat.userIpTimeRegisterStat", (Map)params);
        Page records = Db.use((String)"tio_site_stat").paginate(pageNumber.intValue(), pageSize.intValue(), sqlPara);
        return RetUtils.okPage(records);
    }
}

