/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.timetask;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.druid.filter.config.ConfigTools;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.mg.service.tool.MysqlTool;
import org.tio.utils.date.DateFmt;
import org.tio.utils.jfinal.P;
import org.tio.utils.quartz.AbstractJobWithLog;

public class MySqlBackupJob
extends AbstractJobWithLog {
    private static Logger log = LoggerFactory.getLogger(MySqlBackupJob.class);
    public static MySqlBackupJob me = new MySqlBackupJob();
    public static String lastZipPath = null;
    private static final String PATTERN = "yyyy-MM-dd_HH_mm_ss";

    public void run(JobExecutionContext context) throws Exception {
        String time = DateFmt.of((String)PATTERN).format(LocalDateTime.now());
        String rootdir = P.get((String)"mysql.backup.backend.dir", (String)"d:/mysqlbackup/backend");
        File root = new File(rootdir);
        String dir = rootdir + "/" + time;
        FileUtil.mkdir((String)dir);
        String jdbcUrl = P.get((String)"tio_mg.jdbc.url");
        JdbcUrlSplitter jdbcUrlSplitter = new JdbcUrlSplitter(jdbcUrl);
        String username = P.get((String)"tio_mg.jdbc.username");
        String password = null;
        try {
            password = ConfigTools.decrypt((String)P.get((String)"tio_mg.jdbc.password"));
        }
        catch (Throwable e) {
            password = P.get((String)"tio_mg.jdbc.password");
        }
        String host = jdbcUrlSplitter.host;
        String port = jdbcUrlSplitter.port;
        String filePath = dir + "/tio_mg.sql";
        File backFile = MysqlTool.backup(host, Integer.parseInt(port), "tio_mg", username, password, filePath);
        String zipPath = rootdir + "/" + time + ".zip";
        ZipUtil.zip((String)dir, (String)zipPath);
        lastZipPath = zipPath;
        FileUtil.del((String)dir);
        File[] files = root.listFiles();
        if (files != null && files.length > 0) {
            Date nowDate = new Date();
            for (File file : files) {
                Path path = Paths.get(file.toURI());
                BasicFileAttributeView basicview = Files.getFileAttributeView(path, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
                BasicFileAttributes attr = basicview.readAttributes();
                Date createTimeDate = new Date(attr.creationTime().toMillis());
                long days = DateUtil.between((Date)nowDate, (Date)createTimeDate, (DateUnit)DateUnit.DAY);
                if (days <= 30L) continue;
                FileUtil.del((File)file);
            }
        }
    }

    public static class JdbcUrlUtil {
        public static String findDataBaseNameByUrl(String jdbcUrl) {
            int pos1;
            String database = null;
            if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
                throw new IllegalArgumentException("Invalid JDBC url.");
            }
            if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:impala")) {
                jdbcUrl = jdbcUrl.replace(":impala", "");
            }
            if (!jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
                throw new IllegalArgumentException("Invalid JDBC url.");
            }
            String connUri = jdbcUrl.substring(pos1 + 1);
            if (connUri.startsWith("//")) {
                int pos = connUri.indexOf(47, 2);
                if (pos != -1) {
                    database = connUri.substring(pos + 1);
                }
            } else {
                database = connUri;
            }
            if (database.contains("?")) {
                database = database.substring(0, database.indexOf("?"));
            }
            if (database.contains(";")) {
                database = database.substring(0, database.indexOf(";"));
            }
            if (StringUtils.isBlank((CharSequence)database)) {
                throw new IllegalArgumentException("Invalid JDBC url.");
            }
            return database;
        }
    }

    public static class JdbcUrlSplitter {
        public String driverName;
        public String host;
        public String port;
        public String database;
        public String params;

        public JdbcUrlSplitter(String jdbcUrl) {
            String connUri;
            int pos1;
            if (jdbcUrl == null || !jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
                throw new IllegalArgumentException("Invalid JDBC url.");
            }
            this.driverName = jdbcUrl.substring(5, pos1);
            int pos2 = jdbcUrl.indexOf(59, pos1);
            if (pos2 == -1) {
                connUri = jdbcUrl.substring(pos1 + 1);
            } else {
                connUri = jdbcUrl.substring(pos1 + 1, pos2);
                this.params = jdbcUrl.substring(pos2 + 1);
            }
            if (connUri.startsWith("//")) {
                int pos = connUri.indexOf(47, 2);
                if (pos != -1) {
                    this.host = connUri.substring(2, pos);
                    this.database = connUri.substring(pos + 1);
                    pos = this.host.indexOf(58);
                    if (pos != -1) {
                        this.port = this.host.substring(pos + 1);
                        this.host = this.host.substring(0, pos);
                    }
                }
            } else {
                this.database = connUri;
            }
        }
    }
}

