/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.tio;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.core.stat.IpStat;
import org.tio.core.stat.IpStatListener;
import org.tio.mg.service.model.stat.TioIpStat;
import org.tio.utils.json.Json;

public class TioSiteIpStatListener
implements IpStatListener {
    private static Logger log = LoggerFactory.getLogger(TioSiteIpStatListener.class);
    public static final TioSiteIpStatListener web_view = new TioSiteIpStatListener(11);
    public static final TioSiteIpStatListener web_api = new TioSiteIpStatListener(12);
    public static final TioSiteIpStatListener ws = new TioSiteIpStatListener(1);
    public static final TioSiteIpStatListener app = new TioSiteIpStatListener(2);
    private byte appType;

    private TioSiteIpStatListener(byte appType) {
        this.appType = appType;
    }

    public void onExpired(TioConfig tioConfig, IpStat ipStat) {
        TioIpStat tioIpStat = TioIpStat.from(tioConfig, ipStat, this.appType);
        if (tioIpStat != null) {
            tioIpStat.save();
        } else {
            log.error("{}, tioIpStat is null, ipStat is {}", (Object)tioConfig.getName(), (Object)Json.toJson((Object)ipStat));
        }
    }

    public static void main(String[] args) {
    }

    public byte getAppType() {
        return this.appType;
    }

    public void setAppType(byte appType) {
        this.appType = appType;
    }

    public void onDecodeError(ChannelContext channelContext, IpStat ipStat) {
    }

    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess, IpStat ipStat) throws Exception {
    }

    public void onAfterDecoded(ChannelContext channelContext, Packet packet, int packetSize, IpStat ipStat) throws Exception {
    }

    public void onAfterHandled(ChannelContext channelContext, Packet packet, IpStat ipStat, long cost) throws Exception {
    }

    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect, IpStat ipStat) throws Exception {
    }

    public void onAfterReceivedBytes(ChannelContext channelContext, int receivedBytes, IpStat ipStat) throws Exception {
    }
}

