/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.tool;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.jfinal.plugin.activerecord.Db;
import org.tio.jfinal.plugin.activerecord.IAtom;
import org.tio.jfinal.plugin.activerecord.Record;
import org.tio.utils.SystemTimer;

public class MysqlTool {
    private static Logger log = LoggerFactory.getLogger(MysqlTool.class);

    public static void toHistory(final String dbName, final String tableName) {
        Db.use((String)dbName).tx(new IAtom(){

            public boolean run() throws SQLException {
                String createSql = MysqlTool.showCreateSql(dbName, tableName);
                String tempTableName = tableName + "_temp";
                String tempCreatSql = StrUtil.replace((CharSequence)createSql, (CharSequence)("CREATE TABLE `" + tableName + "`"), (CharSequence)("CREATE TABLE `" + tempTableName + "`"));
                log.warn("\u5f00\u59cb\u521b\u5efa\u4e34\u65f6\u8868\r\n{}", (Object)tempCreatSql);
                Db.use((String)dbName).update(tempCreatSql);
                String newTableName = tableName + "_" + DateUtil.format((Date)new Date(SystemTimer.currTime), (String)"yyyyMMddHHmm") + "_x_his";
                String renameSql = "RENAME TABLE " + tableName + " to " + newTableName + ", " + tempTableName + " to " + tableName;
                log.warn("\u5f00\u59cb\u91cd\u547d\u540d\u8868\r\n{}", (Object)renameSql);
                Db.use((String)dbName).update(renameSql);
                return true;
            }
        });
    }

    public static String showCreateSql(String dbName, String tableName) {
        String sql = "show create table " + tableName;
        Record record = Db.use((String)dbName).findFirst(sql);
        String ct = record.getStr("Create Table");
        return ct;
    }

    public static File backup(String host, int port, String dbName, String username, String password, String filePath) {
        Long starttime = System.currentTimeMillis();
        try {
            File file = new File(filePath);
            String[] commands = new String[3];
            String os = System.getProperties().getProperty("os.name");
            if (os.startsWith("Win")) {
                commands[0] = "cmd.exe";
                commands[1] = "/c";
            } else {
                commands[0] = "/bin/sh";
                commands[1] = "-c";
            }
            StringBuilder mysqldump = new StringBuilder();
            mysqldump.append("mysqldump");
            mysqldump.append(" --opt");
            mysqldump.append(" --user=").append(username);
            mysqldump.append(" --password=").append("#####");
            mysqldump.append(" --host=").append(host);
            mysqldump.append(" --protocol=tcp");
            mysqldump.append(" --port=").append(port);
            mysqldump.append(" --default-character-set=utf8");
            mysqldump.append(" --single-transaction=TRUE");
            mysqldump.append(" --routines");
            mysqldump.append(" --events");
            mysqldump.append(" ").append(dbName);
            mysqldump.append(" > ");
            mysqldump.append("").append(filePath).append("");
            String command = mysqldump.toString();
            log.error(command);
            commands[2] = command = command.replaceAll("#####", password);
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(commands);
            if (process.waitFor() == 0) {
                Long endtime = System.currentTimeMillis();
                Long distance = endtime - starttime;
                log.error("\u3010" + dbName + "\u3011\u5907\u4efd\u6210\u529f\uff0c\u8017\u65f6\uff1a" + distance + "ms");
                return file;
            }
            InputStream is = process.getErrorStream();
            if (is != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(is, "utf-8"));
                StringBuilder sb = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    sb.append(line);
                }
                log.error("\u6570\u636e\u5e93\u3010" + dbName + "\u3011\u5907\u4efd\u5931\u8d25\r\n" + sb.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u3010" + dbName + "\u3011\u5907\u4efd\u5931\u8d25\u3002eror: " + e.getMessage(), (Throwable)e);
            return null;
        }
        return null;
    }
}

