/*
 * Decompiled with CFR 0.152.
 */
package org.tio.mg.service.utils;

import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.utils.json.Json;

public class OkHttpUtils {
    private static Logger log = LoggerFactory.getLogger(OkHttpUtils.class);
    private static MediaType jsonMedia = MediaType.parse((String)"application/json; charset=utf-8");

    public static Response postJson(String url, String paramsJson) throws Exception {
        try {
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)jsonMedia, (String)paramsJson);
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            return response;
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw e;
        }
    }

    public static Response get(String url) throws Exception {
        try {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url(url).build();
            Response response = client.newCall(request).execute();
            return response;
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw e;
        }
    }

    public static Response post(String url, Map<String, Object> params) throws Exception {
        return OkHttpUtils.postJson(url, Json.toJson(params));
    }

    public static <T> T post(String url, String params, Class<T> calssName) throws Exception {
        Response response = OkHttpUtils.postJson(url, params);
        Object object = Json.toBean((String)response.body().toString(), calssName);
        return (T)object;
    }

    public static <T> T post(String url, Map<String, Object> params, Class<T> calssName) throws Exception {
        Response response = OkHttpUtils.post(url, params);
        Object object = Json.toBean((String)response.body().toString(), calssName);
        return (T)object;
    }

    public static <T> T get(String url, Class<T> calssName) throws Exception {
        Response response = OkHttpUtils.get(url);
        Object object = Json.toBean((String)response.body().toString(), calssName);
        return (T)object;
    }
}

