/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import jakarta.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.batch.BasicBatchConfigurer;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.boot.autoconfigure.transaction.TransactionManagerCustomizers;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

public class JpaBatchConfigurer
extends BasicBatchConfigurer {
    private static final Log logger = LogFactory.getLog(JpaBatchConfigurer.class);
    private final EntityManagerFactory entityManagerFactory;

    protected JpaBatchConfigurer(BatchProperties properties, DataSource dataSource, TransactionManagerCustomizers transactionManagerCustomizers, EntityManagerFactory entityManagerFactory) {
        super(properties, dataSource, transactionManagerCustomizers);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    protected String determineIsolationLevel() {
        String name = super.determineIsolationLevel();
        if (name != null) {
            return name;
        }
        logger.warn((Object)"JPA does not support custom isolation levels, so locks may not be taken when launching Jobs. To silence this warning, set 'spring.batch.jdbc.isolation-level-for-create' to 'default'.");
        return BatchProperties.Isolation.DEFAULT.toIsolationName();
    }

    @Override
    protected PlatformTransactionManager createTransactionManager() {
        return new JpaTransactionManager(this.entityManagerFactory);
    }
}

