/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.jdbc.init.DataSourceInitializerDetector;
import org.springframework.boot.jdbc.init.DependsOnDataSourceInitializationDetector;
import org.springframework.boot.util.Instantiator;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class DataSourceInitializationDependencyConfigurer
implements ImportBeanDefinitionRegistrar {
    private final Environment environment;

    DataSourceInitializationDependencyConfigurer(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(DependsOnDataSourceInitializationPostProcessor.class.getName())) {
            return;
        }
        registry.registerBeanDefinition(DependsOnDataSourceInitializationPostProcessor.class.getName(), (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(DependsOnDataSourceInitializationPostProcessor.class, () -> new DependsOnDataSourceInitializationPostProcessor(this.environment)).getBeanDefinition());
    }

    static class DependsOnDataSourceInitializationPostProcessor
    implements BeanFactoryPostProcessor {
        private final Environment environment;

        DependsOnDataSourceInitializationPostProcessor(Environment environment) {
            this.environment = environment;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            Set<String> detectedDataSourceInitializers = this.detectDataSourceInitializers(beanFactory);
            for (String dependentDefinitionName : this.detectDependsOnDataSourceInitialization(beanFactory, this.environment)) {
                BeanDefinition definition = DependsOnDataSourceInitializationPostProcessor.getBeanDefinition(dependentDefinitionName, beanFactory);
                String[] dependencies = definition.getDependsOn();
                for (String dependencyName : detectedDataSourceInitializers) {
                    dependencies = StringUtils.addStringToArray((String[])dependencies, (String)dependencyName);
                }
                definition.setDependsOn(dependencies);
            }
        }

        private Set<String> detectDataSourceInitializers(ConfigurableListableBeanFactory beanFactory) {
            List<DataSourceInitializerDetector> detectors = this.instantiateDetectors(beanFactory, this.environment, DataSourceInitializerDetector.class);
            HashSet<String> detected = new HashSet();
            for (DataSourceInitializerDetector detector : detectors) {
                for (String initializerName : detector.detect(beanFactory)) {
                    detected.add(initializerName);
                    beanFactory.getBeanDefinition(initializerName).setAttribute(DataSourceInitializerDetector.class.getName(), (Object)detector.getClass().getName());
                }
            }
            detected = Collections.unmodifiableSet(detected);
            for (DataSourceInitializerDetector detector : detectors) {
                detector.detectionComplete(beanFactory, detected);
            }
            return detected;
        }

        private Collection<String> detectDependsOnDataSourceInitialization(ConfigurableListableBeanFactory beanFactory, Environment environment) {
            List<DependsOnDataSourceInitializationDetector> detectors = this.instantiateDetectors(beanFactory, environment, DependsOnDataSourceInitializationDetector.class);
            HashSet<String> dependentUponDataSourceInitialization = new HashSet<String>();
            for (DependsOnDataSourceInitializationDetector detector : detectors) {
                dependentUponDataSourceInitialization.addAll(detector.detect(beanFactory));
            }
            return dependentUponDataSourceInitialization;
        }

        private <T> List<T> instantiateDetectors(ConfigurableListableBeanFactory beanFactory, Environment environment, Class<T> detectorType) {
            List detectorNames = SpringFactoriesLoader.loadFactoryNames(detectorType, (ClassLoader)beanFactory.getBeanClassLoader());
            Instantiator instantiator = new Instantiator(detectorType, availableParameters -> availableParameters.add(Environment.class, environment));
            List detectors = instantiator.instantiate(detectorNames);
            return detectors;
        }

        private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
            try {
                return beanFactory.getBeanDefinition(beanName);
            }
            catch (NoSuchBeanDefinitionException ex) {
                BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
                if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                    return DependsOnDataSourceInitializationPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
                }
                throw ex;
            }
        }
    }
}

