/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@FunctionalInterface
public interface AutowiredArguments {
    @Nullable
    default public <T> T get(int index, Class<T> requiredType) {
        T value = this.get(index);
        Assert.isInstanceOf(requiredType, value);
        return value;
    }

    @Nullable
    default public <T> T get(int index) {
        return (T)this.toArray()[index];
    }

    default public Object getObject(int index) {
        return this.toArray()[index];
    }

    public Object[] toArray();

    public static AutowiredArguments of(Object[] arguments) {
        Assert.notNull((Object)arguments, (String)"Arguments must not be null");
        return () -> arguments;
    }
}

