/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import org.springframework.beans.factory.aot.BeanDefinitionPropertiesCodeGenerator;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.aot.InstanceSupplierCodeGenerator;
import org.springframework.beans.factory.aot.ResolvableTypeCodeGenerator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class DefaultBeanRegistrationCodeFragments
extends BeanRegistrationCodeFragments {
    private static final String BEAN_TYPE_VARIABLE = "beanType";
    private final BeanRegistrationsCode beanRegistrationsCode;
    private final RegisteredBean registeredBean;
    private final BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory;

    DefaultBeanRegistrationCodeFragments(BeanRegistrationsCode beanRegistrationsCode, RegisteredBean registeredBean, BeanDefinitionMethodGeneratorFactory beanDefinitionMethodGeneratorFactory) {
        this.beanRegistrationsCode = beanRegistrationsCode;
        this.registeredBean = registeredBean;
        this.beanDefinitionMethodGeneratorFactory = beanDefinitionMethodGeneratorFactory;
    }

    @Override
    public Class<?> getTarget(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
        Class<?> target = ClassUtils.getUserClass(constructorOrFactoryMethod.getDeclaringClass());
        while (target.getName().startsWith("java.") && registeredBean.isInnerBean()) {
            target = registeredBean.getParent().getBeanClass();
        }
        return target;
    }

    @Override
    public CodeBlock generateNewBeanDefinitionCode(GenerationContext generationContext, ResolvableType beanType, BeanRegistrationCode beanRegistrationCode) {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement(this.generateBeanTypeCode(beanType));
        builder.addStatement("$T $L = new $T($L)", new Object[]{RootBeanDefinition.class, "beanDefinition", RootBeanDefinition.class, BEAN_TYPE_VARIABLE});
        return builder.build();
    }

    private CodeBlock generateBeanTypeCode(ResolvableType beanType) {
        if (!beanType.hasGenerics()) {
            return CodeBlock.of((String)"$T<?> $L = $T.class", (Object[])new Object[]{Class.class, BEAN_TYPE_VARIABLE, ClassUtils.getUserClass((Class)beanType.toClass())});
        }
        return CodeBlock.of((String)"$T $L = $L", (Object[])new Object[]{ResolvableType.class, BEAN_TYPE_VARIABLE, ResolvableTypeCodeGenerator.generateCode(beanType)});
    }

    @Override
    public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
        return new BeanDefinitionPropertiesCodeGenerator(generationContext.getRuntimeHints(), attributeFilter, beanRegistrationCode.getMethodGenerator(), (name, value) -> this.generateValueCode(generationContext, (String)name, value)).generateCode(beanDefinition);
    }

    @Nullable
    protected CodeBlock generateValueCode(GenerationContext generationContext, String name, Object value) {
        RegisteredBean innerRegisteredBean = this.getInnerRegisteredBean(value);
        if (innerRegisteredBean != null) {
            BeanDefinitionMethodGenerator methodGenerator = this.beanDefinitionMethodGeneratorFactory.getBeanDefinitionMethodGenerator(innerRegisteredBean, name);
            Assert.state((methodGenerator != null ? 1 : 0) != 0, (String)"Unexpected filtering of inner-bean");
            MethodReference generatedMethod = methodGenerator.generateBeanDefinitionMethod(generationContext, this.beanRegistrationsCode);
            return generatedMethod.toInvokeCodeBlock(new CodeBlock[0]);
        }
        return null;
    }

    @Nullable
    private RegisteredBean getInnerRegisteredBean(Object value) {
        if (value instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)value;
            return RegisteredBean.ofInnerBean(this.registeredBean, beanDefinitionHolder);
        }
        if (value instanceof BeanDefinition) {
            BeanDefinition beanDefinition = (BeanDefinition)value;
            return RegisteredBean.ofInnerBean(this.registeredBean, beanDefinition);
        }
        return null;
    }

    @Override
    public CodeBlock generateSetBeanInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, CodeBlock instanceSupplierCode, List<MethodReference> postProcessors) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (postProcessors.isEmpty()) {
            builder.addStatement("$L.setInstanceSupplier($L)", new Object[]{"beanDefinition", instanceSupplierCode});
            return builder.build();
        }
        builder.addStatement("$T $L = $L", new Object[]{ParameterizedTypeName.get(InstanceSupplier.class, (Type[])new Type[]{this.registeredBean.getBeanClass()}), "instanceSupplier", instanceSupplierCode});
        for (MethodReference postProcessor : postProcessors) {
            builder.addStatement("$L = $L.andThen($L)", new Object[]{"instanceSupplier", "instanceSupplier", postProcessor.toCodeBlock()});
        }
        builder.addStatement("$L.setInstanceSupplier($L)", new Object[]{"beanDefinition", "instanceSupplier"});
        return builder.build();
    }

    @Override
    public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, Executable constructorOrFactoryMethod, boolean allowDirectSupplierShortcut) {
        return new InstanceSupplierCodeGenerator(generationContext, beanRegistrationCode.getClassName(), beanRegistrationCode.getMethodGenerator(), allowDirectSupplierShortcut).generateCode(this.registeredBean, constructorOrFactoryMethod);
    }

    @Override
    public CodeBlock generateReturnCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("return $L", new Object[]{"beanDefinition"});
        return builder.build();
    }
}

