/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.util.Arrays;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;

final class ResolvableTypeCodeGenerator {
    private ResolvableTypeCodeGenerator() {
    }

    public static CodeBlock generateCode(ResolvableType resolvableType) {
        return ResolvableTypeCodeGenerator.generateCode(resolvableType, false);
    }

    private static CodeBlock generateCode(ResolvableType resolvableType, boolean allowClassResult) {
        if (ResolvableType.NONE.equals((Object)resolvableType)) {
            return CodeBlock.of((String)"$T.NONE", (Object[])new Object[]{ResolvableType.class});
        }
        Class type = ClassUtils.getUserClass((Class)resolvableType.toClass());
        if (resolvableType.hasGenerics()) {
            return ResolvableTypeCodeGenerator.generateCodeWithGenerics(resolvableType, type);
        }
        if (allowClassResult) {
            return CodeBlock.of((String)"$T.class", (Object[])new Object[]{type});
        }
        return CodeBlock.of((String)"$T.forClass($T.class)", (Object[])new Object[]{ResolvableType.class, type});
    }

    private static CodeBlock generateCodeWithGenerics(ResolvableType target, Class<?> type) {
        ResolvableType[] generics = target.getGenerics();
        boolean hasNoNestedGenerics = Arrays.stream(generics).noneMatch(ResolvableType::hasGenerics);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("$T.forClassWithGenerics($T.class", new Object[]{ResolvableType.class, type});
        for (ResolvableType generic : generics) {
            builder.add(", $L", new Object[]{ResolvableTypeCodeGenerator.generateCode(generic, hasNoNestedGenerics)});
        }
        builder.add(")", new Object[0]);
        return builder.build();
    }
}

