/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingBiFunction;
import org.springframework.util.function.ThrowingSupplier;

@FunctionalInterface
public interface InstanceSupplier<T>
extends ThrowingSupplier<T> {
    default public T getWithException() {
        throw new IllegalStateException("No RegisteredBean parameter provided");
    }

    public T get(RegisteredBean var1) throws Exception;

    default public <V> InstanceSupplier<V> andThen(ThrowingBiFunction<RegisteredBean, ? super T, ? extends V> after) {
        Assert.notNull(after, (String)"After must not be null");
        return registeredBean -> after.applyWithException((Object)registeredBean, this.get(registeredBean));
    }

    public static <T> InstanceSupplier<T> using(ThrowingSupplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null");
        if (supplier instanceof InstanceSupplier) {
            InstanceSupplier instanceSupplier = (InstanceSupplier)supplier;
            return instanceSupplier;
        }
        return registeredBean -> supplier.getWithException();
    }

    public static <T> InstanceSupplier<T> of(InstanceSupplier<T> instanceSupplier) {
        Assert.notNull(instanceSupplier, (String)"InstanceSupplier must not be null");
        return instanceSupplier;
    }
}

