/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.messaging.rsocket.DefaultRSocketRequester;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

final class DefaultRSocketRequesterBuilder
implements RSocketRequester.Builder {
    private List<Consumer<RSocketFactory.ClientRSocketFactory>> factoryConfigurers = new ArrayList<Consumer<RSocketFactory.ClientRSocketFactory>>();
    @Nullable
    private RSocketStrategies strategies;
    private List<Consumer<RSocketStrategies.Builder>> strategiesConfigurers = new ArrayList<Consumer<RSocketStrategies.Builder>>();

    DefaultRSocketRequesterBuilder() {
    }

    @Override
    public RSocketRequester.Builder rsocketFactory(Consumer<RSocketFactory.ClientRSocketFactory> configurer) {
        this.factoryConfigurers.add(configurer);
        return this;
    }

    @Override
    public RSocketRequester.Builder rsocketStrategies(@Nullable RSocketStrategies strategies) {
        this.strategies = strategies;
        return this;
    }

    @Override
    public RSocketRequester.Builder rsocketStrategies(Consumer<RSocketStrategies.Builder> configurer) {
        this.strategiesConfigurers.add(configurer);
        return this;
    }

    @Override
    public Mono<RSocketRequester> connectTcp(String host, int port) {
        return this.connect((ClientTransport)TcpClientTransport.create((String)host, (int)port));
    }

    @Override
    public Mono<RSocketRequester> connectWebSocket(URI uri) {
        return this.connect((ClientTransport)WebsocketClientTransport.create((URI)uri));
    }

    @Override
    public Mono<RSocketRequester> connect(ClientTransport transport) {
        return Mono.defer(() -> {
            RSocketStrategies strategies = this.getRSocketStrategies();
            MimeType dataMimeType = this.getDefaultDataMimeType(strategies);
            RSocketFactory.ClientRSocketFactory factory = RSocketFactory.connect();
            if (dataMimeType != null) {
                factory.dataMimeType(dataMimeType.toString());
            }
            this.factoryConfigurers.forEach(configurer -> configurer.accept(factory));
            return factory.transport(transport).start().map(rsocket -> new DefaultRSocketRequester((RSocket)rsocket, dataMimeType, strategies));
        });
    }

    private RSocketStrategies getRSocketStrategies() {
        if (this.strategiesConfigurers.isEmpty()) {
            return this.strategies != null ? this.strategies : RSocketStrategies.builder().build();
        }
        RSocketStrategies.Builder strategiesBuilder = this.strategies != null ? this.strategies.mutate() : RSocketStrategies.builder();
        this.strategiesConfigurers.forEach(configurer -> configurer.accept(strategiesBuilder));
        return strategiesBuilder.build();
    }

    @Nullable
    private MimeType getDefaultDataMimeType(RSocketStrategies strategies) {
        return strategies.encoders().stream().flatMap(encoder -> encoder.getEncodableMimeTypes().stream()).filter(MimeType::isConcrete).findFirst().orElseGet(() -> strategies.decoders().stream().flatMap(encoder -> encoder.getDecodableMimeTypes().stream()).filter(MimeType::isConcrete).findFirst().orElse(null));
    }
}

