/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.rsocket;

import io.netty.buffer.ByteBuf;
import io.rsocket.Payload;
import io.rsocket.util.ByteBufPayload;
import io.rsocket.util.DefaultPayload;
import java.nio.ByteBuffer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;

abstract class PayloadUtils {
    PayloadUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataBuffer retainDataAndReleasePayload(Payload payload, DataBufferFactory bufferFactory) {
        try {
            if (bufferFactory instanceof NettyDataBufferFactory) {
                ByteBuf byteBuf = payload.sliceData().retain();
                NettyDataBuffer nettyDataBuffer = ((NettyDataBufferFactory)bufferFactory).wrap(byteBuf);
                return nettyDataBuffer;
            }
            DataBuffer dataBuffer = bufferFactory.wrap(payload.getData());
            return dataBuffer;
        }
        finally {
            if (payload.refCnt() > 0) {
                payload.release();
            }
        }
    }

    public static Payload createPayload(DataBuffer metadata, DataBuffer data) {
        if (metadata instanceof NettyDataBuffer && data instanceof NettyDataBuffer) {
            return ByteBufPayload.create((ByteBuf)((NettyDataBuffer)data).getNativeBuffer(), (ByteBuf)((NettyDataBuffer)metadata).getNativeBuffer());
        }
        if (metadata instanceof DefaultDataBuffer && data instanceof DefaultDataBuffer) {
            return DefaultPayload.create((ByteBuffer)((DefaultDataBuffer)data).getNativeBuffer(), (ByteBuffer)((DefaultDataBuffer)metadata).getNativeBuffer());
        }
        return DefaultPayload.create((ByteBuffer)data.asByteBuffer(), (ByteBuffer)metadata.asByteBuffer());
    }

    public static Payload createPayload(DataBuffer data) {
        if (data instanceof NettyDataBuffer) {
            return ByteBufPayload.create((ByteBuf)((NettyDataBuffer)data).getNativeBuffer());
        }
        if (data instanceof DefaultDataBuffer) {
            return DefaultPayload.create((ByteBuffer)((DefaultDataBuffer)data).getNativeBuffer());
        }
        return DefaultPayload.create((ByteBuffer)data.asByteBuffer());
    }
}

